/**
 * Copyright zendenmushi ( http://wonderfl.net/user/zendenmushi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2TK7
 */

package {
	// from http://www.ideaxidea.com/  posted on 2010-03-29
	// http://www.youtube.com/watch?v=kkGeOWYOFoA&feature
	// 2010/3/30 23:33 modified もう少しひまわりの種に近づけてみた
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import frocessing.core.F5BitmapData2D;
	
    [SWF(width=465,height=465,backgroundColor=0,flameRate=30)]
	public class Main extends Sprite
	{
		private var canvas : F5BitmapData2D;
		private var bmp : Bitmap;
		private var items : Vector.<Shot> = new Vector.<Shot>;
		private var colorTrans : ColorTransform = new ColorTransform(0.99, 0.9, 0.9, 0.9);
		private var freep : int = -1;
		private const itemlimit : int = 5000;
		
		
		public function Main() : void
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event=null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, enterFrame);
			
			canvas = new F5BitmapData2D(465,465,false,0);
			bmp = new Bitmap(canvas.bitmapData);
			addChild(bmp);
		}
		
		private function newItem(x : Number, y : Number ,dx : Number, dy : Number) : Shot
		{
			var cnt : int = items.length;
			if (((itemlimit > 0) && cnt >= itemlimit) && (freep >= cnt-1)) return null;
			
			freep++;

			if (freep == cnt) {
				items[cnt] = new Shot();
			}
			items[freep].index = freep;
			items[freep].visible = true;
			items[freep].x = x;
			items[freep].y = y;
			items[freep].dx = dx;
			items[freep].dy = dy;
			items[freep].tx = x + dx * 32;
			items[freep].ty = y + dy * 32;
			items[freep].r = 4;
			items[freep].cc = 1.0;
			
			return items[freep];
		}
		private function remove(index : int) : void
		{
			var cnt : int = items.length;
			var temp : Shot = items[index];
			var lastp : int = freep;

			temp.visible = false;
			if (lastp != index) {
				items[index] = items[lastp];
				items[index].index = index;
				items[lastp] = temp;
			}
			freep = lastp - 1;
			
		}
		
		private var rad : Number = 0;
		private function enterFrame(e:Event):void 
		{
			var i : int, s : Shot, ccoef : Number;
			
			var dx : Number = Math.cos(rad), dy : Number = Math.sin(rad);
			newItem(stage.stageWidth/2, stage.stageHeight/2, dx, dy);
			
			canvas.bitmapData.colorTransform(canvas.bitmapData.rect, colorTrans);
			canvas.beginDraw();
			for ( i = freep; i >= 0; i--) {
				s = items[i];
				s.tx += s.dx/3;
				s.ty += s.dy/3;
				s.x += (s.tx - s.x) / 10;
				s.y += (s.ty - s.y) / 10;
				s.r += 0.008;
				ccoef = s.cc;
				s.cc *= 0.9999;
				canvas.stroke(0xcf*ccoef, 0xcf*ccoef, 0x00*ccoef, 0xcf*ccoef);
				canvas.circle(s.x+0.5, s.y+0.5, s.r+0.5);
				canvas.stroke(0xdf*ccoef, 0xff*ccoef, 0xff*ccoef, 0xff*ccoef);
				canvas.circle(s.x, s.y, s.r);
				
				
				if ((s.x < -s.r) || (s.x > stage.stageWidth + s.r) || (s.y < -s.r) || (s.y > stage.stageHeight + s.r)) {
					remove(i);
				}
			}
			canvas.endDraw();
			
			rad += 137.5*Math.PI/180;
		}
	}
}

class Shot
{
	public var x : Number;
	public var y : Number;
	public var dx : Number;
	public var dy : Number;
	public var tx : Number;
	public var ty : Number;
	public var r : Number;
	public var cc : Number;
	public var index : int;
	public var visible : Boolean = false;
}
