/**
 * Copyright phi16 ( http://wonderfl.net/user/phi16 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2SvE
 */

// forked from phi16's Feynman Point
// forked from phi16's Template
    
package {
    import flash.text.TextField;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    public class Tp extends Sprite {
        public var spr:Sprite=new Sprite();
        public var keyPush:Array=new Array();
        public var keyDone:Array=new Array();
        public var items:Array=new Array();
        public var losts:Array=new Array();
        public var pi:Array=new Array(
            1,4,1,5,9,2,6,5,3,5,8,9,7,9,3,2,3,8,4,6,2,6,4,3,3,8,3,2,7,9,5,0,2,8,8,4,1,9,7,1,6,9,3,9,9,3,7,5,1,0,5,8,2,0,9,7,4,9,4,4,5,9,2,3,0,7,8,1,6,4,0,6,2,8,6,2,0,8,9,9,8,6,2,8,0,3,4,8,2,5,3,4,2,1,1,7,0,6,7,9,8,2,1,4,8,0,8,6,5,1,3,2,8,2,3,0,6,6,4,7,0,9,3,8,4,4,6,0,9,5,5,0,5,8,2,2,3,1,7,2,5,3,5,9,4,0,8,1,2,8,4,8,1,1,1,7,4,5,0,2,8,4,1,0,2,7,0,1,9,3,8,5,2,1,1,0,5,5,5,9,6,4,4,6,2,2,9,4,8,9,5,4,9,3,0,3,8,1,9,6,4,4,2,8,8,1,0,9,7,5,6,6,5,9,3,3,4,4,6,1,2,8,4,7,5,6,4,8,2,3,3,7,8,6,7,8,3,1,6,5,2,7,1,2,0,1,9,0,9,1,4,5,6,4,8,
            5,6,6,9,2,3,4,6,0,3,4,8,6,1,0,4,5,4,3,2,6,6,4,8,2,1,3,3,9,3,6,0,7,2,6,0,2,4,9,1,4,1,2,7,3,7,2,4,5,8,7,0,0,6,6,0,6,3,1,5,5,8,8,1,7,4,8,8,1,5,2,0,9,2,0,9,6,2,8,2,9,2,5,4,0,9,1,7,1,5,3,6,4,3,6,7,8,9,2,5,9,0,3,6,0,0,1,1,3,3,0,5,3,0,5,4,8,8,2,0,4,6,6,5,2,1,3,8,4,1,4,6,9,5,1,9,4,1,5,1,1,6,0,9,4,3,3,0,5,7,2,7,0,3,6,5,7,5,9,5,9,1,9,5,3,0,9,2,1,8,6,1,1,7,3,8,1,9,3,2,6,1,1,7,9,3,1,0,5,1,1,8,5,4,8,0,7,4,4,6,2,3,7,9,9,6,2,7,4,9,5,6,7,3,5,1,8,8,5,7,5,2,7,2,4,8,9,1,2,2,7,9,3,8,1,8,3,0,1,1,9,4,9,1,2,9,8,3,3,6,7,3,3,6,2,
            4,4,0,6,5,6,6,4,3,0,8,6,0,2,1,3,9,4,9,4,6,3,9,5,2,2,4,7,3,7,1,9,0,7,0,2,1,7,9,8,6,0,9,4,3,7,0,2,7,7,0,5,3,9,2,1,7,1,7,6,2,9,3,1,7,6,7,5,2,3,8,4,6,7,4,8,1,8,4,6,7,6,6,9,4,0,5,1,3,2,0,0,0,5,6,8,1,2,7,1,4,5,2,6,3,5,6,0,8,2,7,7,8,5,7,7,1,3,4,2,7,5,7,7,8,9,6,0,9,1,7,3,6,3,7,1,7,8,7,2,1,4,6,8,4,4,0,9,0,1,2,2,4,9,5,3,4,3,0,1,4,6,5,4,9,5,8,5,3,7,1,0,5,0,7,9,2,2,7,9,6,8,9,2,5,8,9,2,3,5,4,2,0,1,9,9,5,6,1,1,2,1,2,9,0,2,1,9,6,0,8,6,4,0,3,4,4,1,8,1,5,9,8,1,3,6,2,9,7,7,4,7,7,1,3,0,9,9,6,0,5,1,8,7,0,7,2,1,1,3,4,9,9,9,9,9,9);
        public var time:int=0;
        public var i:int=0;
        public var gameStarted:Boolean=false;
        public var rCols:Array=new Array();
        public var speed:int=0;
        public var tef:TextField=new TextField();
        public function Tp(){
            addChild(spr);
            addEventListener(Event.ENTER_FRAME,frame);
            addEventListener(MouseEvent.MOUSE_UP,mouseUp);
            addEventListener(MouseEvent.MOUSE_MOVE,mouseMove);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,keyUp);
            for(i=0;i<10;i++)keyPush.push(false),keyDone.push(false),rCols.push(Rainbow(i*36));
            tef.defaultTextFormat=new TextFormat("メイリオ",80,0xffffff);
            tef.autoSize=TextFieldAutoSize.RIGHT;
            tef.x=0;
            tef.y=100;
            tef.width=430;
            tef.height=465;
            tef.text="Speed:1\nStart:0";
            tef.alpha=0.3;
            addChild(tef);
        }
        public function frame(e:Event):void{
            spr.graphics.clear();
            spr.graphics.beginFill(0x000000);
            spr.graphics.drawRect(0,0,465,465);
            spr.graphics.endFill();
            for(i=0;i<10;i++){
                var t:int=i==0?9*40+52:(i-1)*40+52;
                if(keyPush[i]){
                    spr.graphics.lineStyle(5,rCols[i],0.5);
                    spr.graphics.moveTo(t,0);
                    spr.graphics.lineTo(t,465);
                }
                spr.graphics.lineStyle(2,rCols[i],1);
                spr.graphics.moveTo(t,0);
                spr.graphics.lineTo(t,465);
            }
            if(gameStarted){
                if(items.length>0){
                    var isPushup:Boolean=items[0].y<30;
                    for(i=0;i<items.length;i++){
                        var r:Item=items[i];
                        r.draw(spr,i==0);
                        r.y+=speed+(isPushup?10:0);
                        if(r.y>465){
                            reset();
                            gameStarted=false;
                        }
                    }
                    if(keyPush[items[0].dig] && !keyDone[items[0].dig]){
                        tef.appendText(String(items[0].dig));
                        if(tef.text.length>10)tef.text=tef.text.substr(tef.text.length-10,10);
                        items[0].del(spr),keyDone[items[0].dig]=true;
                        losts.push(items[0]);
                        items.shift();
                        if(items.length==0){
                            reset();
                            gameStarted=false;
                        }
                    }
                }else{
                    reset();
                    gameStarted=false;
                }
                for(i=0;i<losts.length;i++){
                    var ls:Item=losts[i];
                    ls.durs++;
                    ls.draw(spr,true);
                    if(ls.durs>20)losts.shift();
                }
            }else{
                for(i=0;i<15;i++){
                    var y:int=i*30+22;
                    spr.graphics.lineStyle(2,0xffffff,1);
                    spr.graphics.moveTo(0,y);
                    spr.graphics.lineTo(465,y);
                }
            }
            time++;
        }
        public function reset():void{
            var s:Item;
            for each(s in items){
                s.del(spr);
            }
            for each(s in losts){
                s.del(spr);
            }
            losts=new Array();
            items=new Array();
            tef.defaultTextFormat=new TextFormat("メイリオ",80,0xffffff);
            tef.text="Speed:1\nStart:0";
        }
        public function keyDown(e:KeyboardEvent):void{
            var c:int=e.keyCode;
            if(48<=c && c<=57)keyPush[c-48]=true;
            if(c==Keyboard.ESCAPE)reset(),gameStarted=false;
        }
        public function keyUp(e:KeyboardEvent):void{
            var c:int=e.keyCode;
            if(48<=c && c<=57)keyPush[c-48]=false,keyDone[c-48]=false;
        }
        public function mouseUp(e:MouseEvent):void{
            if(gameStarted)return;
            var mx:Number=mouseX,my:Number=mouseY;
            mx=(mx-52)/40;
            my=(my-22)/30;
            mx+=0.5;
            my+=0.5;
            var px:int=mx,py:int=my;
            if(px>=0 && py>=0 && py<=15){
                speed=(px+1)*4;
                if(py==0){
                    items.push(new Item(3,0,0,spr));
                    for(i=0;i<pi.length;i++){
                        items.push(new Item(pi[i],i+1,-(i+1)*(speed*20),spr));
                    }
                }else{
                    var start:int=py*10+190;
                    for(i=0;i<10;i++){
                        items.push(new Item(pi[i+start],i+1+start,-(i+1)*(speed*20),spr));
                    }
                }
                tef.defaultTextFormat=new TextFormat("メイリオ",200,0xffffff);
                tef.text="";
                gameStarted=true;
            }
        }
        public function mouseMove(e:MouseEvent):void{
            if(gameStarted)return;
            tef.defaultTextFormat.size=80;
            var mx:Number=mouseX,my:Number=mouseY;
            mx=(mx-52)/40;
            my=(my-22)/30;
            mx+=0.5;
            my+=0.5;
            var px:int=mx,py:int=my;
            if(px>=0 && py>=0 && py<=15){
                speed=(px+1)*4;
                var start:int=py*10+190;
                if(py==0)start=0;
                tef.text="Speed:"+String(speed/4)+"\nStart:"+String(start);
            }
        }
    }
}
import flash.text.TextFormat;
import flash.text.TextField;
import flash.display.Sprite;

class Item {
    public var dig:int;
    public var idx:int;
    public var t:int;
    public var y:int;
    public var stf:TextField=new TextField();
    public var dtf:TextField=new TextField();
    public var enable:Boolean=false;
    public var durs:int=0;
    public var col:int=0;
    public function Item(d:int,ix:int,sv:int,spr:Sprite){
        dig=d;
        idx=ix;
        y=sv;
        t=dig==0?9*40+52:(dig-1)*40+52;
        col=Rainbow(dig*360/10);
        stf.defaultTextFormat=new TextFormat("メイリオ",15,0xffffff);
        stf.x=0;
        stf.y=-40;
        stf.width=100;
        stf.height=40;
        stf.text=String(idx);
        dtf.defaultTextFormat=new TextFormat("メイリオ",30,col);
        dtf.x=t-12;
        dtf.y=-40;
        dtf.width=100;
        dtf.height=40;
        dtf.text=String(dig);
    }
    public function draw(spr:Sprite,lig:Boolean):void{
        if(y<-20 || y>480){
            del(spr);
            enable=false;
            return;
        }
        if(!enable){
            spr.addChild(stf);
            spr.addChild(dtf);
            enable=true;
        }
        var dep:Number=1-durs/20;
        if(lig){
            spr.graphics.lineStyle(5,0xffffff,0.5*dep);
            spr.graphics.beginFill(0x000000,dep);
            spr.graphics.drawCircle(t,y,20+durs);
            spr.graphics.endFill();
            spr.graphics.lineStyle(2,0xffffff,dep);
            spr.graphics.drawCircle(t,y,20+durs);
        }else{
            spr.graphics.beginFill(0x000000,dep);
            spr.graphics.lineStyle(2,0xffffff,dep);
            spr.graphics.drawCircle(t,y,20+durs);
            spr.graphics.endFill();
        }
        stf.y=y-13;
        dtf.y=y-23;
    }
    public function del(spr:Sprite):void{
        if(enable){
            spr.removeChild(stf);
            spr.removeChild(dtf);
        }
    }
}

function Rainbow(ra:Number):int{
    var colr:int,colg:int,colb:int;
    colr=(Math.sin(ra*Math.PI/180)+1)*255/2;
    colg=(Math.sin((ra+120)*Math.PI/180)+1)*255/2;
    colb=(Math.sin((ra-120)*Math.PI/180)+1)*255/2;
    return colr*256*256+colg*256+colb;
}
