/**
 * Copyright kenta ( http://wonderfl.net/user/kenta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2SVx
 */

package {

    import flash.display.*;
    import flash.events.*;

    [SWF(width="400",height="300",frameRate="24",backgroundColor="#FFFFFF")]            
    public class Test3D01 extends Sprite {

        private var panel:Sprite;
        private var centerX:Number = stage.width/2; // 中心点のx座標をステージの横中央に
        private var centerY:Number = stage.height/2; // 中心点のy座標をステージの縦中央に
        private var centerZ:Number = 0; // 中心点の座標を設定
        private var fl:int = 300; // 視点からの焦点(screen)までの距離を設定
        private var r:int = 100; // 回転の半径
        private var angle:Number = 0; // 回転角の初期値
        private var px:Number;
        private var py:Number;
        private var pz:Number;
        private var rad:Number;
        private var scale:Number;
        
        function Test3D01() {

            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;

            addEventListener(Event.ENTER_FRAME, loop);

            init();

        }

        private function init():void {
            panel = new Sprite();
            panel.graphics.beginFill(0x000000);
            panel.graphics.drawRect(0,0,50,50);            
            addChild(panel);
        }

        private function loop(e:Event):void {
            
            angle += 5;
            rad = angle / 180 * Math.PI; // 角度をラジアンに変換
            px = Math.cos(rad)*r; // 半径、ラジアンをもとに仮想3D空間のx座標を計算
            py = 0;
            pz = centerZ - Math.sin(rad) * r; // 半径、ラジアンをもとに仮想3D空間のz座標を計算
            scale = fl / (fl+pz); // 透視変換の比率を計算
            panel.x = px* scale  + centerX;
            panel.y = py  + centerY;
            panel.scaleX = panel.scaleY = scale;
            
            panel.x += 150;
            panel.y += 150;

        }
    }
}
