/**
 * Copyright aomoriringo ( http://wonderfl.net/user/aomoriringo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2S6B
 */

// forked from seikai's ソートの可視化
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
        
	[SWF(width = 465, height = 465, frameRate = 50, backgroundColor=0xFFFFFF)]
	public class Main extends Sprite
	{
		private var _data:Vector.<uint>;
		
		private var _pixelData:Vector.<Recode>;
		
		private var _bmd:BitmapData;
		
		private var _pointer1:Sprite;
		private var _pointer2:Sprite;
		
		private const W:uint = 90;
		private const H:uint = 90;
		private const SIZE:uint = 5;
		
		
		public function Main()
		{
			if(stage){
				_init();
			}else {
				addEventListener(Event.ADDED_TO_STAGE, _init);
			}
		}
		
		private function _init(e:Event = null):void {
			_bmd = new BitmapData(W, H);
			var canvas:Bitmap = new Bitmap(_bmd);
			canvas.width = W * SIZE;
			canvas.height = H * SIZE;
			addChild(canvas);
			
			createData();
			
			_pointer1 = new Sprite();
			_pointer1.graphics.beginFill(0xFF0000);
			_pointer1.graphics.drawRect(0, 0, SIZE, SIZE);
			addChild(_pointer1);
			
			_pointer2 = new Sprite();
			_pointer2.graphics.beginFill(0x00FF00);
			_pointer2.graphics.drawRect(0, 0, SIZE, SIZE);
			addChild(_pointer2);
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function createData():void 
		{
			var len:uint = W*H;
			var i:uint = 0,j:uint,k:uint,v:uint;
			_data = new Vector.<uint>(len);
			_pixelData = new Vector.<Recode>();
			_bmd.lock();
			for(j = 0;j<H;j++) {
				for(k = 0;k<W;k++){
					v = 255 | (uint(Math.random() * 255) << 8) | uint(Math.random() * 255);
					_bmd.setPixel(k, j, v);
					_data[i] = v;
					i++;
				}
			}
			_bmd.unlock();
			_sort(0, len-1);
			_pixelData.reverse();
		}
		
		private function enterFrameHandler(e:Event):void
		{
			if(_pixelData.length){
				_pixcelSwap(_pixelData.pop(), _pixelData.pop());
			} else {
				removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
				removeChild(_pointer1);
				removeChild(_pointer2);
			}
		}
		
		private function _sort(l:int, u:int):void
		{
			if (l >= u) return;
			var i:int, m:int, c:int;
			c = int((l + u)/2);
			_swap(c, l);
			m = l;
			for(i = l+1; i <= u; i++){
				if(_data[i] < _data[l]) {
					m++;
					_swap(i,m);
				}            
			}
			_swap(l,m);
			
			_sort(l, m-1);
			_sort(m + 1, u);
		}
		
		private function _swap(n1:int, n2:int):void
		{
			var tmp:int = _data[n1];
			_data[n1] = _data[n2];
			_data[n2] = tmp;
			
			var xp:int = n1%W;
			var yp:int = int(n1/W);
			_pixelData.push(new Recode(xp, yp, _data[n1]));
			xp = n2%W;
			yp = int(n2/W);
			_pixelData.push(new Recode(xp, yp, _data[n2]));
		}
		
		private function _pixcelSwap(data1:Recode, data2:Recode):void {
			_bmd.setPixel(data1.x, data1.y, data1.color);
			_bmd.setPixel(data2.x, data2.y, data2.color);
			_pointer1.x = data1.x * SIZE;
			_pointer1.y = data1.y * SIZE;
			_pointer2.x = data2.x * SIZE;
			_pointer2.y = data2.y * SIZE;
		}
		
	}
}
class Recode{
	public var x:int;
	public var y:int;
	public var color:uint;
	public function Recode(x:int, y:int ,color:uint){
		this.x = x;
		this.y = y;
		this.color = color;
	}
}