/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2S1d
 */

/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    
    
    public class Professional extends Sprite {
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //generate bitmap pattern.
            var pattern:BitmapData = logo();
            
            var g:Graphics = graphics;
            g.beginBitmapFill(pattern);
            g.drawRect(0,0,480,480);
            g.endFill();
        }
        
        //most simple patern
        public function logo():BitmapData{
            return BitmapPatternBuilder.build(
                [[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,0,0,0,0,0,0],
[0,0,0,0,0,0,0,0,0,4,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,1,5,0,4,0,0,0,0,0],
[0,0,0,0,6,0,0,0,0,7,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,5,7,7,7,0,4,0,0,0,0,0],
[0,0,0,0,6,4,0,9,10,7,8,11,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,10,11,9,12,7,0,6,0,0,0,0,0],
[0,0,0,0,6,8,12,13,14,15,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,19,20,21,22,23,13,9,9,0,0,0,0,0],
[0,0,0,0,8,12,12,24,25,26,27,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,30,30,30,30,30,30,30,30,31,30,31,26,32,33,12,9,7,0,0,0,0],
[0,0,0,8,34,23,35,27,36,37,37,38,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,40,40,40,40,40,40,40,40,39,39,39,39,39,39,39,39,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,42,43,42,42,44,45,46,47,48,0,0,0,0],
[0,0,7,8,47,15,49,42,36,50,37,51,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,43,43,43,43,43,43,43,43,50,43,53,50,40,44,32,13,12,8,0,0,0],
[0,0,7,12,47,35,54,51,36,51,55,52,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,43,43,43,43,43,43,43,43,43,43,43,43,43,50,43,51,56,43,57,58,59,60,8,7,0,0],
[0,0,7,12,61,62,54,51,36,51,55,52,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,51,53,43,63,64,65,60,8,7,0,0],
[0,6,8,60,66,67,68,51,36,51,36,52,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,53,43,63,64,69,66,12,7,0,0],
[0,6,48,60,66,67,68,51,36,51,36,52,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,56,56,43,43,43,41,53,43,63,64,22,66,12,8,0,0],
[0,6,48,70,71,67,55,43,36,50,36,52,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,43,43,43,43,36,36,36,36,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,56,56,43,56,72,41,56,72,73,64,22,66,12,8,0,0],
[0,6,48,70,71,67,55,43,43,50,36,43,36,36,36,36,36,36,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,56,56,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,56,56,72,56,72,41,56,72,73,64,22,66,12,8,0,0],
[0,6,48,70,71,67,55,43,43,50,53,43,36,36,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,56,56,56,56,43,43,43,43,43,43,43,43,56,56,43,43,43,43,43,72,43,43,43,43,72,72,72,72,72,72,72,72,72,72,72,72,56,72,72,56,72,73,74,22,66,12,8,0,0],
[0,6,48,70,71,75,52,43,43,50,53,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,56,56,56,56,56,56,56,56,43,43,43,43,43,43,72,72,56,56,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,56,72,72,76,72,73,77,22,71,12,8,0,0],
[0,6,78,70,71,79,52,72,43,50,53,43,43,43,43,43,43,43,43,43,80,80,43,43,72,43,72,43,56,56,56,56,56,56,56,56,72,72,72,72,72,72,72,72,56,56,80,80,72,72,72,42,72,80,72,72,76,72,72,72,72,72,72,72,72,72,72,72,76,72,72,76,72,81,77,22,71,12,8,0,0],
[0,6,78,70,71,79,52,72,43,56,53,43,43,43,43,43,43,43,43,43,40,80,72,43,72,43,43,80,56,56,56,56,56,56,56,56,72,72,72,72,72,72,72,72,57,41,42,80,72,72,72,80,72,80,72,57,57,72,72,72,72,72,72,72,72,72,72,72,76,72,72,76,72,81,77,22,71,12,8,0,0],
[0,6,78,70,71,79,51,72,72,56,72,43,72,72,72,72,72,72,72,72,76,76,72,56,72,80,43,80,56,56,56,56,56,56,56,56,72,72,72,72,72,72,72,72,72,82,42,72,72,72,72,83,57,83,72,76,57,72,72,72,72,72,72,72,72,72,72,72,76,72,72,76,84,81,77,22,71,12,8,0,0],
[0,6,78,70,71,79,51,72,72,56,72,43,72,72,72,72,72,72,72,72,83,76,40,56,56,80,85,80,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,80,76,42,86,83,86,82,87,86,83,72,76,83,72,72,86,72,72,72,72,72,72,72,85,76,85,85,76,84,88,77,22,71,12,8,0,0],
[0,6,78,70,71,79,51,72,72,56,72,72,72,72,72,72,72,72,72,72,41,76,72,76,56,72,72,80,57,57,57,57,57,57,57,57,83,83,83,83,83,83,83,83,57,76,72,86,37,37,40,38,37,40,72,41,83,86,72,86,85,85,85,85,85,86,86,86,76,85,85,76,84,88,77,22,71,12,8,0,0],
[0,6,78,70,71,79,51,85,83,76,72,72,72,72,72,72,72,72,72,72,83,57,72,72,82,82,72,89,57,57,57,57,57,57,57,57,83,83,83,83,83,83,83,83,82,90,91,86,92,93,94,95,95,96,97,41,83,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,84,88,98,22,71,12,8,0,0],
[0,6,78,70,71,79,51,85,83,76,72,72,72,72,72,72,72,72,72,72,76,57,86,82,82,40,99,89,85,85,85,85,85,86,86,86,83,83,83,83,83,83,83,83,99,72,100,72,101,102,103,103,103,104,105,40,83,90,86,85,86,86,86,86,86,86,86,86,86,86,86,86,84,106,98,22,71,12,8,0,0],
[0,6,78,70,71,79,51,86,83,76,72,72,72,72,72,72,72,72,72,72,85,90,72,86,72,107,108,102,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,110,111,57,72,112,102,104,113,114,104,105,40,100,90,86,90,86,86,86,86,86,86,86,86,86,86,86,86,84,106,98,22,71,12,8,0,0],
[0,6,78,70,115,79,41,86,86,83,82,86,85,85,85,85,85,85,85,85,86,90,85,86,86,116,109,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,117,56,91,84,92,102,118,104,104,119,120,121,100,90,100,90,86,86,86,86,86,86,86,86,86,86,122,86,123,106,124,22,71,12,8,0,0],
[0,6,78,70,115,125,41,86,90,83,86,86,86,86,86,86,86,86,86,86,86,90,85,86,86,116,109,104,118,119,118,118,104,104,113,104,104,104,104,104,104,104,104,104,126,76,91,84,101,102,118,127,104,119,120,121,100,90,100,90,86,86,86,86,86,86,86,86,86,123,122,86,123,106,124,22,71,12,8,0,0],
[0,6,78,70,115,125,72,86,90,83,86,86,86,86,86,86,86,86,86,86,86,90,85,86,86,116,128,104,113,119,118,118,104,104,104,129,104,104,104,104,104,104,104,104,126,76,91,90,101,102,118,127,104,119,130,116,131,90,100,90,86,86,86,86,86,86,86,86,86,123,122,86,132,106,124,22,71,12,8,0,0],
[0,6,78,70,115,125,72,86,90,83,86,86,86,86,86,86,86,86,86,86,86,90,85,86,86,133,128,119,113,104,118,102,134,135,135,135,136,136,136,136,136,136,136,136,137,76,91,90,101,117,102,127,119,119,130,116,122,90,100,90,122,122,122,122,122,122,122,122,122,123,132,122,132,138,139,22,71,12,8,0,0],
[0,6,78,70,115,125,72,86,90,86,86,86,86,86,86,86,86,86,86,86,86,123,131,86,86,133,128,119,140,119,119,108,141,56,53,142,53,53,53,53,53,53,53,53,36,89,132,84,143,117,118,140,109,119,130,116,122,90,100,90,132,132,132,132,132,132,132,132,132,123,132,132,132,138,139,22,71,12,8,0,0],
[0,6,78,70,144,125,72,122,123,131,86,86,86,86,86,86,86,86,86,86,86,123,131,86,86,133,145,119,140,140,140,108,85,123,123,100,100,100,100,100,100,100,122,122,90,132,122,84,143,146,109,109,109,147,148,133,122,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,149,138,139,22,71,12,8,0,0],
[0,6,78,70,144,125,72,122,123,131,123,86,86,86,86,123,123,123,123,123,86,123,131,86,86,150,145,109,140,127,140,108,85,123,123,131,100,100,100,100,100,100,122,122,151,132,122,152,143,146,109,109,109,147,148,133,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,149,138,153,22,71,12,8,0,0],
[0,6,78,70,144,125,84,122,123,131,123,86,123,123,123,123,123,123,123,123,86,123,131,122,86,150,145,109,93,147,102,154,85,132,123,132,132,132,132,132,132,132,132,132,151,132,122,152,143,146,109,109,109,147,148,133,132,132,149,132,132,132,132,132,132,132,132,132,132,155,132,132,149,138,153,22,71,12,8,0,0],
[0,6,78,70,144,125,84,132,123,131,132,122,123,123,123,123,123,132,132,132,151,151,131,132,123,150,145,109,93,109,102,145,90,132,156,132,132,132,132,151,151,132,132,132,132,132,122,152,157,146,109,109,128,128,148,150,132,132,149,151,132,132,132,132,132,132,132,132,132,155,132,132,149,158,153,22,144,12,8,0,0],
[0,6,78,70,144,125,84,132,151,131,132,122,123,123,123,123,123,132,132,132,132,151,131,132,132,150,159,109,109,147,102,136,90,132,132,132,132,132,132,151,151,132,132,132,132,155,151,152,157,146,109,109,128,128,148,150,132,132,149,151,151,151,151,151,151,151,155,155,160,155,132,132,149,158,153,22,144,12,8,0,0],
[0,6,78,70,144,161,84,132,151,132,132,122,151,151,151,151,151,132,132,132,132,151,132,132,132,150,159,109,95,147,109,136,90,132,132,132,132,132,132,151,151,160,160,160,162,163,162,162,164,165,134,134,134,159,96,166,167,168,168,169,168,169,169,170,162,162,162,162,160,155,155,132,149,158,153,22,144,12,8,0,0],
[0,6,78,70,71,171,84,132,151,132,132,151,151,151,151,151,132,132,132,132,132,151,132,132,132,172,159,128,95,147,173,135,90,132,174,163,169,169,175,175,175,175,175,175,176,176,176,169,177,165,134,134,134,159,96,166,176,169,168,175,168,169,169,176,176,176,176,176,176,176,168,168,163,178,179,22,144,12,8,0,0],
[0,6,78,70,71,171,100,132,155,132,132,151,151,151,151,151,132,132,132,132,132,151,132,155,151,172,159,128,95,128,108,159,180,180,180,180,181,182,181,182,182,182,175,181,180,163,170,169,177,165,134,159,134,159,96,166,176,169,168,175,176,169,169,169,169,169,169,169,169,176,169,176,175,183,184,22,144,12,8,0,0],
[0,6,78,70,71,171,100,160,155,132,155,151,151,151,151,151,132,132,132,155,151,155,160,162,162,106,185,159,134,110,134,186,187,188,189,188,189,190,188,190,190,189,189,191,157,163,167,169,177,165,134,159,134,192,96,166,176,169,168,175,169,169,169,169,169,169,169,169,169,176,169,176,175,183,184,69,144,12,8,0,0],
[0,6,78,70,71,171,100,160,155,132,155,151,151,151,151,151,151,155,193,155,168,169,168,175,169,106,194,134,135,159,134,128,187,192,192,145,195,134,159,134,134,134,135,191,157,163,167,169,177,165,134,159,134,192,96,166,176,169,168,175,169,169,169,169,169,169,169,169,169,176,169,176,169,183,184,69,144,12,8,0,0],
[0,6,78,70,71,171,100,160,155,132,155,151,151,151,160,162,162,169,176,182,168,169,168,175,169,106,194,134,145,159,134,128,187,159,195,195,192,145,159,145,134,134,135,188,196,163,167,169,177,197,134,159,134,192,96,166,176,169,168,169,169,169,169,169,169,169,169,169,198,176,169,176,169,199,184,69,144,12,8,0,0],
[0,6,78,70,71,171,100,160,155,132,155,151,170,169,169,176,176,169,169,169,175,169,169,169,169,174,200,134,134,159,110,128,187,126,145,145,192,134,159,134,134,134,135,188,201,169,167,163,202,197,134,134,134,159,96,156,170,169,168,169,169,169,169,169,169,169,169,169,169,169,169,162,169,199,184,69,144,12,8,0,0],
[0,6,78,70,71,171,100,160,155,193,163,169,169,169,169,169,169,169,169,169,169,169,169,169,169,174,200,134,134,159,110,197,203,137,187,137,194,194,159,134,194,134,194,188,112,169,167,163,164,197,134,134,134,159,96,156,170,169,163,169,169,169,169,169,169,169,169,169,169,169,169,162,169,199,184,69,144,12,8,0,0],
[0,6,78,70,71,171,100,167,169,176,168,169,169,169,169,169,169,169,169,169,169,169,169,169,169,174,200,134,145,159,159,110,204,99,85,90,90,100,86,86,100,90,90,123,205,169,167,163,164,197,159,134,134,159,96,156,170,169,163,169,170,170,170,170,170,170,170,170,169,169,169,162,169,199,184,69,144,12,8,0,0],
[0,6,78,70,71,206,155,207,169,176,168,169,169,169,169,169,169,169,169,169,169,169,169,169,169,174,200,134,145,159,159,185,155,168,198,163,169,168,163,163,168,168,169,169,170,163,167,163,164,197,159,134,134,159,96,156,170,169,163,169,170,170,170,170,170,170,170,170,163,169,198,162,169,199,184,69,144,12,8,0,0],
[0,6,78,70,71,206,155,168,169,170,168,169,169,169,169,169,169,169,169,169,169,163,169,169,169,174,200,159,159,159,159,190,155,169,170,169,169,168,163,163,168,168,169,169,170,163,167,163,164,197,159,134,159,159,96,156,162,163,198,170,170,170,170,170,170,170,170,170,163,169,162,162,169,199,208,69,144,12,8,0,0],
[0,6,78,70,71,206,155,168,169,170,168,169,169,169,169,169,169,169,169,169,170,163,169,169,169,174,200,159,159,159,159,190,155,198,170,170,170,170,163,163,170,170,170,169,170,163,162,163,164,197,159,134,159,159,96,156,162,163,198,170,162,162,162,162,162,162,162,162,163,169,162,162,163,199,208,69,144,12,8,0,0],
[0,6,78,70,144,206,155,168,169,170,168,169,169,169,169,169,169,169,169,169,170,163,169,169,169,174,200,159,159,159,159,194,162,170,170,167,170,170,163,163,170,162,162,169,170,163,162,163,209,197,159,134,159,159,96,156,162,163,198,170,162,162,162,162,162,162,162,162,163,162,162,162,163,178,208,69,144,12,8,0,0],
[0,6,78,70,144,206,155,168,169,170,198,162,169,169,169,169,169,169,169,169,170,163,169,169,163,174,200,159,159,159,159,194,162,163,163,162,170,162,163,163,170,162,162,162,170,163,162,163,209,197,159,134,159,159,96,156,162,163,198,170,162,162,162,162,162,162,162,162,162,162,162,162,163,178,208,69,144,12,8,0,0],
[0,6,78,70,144,210,155,168,163,170,198,162,169,169,169,169,169,169,169,169,162,162,170,169,163,149,200,159,159,159,159,190,155,162,162,162,162,162,162,162,162,162,162,162,170,163,162,163,209,189,159,159,159,194,96,211,162,163,162,162,162,162,162,162,162,162,162,162,162,162,162,162,163,178,208,22,144,12,8,0,0],
[0,6,78,70,144,210,155,198,163,170,163,162,169,169,169,169,169,169,169,169,162,162,170,162,163,149,200,159,159,159,159,190,155,162,162,162,162,162,162,162,162,162,162,162,170,163,162,174,209,189,159,159,159,194,96,211,162,163,162,162,162,162,162,162,162,162,162,162,162,162,162,162,163,178,208,22,144,12,8,0,0],
[0,6,78,70,144,210,155,198,163,170,163,162,169,169,169,169,169,169,169,169,162,162,162,162,163,149,200,159,159,159,159,190,155,162,162,162,162,162,162,162,162,162,162,162,162,163,162,174,209,190,159,159,159,194,96,211,160,163,162,162,162,162,162,162,162,162,162,162,162,162,162,160,163,178,212,22,144,12,8,0,0],
[0,6,78,70,144,210,155,198,163,162,163,162,162,162,162,162,162,162,162,162,162,162,162,162,163,88,200,159,159,159,159,190,155,174,162,162,162,162,162,162,162,162,162,162,162,174,162,174,209,190,159,159,159,194,213,211,160,163,162,162,162,162,162,162,162,162,162,162,162,162,162,160,174,178,212,22,144,12,8,0,0],
[0,6,78,70,144,210,155,198,163,162,163,162,162,162,162,162,162,162,162,162,162,162,162,162,160,88,200,159,159,159,159,190,151,174,162,162,162,162,162,162,162,162,162,162,162,174,162,174,209,190,159,159,159,194,213,172,160,163,162,162,162,162,162,162,162,162,162,162,160,162,160,160,174,158,212,22,144,12,8,0,0],
[0,6,78,70,144,210,155,198,163,162,163,162,162,162,162,162,162,162,162,162,162,162,162,162,160,88,200,159,159,159,159,190,151,174,174,162,162,162,162,162,162,162,162,162,162,174,160,160,209,189,159,159,159,194,213,172,160,163,162,162,162,162,162,160,160,160,160,160,160,162,160,160,174,158,214,22,144,12,8,0,0],
[0,6,78,70,144,210,155,163,163,162,162,162,162,162,162,162,162,162,162,162,162,162,162,160,160,88,185,190,190,194,194,190,151,174,174,162,162,162,162,162,162,162,162,162,160,174,160,160,209,189,137,159,190,194,213,172,160,163,160,162,160,160,160,160,160,160,160,160,160,162,160,160,174,158,214,22,144,12,8,0,0],
[0,6,78,70,144,210,155,163,163,162,162,160,162,162,162,162,162,162,162,162,162,160,162,160,160,166,185,190,190,215,215,188,151,174,174,160,162,162,162,162,162,162,162,162,160,174,160,160,209,189,215,215,190,190,213,172,160,174,160,160,160,160,160,160,160,160,160,160,160,162,160,160,174,158,214,22,144,12,8,0,0],
[0,6,78,70,144,216,132,163,163,160,162,160,160,160,160,160,160,160,160,160,160,160,160,160,160,155,132,90,86,86,86,123,151,174,160,160,160,160,160,160,160,160,160,160,160,174,160,160,132,100,82,82,82,86,123,149,160,174,160,160,160,160,160,160,160,160,160,160,160,162,155,160,174,158,214,22,144,12,8,0,0],
[0,6,78,70,144,216,132,163,163,160,162,160,160,160,160,160,160,160,160,160,160,160,160,160,160,155,160,155,160,160,155,155,160,174,160,160,160,160,160,160,160,160,160,160,155,174,160,160,160,155,155,155,160,155,160,160,160,174,160,160,160,160,160,160,160,160,160,160,160,162,155,160,174,138,214,22,144,12,8,0,0],
[0,6,78,70,144,216,132,163,160,160,162,160,160,160,160,160,160,160,160,160,160,160,160,160,160,155,160,155,160,160,155,155,155,155,160,160,160,160,160,160,160,160,160,160,155,155,160,160,160,155,155,155,160,155,160,160,160,155,160,160,160,160,160,160,160,160,160,160,160,149,155,160,174,138,214,22,144,12,8,0,0],
[0,6,78,70,144,216,152,163,160,160,155,160,160,160,160,160,160,160,160,160,160,160,160,160,160,155,160,155,160,160,155,155,155,155,160,160,160,160,160,160,160,160,160,160,155,155,160,160,160,155,155,155,160,155,160,160,160,155,160,160,160,160,160,160,160,160,160,160,160,149,155,160,174,138,214,22,144,12,8,0,0],
[0,6,78,70,144,216,152,160,160,160,155,160,160,160,160,160,160,160,160,160,151,160,160,160,160,155,160,155,160,160,155,155,155,155,151,151,151,151,151,151,151,151,151,151,155,155,151,160,160,155,155,155,160,155,160,160,160,155,151,160,160,160,160,160,160,160,160,160,151,149,151,132,149,138,214,22,144,12,8,0,0],
[0,6,78,70,71,216,152,160,160,132,155,160,151,151,151,151,151,151,151,151,151,160,160,151,160,155,160,155,151,132,132,151,151,155,151,151,151,151,151,151,151,151,151,151,155,151,151,151,151,155,155,132,151,155,151,151,151,155,151,160,151,151,151,151,151,151,151,151,151,149,151,132,149,138,214,22,144,12,8,0,0],
[0,6,78,70,71,216,152,160,160,132,155,160,151,151,151,151,151,151,151,151,151,151,151,151,132,132,132,132,151,132,132,151,151,155,151,151,151,151,151,151,151,151,151,151,132,151,151,151,151,155,155,132,151,155,151,151,132,155,151,132,132,132,132,132,132,132,132,132,151,149,151,132,149,138,214,22,144,12,8,0,0],
[0,6,78,70,71,216,152,160,160,132,155,132,151,151,151,151,151,151,151,151,132,132,132,151,132,132,132,132,132,132,132,151,151,155,151,151,151,151,151,151,151,151,151,151,132,151,151,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,151,149,151,132,149,138,214,22,144,12,8,0,0],
[0,6,78,61,71,216,100,166,160,151,155,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,151,149,217,132,149,106,218,22,144,12,8,0,0],
[0,0,78,61,71,216,100,81,132,151,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,151,132,151,132,151,106,218,69,144,12,8,0,0],
[0,0,78,61,115,216,152,81,151,151,152,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,100,151,132,151,106,218,219,144,12,8,0,0],
[0,0,78,61,115,216,91,81,151,151,152,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,123,132,152,132,151,88,218,219,144,12,8,0,0],
[0,6,78,61,115,216,91,81,151,217,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,122,122,122,122,122,122,122,122,132,132,132,132,132,132,132,132,123,132,122,122,123,88,218,69,144,12,8,0,0],
[0,6,78,61,66,220,86,81,151,217,123,132,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,123,217,122,122,123,221,212,69,144,12,8,0,0],
[0,6,8,61,71,171,204,81,152,217,123,132,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,123,217,122,122,81,152,222,65,144,12,8,0,0],
[0,0,8,60,71,223,224,81,152,122,123,131,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,131,132,122,122,81,52,222,59,66,12,7,0,0],
[0,0,8,12,225,226,119,227,152,122,149,211,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,211,149,156,228,80,229,24,230,60,48,7,0,0],
[0,0,8,12,61,33,15,231,222,232,233,233,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,111,233,235,236,237,238,226,239,60,8,0,0,0],
[0,0,6,8,47,144,65,22,223,240,240,240,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,240,242,21,14,59,61,48,8,0,0,0],
[0,0,0,8,12,60,71,243,244,244,245,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,246,245,245,244,33,247,248,12,8,0,0,0,0],
[0,0,0,0,7,12,47,66,66,247,243,243,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,230,230,230,230,230,230,230,230,65,247,243,66,239,249,47,6,6,0,0,0,0],
[0,0,0,0,7,0,8,48,47,61,249,23,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,248,70,249,60,12,48,6,8,0,0,0,0,0],
[0,0,0,0,0,0,6,6,8,8,48,48,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,78,78,78,78,78,78,78,78,9,48,250,250,7,7,6,1,0,0,0,0,0],
[0,0,0,0,0,0,0,6,6,0,7,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,0,0,6,4,0,0,0,0,0]],
[0xffefefef,
0xfff8eeef,
0xfff5eaf2,
0xffe5f0ec,
0xffe9f4f0,
0xfff1e8eb,
0xffedeee9,
0xffe8ede9,
0xffe6e6e6,
0xffebe2e5,
0xffd9e1e3,
0xffd9ece6,
0xffdddfde,
0xffdfe5e5,
0xffa5afae,
0xffa3a5a4,
0xff999999,
0xff959a9d,
0xff97989c,
0xff979691,
0xff8ea297,
0xff97a49d,
0xff9ca5a5,
0xffc8d3cd,
0xff827a77,
0xfffbb3c2,
0xffff9eb2,
0xfff392a5,
0xfffe91a4,
0xfffd8c9e,
0xffff839d,
0xffff8aa7,
0xffa88d8f,
0xffb5b6b8,
0xffd6dee1,
0xff8f8a8e,
0xfff04a62,
0xfff74461,
0xfffd3f63,
0xfff84259,
0xfff83d5a,
0xfff04054,
0xffed3a57,
0xffef435b,
0xffee627c,
0xffbb9796,
0xff9eb3a7,
0xffd8d9dd,
0xffe4e3e1,
0xfff9adb7,
0xfff04b59,
0xfff54a5c,
0xfff64a62,
0xffe94a58,
0xffff5c74,
0xfffa5269,
0xffe6425a,
0xffec3a52,
0xffc98187,
0xffbbc5c6,
0xffd5d7d6,
0xffced4d4,
0xff847e82,
0xffe8304c,
0xffc47b82,
0xffaab4b5,
0xffcccccc,
0xff7b7579,
0xfffc546b,
0xff9ba8a9,
0xffcfd4ce,
0xffc5c7c6,
0xffe74252,
0xffe72c47,
0xffc2777c,
0xff7a7174,
0xffdf4253,
0xffbd6e74,
0xffe4e2e5,
0xff757074,
0xffe04358,
0xffde2b40,
0xffe1414b,
0xffe63a50,
0xffe53949,
0xffe03951,
0xffde394a,
0xffe33f46,
0xffdd283b,
0xffef354c,
0xffd83a48,
0xffe73845,
0xff9d2d39,
0xff322a1f,
0xff3a1b1e,
0xff302020,
0xff42211f,
0xff673228,
0xffb8686e,
0xffd83955,
0xffdd3944,
0xffa32b3f,
0xff293029,
0xff3d3938,
0xff3a3132,
0xff5b372e,
0xffd52438,
0xffe63a5a,
0xff282519,
0xff312927,
0xff291717,
0xffd84360,
0xffa7293b,
0xff412f2d,
0xff30343d,
0xffbdccc7,
0xfff53b4c,
0xff203026,
0xff3b3128,
0xff333029,
0xff553236,
0xfff93f50,
0xffd93148,
0xffd63944,
0xffb8616b,
0xff756b70,
0xff202123,
0xff3c2831,
0xff292323,
0xff333333,
0xff522f33,
0xffde324a,
0xffd63141,
0xfff2384a,
0xff211e19,
0xff1b2019,
0xff17221e,
0xff18190c,
0xffd01f31,
0xffb35d65,
0xff3a2a2a,
0xffe8546b,
0xffe54f62,
0xffa42332,
0xffc4cdc8,
0xff261920,
0xff1a2922,
0xff292826,
0xff4f2c2e,
0xffd5313a,
0xffeb3645,
0xffcf3140,
0xffde3242,
0xffac5960,
0xff202612,
0xffcd303b,
0xffdf313b,
0xff9c212e,
0xffcd1b2b,
0xff221a18,
0xffcd2a3b,
0xff72686d,
0xffc52a3a,
0xffc52831,
0xff8b1f29,
0xff0a1f18,
0xffd72839,
0xffc52237,
0xffbf2130,
0xffbb2a31,
0xffbe2a3a,
0xff70666b,
0xffe73140,
0xff242720,
0xffce2a33,
0xffb62931,
0xffb72331,
0xff841b24,
0xffc41828,
0xffa7545a,
0xffac2333,
0xffac212c,
0xffb4222c,
0xffb61421,
0xff9b4b51,
0xff180e0f,
0xff091919,
0xff211a0e,
0xff091310,
0xff061812,
0xff0f1710,
0xff000e08,
0xff231921,
0xffc7303c,
0xff191818,
0xff1b2210,
0xff952c30,
0xff101a19,
0xffc52433,
0xffbd1725,
0xff1f1010,
0xff9e2730,
0xff8b1a26,
0xff2b1d0c,
0xffd64c53,
0xffb92f3c,
0xff6b5f66,
0xffbe1d2d,
0xff9a474d,
0xff931c28,
0xff705c65,
0xffe4303c,
0xff98454c,
0xff482322,
0xff9c3f4a,
0xff0f130f,
0xff6a5a62,
0xffd23a46,
0xff9e3c48,
0xff96a9a7,
0xff63555c,
0xffd72034,
0xff844848,
0xff818c84,
0xffda5a5e,
0xffd2bcc9,
0xffa0bab1,
0xffd7647b,
0xffee2a42,
0xff7d4045,
0xffb7b8ba,
0xff6b5753,
0xffc44e61,
0xffd95161,
0xffd74f56,
0xffca495b,
0xffa9454f,
0xff6a413d,
0xff6b7d6f,
0xffc3cbcd,
0xff424f45,
0xff414747,
0xff5d6661,
0xffbdb6bd,
0xffa7a4ad,
0xff9e9da5,
0xff8d9fa1,
0xffbfbfc1,
0xffd7cfcc,
0xffd1dbd3,
0xffe0e7e0]
            );
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}