/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2RpV
 */

// forked from smirnov48's Life - Ecosystem
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.Keyboard;

    /**
     * A variation of the game life - Ecosystem.
     * This code was written three years ago.
     * @author Smirnov48
     */

    public class Main extends Sprite 
    {
        private static const SCALE_MULTIPLIER:int = 8;
        private static const FIELD_WIDTH:int = 800 / SCALE_MULTIPLIER;
        private static const FIELD_HEIGHT:int = 600 / SCALE_MULTIPLIER;
        private static const COLOR_PROTO:int = 0x0000FF;
        private static const COLOR_LIVE:int = 0x00FF00;
        private static const COLOR_ANIMAL:int = 0xFF0000;
        private static const COLOR_DEAD:int = 0x000000;

        private static const MIDDLE_LEFT:int = 0;
        private static const MIDDLE_RIGHT:int = 1;
        private static const TOP_LEFT:int = 2;
        private static const TOP_MIDDLE:int = 3;
        private static const TOP_RIGHT:int = 4;

        private static const BOTTOM_LEFT:int = 5;
        private static const BOTTOM_MIDDLE:int = 6;
        private static const BOTTOM_RIGHT:int = 7;

        private var bitmapData:BitmapData;
        private var bitmap:Bitmap;
        private var working:Boolean = true;
        private var screen:Vector.<uint> = new Vector.<uint>(FIELD_WIDTH * FIELD_HEIGHT);
        private var buffer:Vector.<uint> = new Vector.<uint>(FIELD_WIDTH * FIELD_HEIGHT);
        private var hash:Vector.<Vector.<uint>> = new Vector.<Vector.<uint>>(FIELD_WIDTH * FIELD_HEIGHT);
        private var temp:Vector.<uint>;

        private var countTurns:int = 0;
        private var tf:TextField;

        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);

            bitmapData = new BitmapData(FIELD_WIDTH, FIELD_HEIGHT, false);
            bitmap = new Bitmap(bitmapData);
            bitmap.scaleX = SCALE_MULTIPLIER;
            bitmap.scaleY = SCALE_MULTIPLIER;
            addChild(bitmap);

            tf = new TextField;
            tf.textColor = 0xFF0000;
            addChild(tf);

            var item:Vector.<uint>;
            var x:int;
            var y:int;
            for (var i:int = 0; i < hash.length; i++) 
            {
                item = hash[i] = new Vector.<uint>(8);
                x = i % FIELD_WIDTH;
                y = i  / FIELD_WIDTH | 0;

                item[MIDDLE_LEFT] = y * FIELD_WIDTH + (((x - 1) < 0)?FIELD_WIDTH -1:(x - 1)); 
                item[MIDDLE_RIGHT] = y * FIELD_WIDTH + ((x + 1) % FIELD_WIDTH);
                item[TOP_LEFT] = (((y - 1) < 0)?FIELD_HEIGHT - 1:(y - 1)) * FIELD_WIDTH + (((x - 1) < 0)?FIELD_WIDTH -1:(x - 1));
                item[TOP_MIDDLE] = (((y - 1) < 0)?FIELD_HEIGHT - 1:(y - 1)) * FIELD_WIDTH + x;
                item[TOP_RIGHT] = (((y - 1) < 0)?FIELD_HEIGHT - 1:(y - 1)) * FIELD_WIDTH + ((x + 1) % FIELD_WIDTH);
                item[BOTTOM_LEFT] = ((y + 1) % FIELD_HEIGHT) * FIELD_WIDTH + (((x - 1) < 0)?FIELD_WIDTH -1:(x - 1));
                item[BOTTOM_MIDDLE] = ((y + 1) % FIELD_HEIGHT) * FIELD_WIDTH + x;
                item[BOTTOM_RIGHT] = ((y + 1) % FIELD_HEIGHT) * FIELD_WIDTH + ((x + 1) % FIELD_WIDTH);
            }

            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }

        private function onClick(e:MouseEvent):void 
        {
            var index:int = ((mouseY / SCALE_MULTIPLIER) | 0) * FIELD_WIDTH + ((mouseX / SCALE_MULTIPLIER) | 0);
            if (screen[index] == COLOR_LIVE) {
                screen[index] = COLOR_DEAD;
            } else {
                screen[index] = COLOR_LIVE;
            }
        }
        
        private function onKeyUp(e:KeyboardEvent):void 
        {
            if (e.keyCode == Keyboard.SPACE) {
                working = !working;
            }

            if (e.keyCode == Keyboard.HOME) {
                for (var i:int = 0; i < screen.length; i++) {
                    if (Math.random() > 0.7) {
                        screen[i] = COLOR_LIVE;
                    }                    
                }
            }

            if (e.keyCode == Keyboard.ENTER) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
            }
        }

        private function onEnterFrame(e:Event):void 
        {    
            if (working) {
                countTurns++;

                var count:int = 0;
                var pcount:int = 0;
                var x:int;
                var y:int;
                var cell:uint;
                var len:int = screen.length;
                var hsh:Vector.<uint>;
                var rand:Number;
                var sideToStep:int;

                for (var i:int = 0; i < len/4; i++) 
                {
                    buffer[4*i] = COLOR_DEAD;
                    buffer[4*i+1] = COLOR_DEAD;
                    buffer[4*i+2] = COLOR_DEAD;
                    buffer[4*i+3] = COLOR_DEAD;
                }

                for (i = 0; i < len; i++) 
                {
                    hsh = hash[i];
                    rand = Math.random();
                    if (screen[i] == COLOR_ANIMAL) {
                        if (rand > 0.5) {
                            sideToStep = rand * 100 % 8;
                            buffer[i] = COLOR_DEAD;
                            buffer[hsh[sideToStep]] = COLOR_ANIMAL;
                            continue;
                        } 
                        buffer[i] = screen[i];
                        continue;
                    }
                    if (buffer[i] == COLOR_ANIMAL) {
                        continue;
                    }

                    count = 0;

                    if (screen[hsh[MIDDLE_LEFT]] == COLOR_LIVE) {
                        count++;
                    }
                    if (screen[hsh[MIDDLE_RIGHT]] == COLOR_LIVE) {
                        count++;
                    }
                    if (screen[hsh[TOP_LEFT]] == COLOR_LIVE) {
                        count++;
                    }
                    if (screen[hsh[TOP_MIDDLE]] == COLOR_LIVE) {
                        count++;
                    }
                    if (screen[hsh[TOP_RIGHT]] == COLOR_LIVE) {
                        count++;
                    }
                    if (screen[hsh[BOTTOM_LEFT]] == COLOR_LIVE) {
                        count++;
                    }
                    if (screen[hsh[BOTTOM_MIDDLE]] == COLOR_LIVE) {
                        count++;
                    }
                    if (screen[hsh[BOTTOM_RIGHT]] == COLOR_LIVE) {
                        count++;
                    }

                    if (count < 2) {
                        if (count == 0) {
                            if (rand > 0.995) {
                                if (screen[i] == COLOR_DEAD) {
                                    buffer[i] = COLOR_PROTO;
                                } else {
                                    buffer[i] = screen[i];
                                }
                            } else {
                                if (screen[i] == COLOR_PROTO) {

                                    pcount = 0;

                                    if (screen[hsh[MIDDLE_LEFT]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (screen[hsh[MIDDLE_RIGHT]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (screen[hsh[TOP_LEFT]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (screen[hsh[TOP_MIDDLE]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (screen[hsh[TOP_RIGHT]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (screen[hsh[BOTTOM_LEFT]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (screen[hsh[BOTTOM_MIDDLE]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (screen[hsh[BOTTOM_RIGHT]] == COLOR_PROTO) {
                                        pcount++;
                                    }
                                    if (pcount < 8) {
                                        buffer[i] = COLOR_PROTO;
                                    } else {
                                        buffer[i] = COLOR_LIVE;
                                    }
                                } else {
                                    buffer[i] = COLOR_DEAD
                                }
                            }
                        } else {
                            buffer[i] = COLOR_DEAD;
                        }
                    } else {
                        if (count == 2) {
                            if (screen[i] == COLOR_PROTO) {
                                buffer[i] = COLOR_DEAD;
                            } else {
                                buffer[i] = screen[i];
                            }
                        }
                        if (count == 3) {
                            buffer[i] = COLOR_LIVE;
                        }

                        if (count > 3) {
                            if (screen[i] != COLOR_PROTO) {
                                buffer[i] = COLOR_DEAD;
                            } else {
                                buffer[i] = screen[i];
                            }
                        }            
                    }

                    if (rand > 0.999) {
                        if (screen[hsh[TOP_MIDDLE]] == COLOR_LIVE && screen[hsh[BOTTOM_MIDDLE]] == COLOR_LIVE) {
                            buffer[hsh[TOP_MIDDLE]] = COLOR_DEAD;
                            buffer[hsh[BOTTOM_MIDDLE]] = COLOR_DEAD;
                            buffer[i] = COLOR_ANIMAL;
                        }

                        if (screen[hsh[MIDDLE_LEFT]] == COLOR_LIVE && screen[hsh[MIDDLE_RIGHT]] == COLOR_LIVE) {
                            buffer[hsh[MIDDLE_LEFT]] = COLOR_DEAD;
                            buffer[hsh[MIDDLE_RIGHT]] = COLOR_DEAD;
                            buffer[i] = COLOR_ANIMAL;
                        }
                    }
                }

                temp = screen;
                screen = buffer;
                buffer = temp;
            }

            bitmapData.setVector(bitmapData.rect, screen);
            tf.text = countTurns.toString();
        }
    }
}