/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Rjd
 */

// forked from tinystudio's forked from: [study] - 重力
// forked from gaina's [study] - 重力
package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(height=465,width=465)]
	public class BallThrower extends Sprite
	{
		private var sp:Sprite;
		private var ball:Ball;
		
		private var ground:Bitmap;
		private var wall:Bitmap;
		
		//右上に放り投げる。
		//62行目で使用。
		private var _vx:Number = 20;
		private var _vy:Number = -10;
		
		//重力。小さな値にすると月面みたいに。
		//35行目で使用
		private var _grav:Number = 0.9;
		
		public function BallThrower ()
		{
			init();
		}
		
		private function addGravity(e:Event):void {
			//下方向(y)にのみ力を加える。
			ball.addVector(0,_grav);
			ball.update();
			sp.x = ball.x;
			sp.y = ball.y;
			
			//壁に当たったら、逆に力を反射させる
			if (sp.x > wall.x-5 || sp.x<5)
			{
				ball.addVector(ball.vectorX * -1.9, 0);
			}
			
			
			if (sp.y > stage.stageHeight)
			{
				ball.addVector(0, ball.vectorY * -1.9);
				
				if (sp.y >stage.stageHeight) 
				{
					sp.y = stage.stageHeight - 10;
				}
			}
			
			//摩擦がわからんので、とりあえずベクトルXがとまるようにしてみる
			ball.vectorX += (0 - ball.vectorX)/50; 
		}
		
		private function init() :void {
			ball = new Ball(10, 300);
			
			sp = new Sprite();
			sp.graphics.beginFill(0);
			sp.graphics.drawCircle(0, 0, 5);
			sp.graphics.endFill();
			addChild(sp);
			
			wall = new Bitmap(new BitmapData(165, stage.stageHeight, true, 0xFFFFFF00));
			wall.x = 300;
			wall.y = 0;
			addChild(wall);
			
			ground = new Bitmap(new BitmapData(stage.stageWidth, 5, true,0xFF000000));
			ground.x = 0;
			ground.y = stage.stageHeight - 5;
			addChild(ground);
			
			ball.addVector(_vx,_vy);
			addEventListener(Event.ENTER_FRAME, addGravity);
			
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		
		private function onClick(e:MouseEvent):void 
		{
			removeEventListener(Event.ENTER_FRAME, addGravity);
			removeChild(sp);
			sp = null;
			init();
		}
	}

}

class Ball
	{
		private var _vectorX:Number = 0;
		private var _vectorY:Number = 0;
		private var _x:Number = 0;
		private var _y:Number = 0;
		

		public function Ball(x:Number, y:Number){
			this._x = x;
			this._y = y;
		}
		
		public function addVector(vectorX:Number=0, vectorY:Number=0):void
		{
			this._vectorX += vectorX;
			this._vectorY += vectorY;
		}
		
		public function update():void{
			this._x += this._vectorX;
			this._y += this._vectorY
		}
		
		public function get vectorX ():Number {
			return this._vectorX;
		}
		
		public function set vectorX (_vectorX:Number):void {
			this._vectorX=_vectorX;
		}
		
		
		public function get vectorY():Number {
			return this._vectorY;
		}
		
		public function get x():Number {
			return this._x;
		}
		
		public function get y():Number {
			return this._y;
		}
	}