/**
 * Copyright novogrammer ( http://wonderfl.net/user/novogrammer )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/2PEU
 */

/**
 * 布シミュをOP.ARに適用してみる by NOVO
 * 暴れるのを何とかしたいところ。積分法の変更？
 * AR(拡張現実)巨乳クリニックで公開
 * http://bokeru.com/kyonyu2/ 
 * Done　3Dにしてみたい(見た目)
 * Done　3Dにしてみたい(計算)
 * Done　単位系をそろえる
 * Done　Fの計算が終わる前にXを動かしているのが偏りの原因っぽい
 * Done　せん断抵抗、角度抵抗用のJointを設定したい
 * Done　微小時間でシミュレート
 * Doing　積分法を変えてみる？
 * Done 初期化変更、必要ない変数も消す。描画方法もJointの描画だけでいいのでは？
 * Done 片方向のJointを両方向に変更（力の計算場所も変更）
 * Done ダンパ力を設定
 * Done 簡易ベクトルクラスに置き換え
 * Done ばねの自然長計算を変更
 * Done 3Dのマウスみなおし
 * Done Jointの種類によってパラメータを変える
 * Done 形を半球にする
 * Done 重力に負けないようにする（圧力バネ成分）
 * Done ゆらす
 * Done AR向けワープ対策
 * Done ARサンプルからコピペ
 * 以下オリジナルコメント
 */
 
// forked from miniapp's GraphicsPathCommand使ったバージョン  forked from: 布
/**
 * GraphicsPathCommandでラインを描画するバージョン。
 * drawLine関数の中が違います。
 *
 * 本格的な布のシミュレーションではありません。
 * 
 * ドラッグでマウスに一番近いポイントを移動させる。
 * ctrlキー押しながらドラッグで固定。
 * ダブルクリックで固定を解除。
 */
 
/**
 * FLARToolKit example launcher
 * --------------------------------------------------------------------------------
 * Copyright (C)2010 saqoosha
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For further information please contact.
 *	http://www.libspark.org/wiki/saqoosha/FLARToolKit
 *	<saq(at)saqoosha.net>
 * 
 * Contributors
 *  saqoosha
 *  rokubou
 */
package  {
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	
    import org.libspark.flartoolkit.example.PV3DARApp;
		
	import flash.display.*;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.core.math.Matrix3D;

	
	import flash.net.*;
	import flash.text.*;
	import org.papervision3d.materials.MovieMaterial;
	import flash.events.Event;
	import flash.media.Camera;
	
	[SWF(width = 640, height = 480, backgroundColor = 0x0, frameRate = 60)]
	public class OP_AR_PV3D extends PV3DARApp {
		
		private var _cube:Cube;
		private var _opr:OP;
		private var _opl:OP;
		private var _chest:Plane;
		private var _light:PointLight3D;
		public function OP_AR_PV3D() {
				// カメラ補正ファイルとパターン定義ファイルのファイル名を渡して初期化。
				addEventListener(Event.INIT, _onInit);
				//this.init('Data/camera_para.dat', 'Data/flarlogo.pat');
				this.init('http://assets.wonderfl.net/static/flar/camera_para.dat', 'http://assets.wonderfl.net/static/flar/flarlogo.pat');
		}
		
		public function _onInit(e:Event):void {
			
			if(Camera.getCamera()==null)
			{
				var t:TextField = new TextField();
				t.text = "Web Cameraがありません。";
				t.autoSize="left";
				t.textColor = 0xff0000;
				addChild(t);
			}
			
			// ライトの設定。手前、上のほう。
			_light = new PointLight3D();
			_light.x = 0;
			_light.y = 1000;
			_light.z = -1000;
			
			var mat:FlatShadeMaterial = new FlatShadeMaterial(_light, 0xEBD7BE, 0x404040, 0);
			mat.doubleSided = true;//両面表示
			
			_chest = new Plane(mat, OP.RADIUS*2, OP.RADIUS*2,10,10);
			this._markerNode.addChild(_chest);
			_opr = new OP(mat, new MyVector3D( +OP.RADIUS, 0, 0));
			_scene.addChild(_opr);
			_opl = new OP(mat, new MyVector3D( -OP.RADIUS, 0, 0));
			_scene.addChild(_opl);
			
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			
			// Cube を作る。
			var fmat:FlatShadeMaterial = new FlatShadeMaterial(_light, 0xff22aa, 0x75104e); // ピンク色。
			this._cube = new Cube(new MaterialsList({all: fmat}), 40, 40, 40); // 40mm x 40mm x 40mm。
			this._cube.z = 20; // 立方体の高さの半分、上方向(Z方向)に移動させるとちょうどマーカーにのっかる形になる。
//			this._baseNode.addChild(this._cube);
		}
		public function onEnterFrame(inEvnet:Event):void
		{
			var m:Matrix3D = Matrix3D.clone(_markerNode.transform);
			_opr.updateFixedMatrix(Matrix3D.multiply(m, Matrix3D.translationMatrix( +OP.RADIUS, 0, 0)));
			_opl.updateFixedMatrix(Matrix3D.multiply(m, Matrix3D.translationMatrix( -OP.RADIUS, 0, 0)));
			_opr.update(1.0 / 60.0);
			_opl.update(1.0 / 60.0);
			_opr.visible = _markerNode.visible;
			_opl.visible = _markerNode.visible;
			
			
		}
		
	}
}

import flash.net.Responder;
import org.papervision3d.core.geom.TriangleMesh3D;
import org.papervision3d.core.geom.renderables.Triangle3D;
import org.papervision3d.core.math.Matrix3D;
import org.papervision3d.core.proto.LightObject3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.core.math.Number3D;
class OP extends TriangleMesh3D
{
	private var _joints:Vector.<Joint> = new Vector.<Joint>();
	private var _points:Vector.<Point> = new Vector.<Point>();
	
	//ポリゴン用配列 面の数*3
	private var _faces:Vector.<int> = new Vector.<int>();
	
	private var _cols:uint = 12;//横の数
	private var _rows:uint = 6;//縦の数
	public static const RADIUS:int = 90;//[mm]
	public static const WARP_LENGTH:Number = 10;//[mm]
	//固定点移動用基準マトリクス
	private var _fixedMatrix:Matrix3D = null;
	
	public function OP(inMaterial:MaterialObject3D,inTranslate:MyVector3D)
	{
		super(inMaterial, [], []);
		putPointAndJoint();
		for each(var point:Point in _points)
		{
			point._position.addTo(inTranslate);//平行移動
		}
	}
	public function updateFixedMatrix(inFixedMatrix:Matrix3D):void
	{
		var warpFlag:Boolean = false;
		if (_fixedMatrix == null)
		{
			_fixedMatrix = Matrix3D.clone(inFixedMatrix);
			warpFlag = true;
		}
		var originOld:Number3D = new Number3D();
		Matrix3D.multiplyVector(_fixedMatrix, originOld);
		var originNew:Number3D = new Number3D();
		Matrix3D.multiplyVector(inFixedMatrix, originNew);
		var originDiff:Number3D = Number3D.sub(originNew, originOld);
		warpFlag = warpFlag ||  Number3D.dot(originDiff, originDiff) > WARP_LENGTH * WARP_LENGTH;//自身とのdotは距離の2乗
		
		
		//逆行列にする
		_fixedMatrix.invert();//壊す
		for each(var point:Point in _points)
		{
			//ワープじゃないときは固定点のみ、ワープのときはすべての点
			if (point.isPinned || warpFlag)
			{
				var p:Number3D = new Number3D(
					point._position.x,
					point._position.y,
					point._position.z);
				Matrix3D.multiplyVector(_fixedMatrix, p);//逆行列
				Matrix3D.multiplyVector(inFixedMatrix, p);
				point._position.x = p.x;
				point._position.y = p.y;
				point._position.z = p.z;
			}
		}
		_fixedMatrix = inFixedMatrix;
	}
	
	/**
	 * 一番カーソルに近いポイントを捜す。
	 */
	public function searchPoint(inMouseX:Number,inMouseY:Number):Point
	{
		var lastMinDist:Number = Infinity;
		var target:Point;
		for each(var point:Point in _points) {
			var pos:MyVector3D = point._position;
			var m:MyVector3D=new MyVector3D(inMouseX,inMouseY,pos.z);
			var dist:Number = pos.subtract(m).length();
			if (dist < lastMinDist) {
				lastMinDist = dist;
				target = point;
			}
		}
		return target;
	}
	private function putPointAndJoint():void
	{
		//Xを経度
		//Yを緯度
		const DEG_TO_RAD:Number=Math.PI/180.0;
		var diffRotX:Number = DEG_TO_RAD*360.0 / _cols;
		var diffRotY:Number = DEG_TO_RAD*90.0 / (_rows-1);
		
		_points.length = 0;
		_joints.length = 0;
		_faces.length = 0;
		
		for (var newIndex:int = 0; newIndex < getOpCount();++newIndex )
		{
			_points[newIndex] = new Point();
		}
		
		//ポイントとジョイントを一気に配置したほうが楽なので
		for(var y:uint=0;y<_rows;++y)
		{
			for(var x:uint=0;x<_cols;++x)
			{
				var point:Point = _points[getOpIndex(y, x)];
				point.name = String(y) + "-" + String(x) + " ";//デバッグ用
				//var noize:Number = Math.random()*10;//0から1
				//よこ
				//var tmp:MyVector3D = new MyVector3D(0,Math.cos(diffRotX*x),Math.sin(diffRotX*x));
				//point._position = new MyVector3D(Math.sin(diffRotY * y) * RADIUS, Math.cos(diffRotY*y)*tmp.y*RADIUS, Math.cos(diffRotY*y)*tmp.z*RADIUS);
				var tmp:MyVector3D = new MyVector3D(Math.sin(diffRotX*x),Math.cos(diffRotX*x),0);
				point._position = new MyVector3D(
					Math.cos(diffRotY * y) * tmp.x * RADIUS,
					Math.cos(diffRotY * y) * tmp.y * RADIUS,
					Math.sin(diffRotY * y) * RADIUS
				);
				if (y == _rows - 1)
				{
					point._position.z *= 1.1;
				}
				
				
				//面
				if (y > 0)
				{
					_faces[_faces.length] = getOpIndex(y - 1,x - 1);
					_faces[_faces.length] = getOpIndex(y + 0,x - 1);
					_faces[_faces.length] = getOpIndex(y - 1,x + 0);
					
					if (y < _rows - 1)
					{
						_faces[_faces.length] =getOpIndex(y - 1, x + 0);
						_faces[_faces.length] =getOpIndex(y + 0, x - 1);
						_faces[_faces.length] =getOpIndex(y + 0, x + 0);
					}
					
				}
				
				if(y>0)
				{
					var pointUp:Point = _points[getOpIndex(y - 1, x)];
					_joints.push(new Joint(point, pointUp));//たて

					if (y < _rows - 1)
					{
						var pointNaname1:Point = _points[getOpIndex(y - 1, x - 1)];
						var jointNaname1:Joint = new Joint(point, pointNaname1);
						jointNaname1.SPRING *= 0.75;
						_joints.push(jointNaname1);//ななめ1（せん断抵抗）
						
						var pointNaname2:Point = _points[getOpIndex(y - 1, x + 1)];
						var jointNaname2:Joint = new Joint(point, pointNaname2);
						jointNaname2.SPRING *= 0.75;
						_joints.push(jointNaname2);//ななめ2（せん断抵抗）
					}
				}
				if (y < _rows - 1)
				{
					var pointLeft:Point = _points[getOpIndex(y, x - 1)];
					_joints.push(new Joint(point, pointLeft));//よこ
				}
				if(y>1)
				{
					var pointUp2:Point = _points[getOpIndex(y - 2, x)];
					var jointUp2:Joint = new Joint(point, pointUp2);
					if (y < _rows -1)
					{
						jointUp2.SPRING *= 1.0;
					}
					else
					{//極部分
						jointUp2.SPRING *= 2.0;
						jointUp2.DAMPER *= 2.0;
					}
					_joints.push(jointUp2);//たて　ひとつ飛ばし（角度抵抗）
				}
				if (y < _rows - 1)
				{
					var pointLeft2:Point = _points[getOpIndex(y,x - 2)];
					var jointLeft2:Joint = new Joint(point, pointLeft2);
					jointLeft2.SPRING *= 1.0;
					_joints.push(jointLeft2);//よこ　ひとつ飛ばし（角度抵抗）
					
		//			var pointDiagonal:Point = _points[getOpIndex(y,x+_cols/2)];
		//			var jointDiagonal:Joint = new Joint(point, pointDiagonal);
		//			jointDiagonal.SPRING *= 0.5;
		//			_joints.push(jointDiagonal);//よこ　対角線
				}
				
			}
			//極部分はバネが集中するので重くする
			var pointPole:Point = _points[_points.length - 2];
			pointPole.mass *= 1.5;
			
			//中心部分を設定
			var pointCenter:Point = _points[_points.length - 1];
			pointCenter._position = new MyVector3D();
			pointCenter.isPinned = true;
			for (var volIndex:int = 0; volIndex < _points.length -1;++volIndex)
			{//圧力
				var jointVol:Joint = new Joint(pointCenter, _points[volIndex]);
				if (volIndex < _points.length - 2)
				{
					jointVol.SPRING *= 0.25;
				}
				else
				{//極部分
					jointVol.SPRING *= 2.0;
				}
				_joints.push(jointVol);
			}
			
			for each(var joint:Joint in _joints)
			{
				joint.resetNaturalLength();
			}
		
		
			//根元を固定します。
			for (var i:int = 0; i < _cols;++i)
			{
				_points[i].isPinned = true;
				_points[i+_cols].isPinned = true;
			}
		}
		trace("_poinits.length"+_points.length);
		trace("_joints.length"+_joints.length);
		_points.fixed = true;
		_joints.fixed = true;
		_faces.fixed = true;
	}
	private function getOpCount():int
	{
		return _cols * (_rows - 1) + 1+1;//周囲＋極＋中心
	}
	private function getOpIndex(inY:int, inX:int):int
	{
		if (inY >= _rows-1)
		{
			return inY * _cols;
		}
		else
		{
			return inY * _cols + (_cols + inX) % _cols;
		}
	}
	public function update(inDt:Number):void
	{
		//フェーズを二つに分ける。力更新と位置更新
		// update force
		for each(var joint1:Joint in _joints) {
			joint1.updateForce();
		}
		for each(var point1:Point in _points) {
			point1.updateForce();//多分下のループに入れても影響はないけど、明示的に分ける。
		}
		// update position
		for each(var point2:Point in _points) {
			const times:int = 10; 
			for (var i:int = 0; i < times;++i)
			{
				point2.updatePosition(inDt/times);
			}
		}
		//drawLine();
		transfer();
	}
	//頂点更新
	private function transfer():void
	{
		var vs:Array = geometry.vertices;
		if (vs.length != _points.length)
		{
			vs.length = 0;
			var fs:Array = geometry.faces;
			fs.length = 0;
			for each(var point:Point in _points)
			{
				vs[vs.length] = new Vertex3D(point._position.x, point._position.y, point._position.z);
			}
			for (var i:int = 0; i < _faces.length/3;++i)
			{
				fs[fs.length] = new Triangle3D(
					this,
					[
						vs[_faces[i * 3 + 0]],
						vs[_faces[i * 3 + 1]],
						vs[_faces[i * 3 + 2]]
					]
				);
			}
		}
		else
		{
			for(var j:int = 0; j < _points.length;++j )
			{
				var point2:Point = _points[j];
				var v:Vertex3D = vs[j];
				v.x = point2._position.x;
				v.y = point2._position.y;
				v.z = point2._position.z;
			}
		}
		for each(var face:Triangle3D in geometry.faces)
		{
			face.createNormal();//法線再計算
		}
	}
}



//簡易ベクトルクラス
class MyVector3D
{
	public var x:Number = 0.0;
	public var y:Number = 0.0;
	public var z:Number = 0.0;
	public function MyVector3D(inX:Number=0.0, inY:Number=0.0,inZ:Number=0.0)
	{
		x = inX;
		y = inY;
		z = inZ;
	}
	//+=
	public function addTo(rhs:MyVector3D):MyVector3D
	{
		this.x += rhs.x;
		this.y += rhs.y;
		this.z += rhs.z;
		return this;
	}
	//+
	public function add(rhs:MyVector3D):MyVector3D
	{
		return new MyVector3D(this.x + rhs.x, this.y + rhs.y, this.z + rhs.z);
	}
	//-=
	public function subtractTo(rhs:MyVector3D):MyVector3D
	{
		this.x -= rhs.x;
		this.y -= rhs.y;
		this.z -= rhs.z;
		return this;
	}
	//-
	public function subtract(rhs:MyVector3D):MyVector3D
	{
		return new MyVector3D(this.x - rhs.x, this.y - rhs.y, this.z - rhs.z);
	}
	//*=
	public function multiplyTo(rhs:Number):MyVector3D
	{
		this.x *= rhs;
		this.y *= rhs;
		this.z *= rhs;
		return this;
	}
	//*
	public function multiply(rhs:Number):MyVector3D
	{
		return new MyVector3D(this.x*rhs,this.y*rhs,this.z*rhs);
	}
	///=
	public function divideTo(rhs:Number):MyVector3D
	{
		this.x /= rhs;
		this.y /= rhs;
		this.z /= rhs;
		return this;
	}
	///
	public function divide(rhs:Number):MyVector3D
	{
		return new MyVector3D(this.x/rhs,this.y/rhs,this.z/rhs);
	}

	public function length2():Number
	{
		return this.x * this.x + this.y * this.y+ this.z * this.z;
	}
	public function length():Number
	{
		return Math.sqrt(length2());
	}
	//単位ベクトル
	public function normalize():MyVector3D
	{
		var l:Number = this.length();
		if (l > 0)
		{
			return this.divide(l);
		}
		else
		{
			return new MyVector3D();
		}
	}
}

class Joint {
	
	public var SPRING:Number = 40.0;//[N/mm]
	public var DAMPER:Number = 0.05;//[N/(mm/s)]
	
	public var _naturalLength:Number = 0.0;
	
	public var _point:Point=null;
	public var _target:Point=null;
	
	public function Joint(point:Point, target:Point) { 
		_point=point;
		_target = target;
		resetNaturalLength();
	}
	public function resetNaturalLength():void
	{
		_naturalLength = _point._position.subtract(_target._position).length();
		//trace( _point.name+ " " +_target.name +" length:"+ _naturalLength);
	}
	public function updateForce():void
	{
		//バネの力
		var dx:MyVector3D = _target._position.subtract(_point._position);
		var nx:MyVector3D = dx.normalize();//単位ベクトル
		var springForce:MyVector3D = nx.multiply((dx.length() - _naturalLength) * SPRING);
		
		//ダンパの力
		var dv:MyVector3D = _target._velocity.subtract(_point._velocity);
		var damperForce:MyVector3D = dv.multiply(DAMPER);
		
		//合力
		var totalForce:MyVector3D = springForce.add(damperForce);
		_point._force.addTo(totalForce);
		//逆の力をかける
		_target._force.addTo(totalForce.multiply(-1));
		
	}
}

class Point {
	public var name:String;
	public var _position:MyVector3D = new MyVector3D();//[mm]
	public var _velocity:MyVector3D = new MyVector3D();//[mm/s]
	public var _force:MyVector3D = new MyVector3D();//[N]
	public var mass:Number=3.0/1000;//[kg]
	public var isPinned:Boolean = false;
	public var isDragging:Boolean = false;
	public static var GRAVITY:Number = 9.8 * 1000;//[mm/(s*s)]
	public static var AIR_FRICTION:Number = 0.005;//[N/(mm/s)]
	public function updateForce():void
	{
		_force.addTo(_velocity.multiply(AIR_FRICTION*-1));
	}
	public function updatePosition(inDt:Number):void
	{
		if (isDragging || isPinned)
		{
			_velocity = new MyVector3D();
			_force = new MyVector3D();
		}
		else
		{
			var a:MyVector3D = _force.divide(mass);
//			a.y -= GRAVITY/Math.sqrt(2);
//			a.z -= GRAVITY/Math.sqrt(2);//むりやり
			a.y -= GRAVITY;
			if (0)
			{
				_velocity.addTo(a.multiply(inDt));
				_position.addTo(_velocity.multiply(inDt));
			}
			else
			{
				var k:MyVector3D = new MyVector3D();
				var l:MyVector3D = new MyVector3D();
				rungeKutta(a, _velocity, _position,inDt, k, l);
				_position.addTo(k);
				_velocity.addTo(l);
			}
			
			_force = new MyVector3D();
		}
	}
	//オイラー法で暴走したので、ルンゲクッタ法という積分法を使う
	//http://www6.ocn.ne.jp/~simuphys/runge-kutta.html
	private function rungeKutta(inA:MyVector3D, inV:MyVector3D, inX:MyVector3D, inDt:Number, outK:MyVector3D, outL:MyVector3D):void
	{
		var x1:MyVector3D = inV.multiply(inDt);
		var v1:MyVector3D = inA.multiply(inDt);
		var x2:MyVector3D = inV.add(v1.multiply(0.5)).multiply(inDt);
		var v2:MyVector3D = inA.multiply(inDt * 0.5);//あってる？　Aを求めなおす必要がある？
		var x3:MyVector3D = inV.add(v2.multiply(0.5)).multiply(inDt);
		var v3:MyVector3D = inA.multiply(inDt * 0.5);//あってる？　Aを求めなおす必要がある？
		var x4:MyVector3D = inV.add(v3).multiply(inDt);
		var v4:MyVector3D = inA.multiply(inDt);//あってる？　Aを求めなおす必要がある？
		outK.addTo(x1.add(x2.multiply(2)).add(x3.multiply(2)).add(x4).divide(6));//代入の代わり
		outL.addTo(v1.add(v2.multiply(2)).add(v3.multiply(2)).add(v4).divide(6));//代入の代わり
	}
}