/**
 * Copyright steven.ryan ( http://wonderfl.net/user/steven.ryan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Oxk
 */

// forked from mousepancyo's 誕生・消滅・再生といった感じ
/*
PV3DのParticleFieldを使用したパーティクルの練習
このあたりを参考にさせていただきました。　http://wonderfl.net/c/2jms

恒星を模したパーティクルの集まりが、画面クリックでバラバラになったり、
点が集まって元の形に戻ったりします。

それにしても重いなぁ…
*/

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import org.papervision3d.view.Viewport3D;
    import caurina.transitions.*;
    import caurina.transitions.properties.*;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="30")]
    
    public class Main extends Sprite {
        
        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _viewport:Viewport3D;
        private var _render:BasicRenderEngine;
        private var _rootNode:DisplayObject3D;
        private var _sphere:Sphere;
        private var _particleMaterial:ParticleMaterial;
        private var _materials:ParticleField
        private var _asteroids:ParticleField
        private var _bmpEffect:BitmapEffectLayer;
        private var _bmpEffect2:BitmapEffectLayer;
        
        private var colorTransform:ColorTransform = new ColorTransform(0,0,0,1,0,0,0,0)
        private var _changeFLg:Boolean;
        
        public function Main():void {
            var base:Base = new Base(0x000A1E, stage.stageWidth, stage.stageHeight)
            addChild(base)
            addChild(new Stats());
            //
            addSpace();
        }
        
        private function addSpace():void {
            _scene = new Scene3D();
            _viewport = new Viewport3D(0, 0, true, false);
            _rootNode = new DisplayObject3D();
            //
            _camera = new Camera3D();
            _camera.z = -_camera.focus * _camera.zoom;
            //
            _render = new BasicRenderEngine();
            //
            _sphere = new Sphere(new WireframeMaterial(0x333333, 10, 1), 100, 8, 8);
            _particleMaterial =  new ParticleMaterial(0xFFFFFF, 10, 1);
            _materials = new ParticleField(_particleMaterial, _sphere.geometry.vertices.length, 1, 0, 0, 0);
            _asteroids = new ParticleField(_particleMaterial, _sphere.geometry.vertices.length, 1, 1500, 1500, 1500);
            //
            addChild(_viewport);
            _scene.addChild(_rootNode);
            //
            colorTransform.redMultiplier = 1
            colorTransform.greenMultiplier = 0.3 
            _bmpEffect = new BitmapEffectLayer(_viewport, stage.stageWidth, stage.stageHeight, true, 0, "clear_pre",false,false );
            _bmpEffect.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 31), false));
            _bmpEffect.drawCommand.blendMode = "add"
            _bmpEffect.drawCommand.colorTransform = colorTransform;
            _viewport.containerSprite.addLayer(_bmpEffect);
            _bmpEffect.addDisplayObject3D(_materials);
            //
            _bmpEffect2 = new BitmapEffectLayer(_viewport, stage.stageWidth, stage.stageHeight, true, 0, "clear_pre",false,false );
            _bmpEffect2.addEffect(new BitmapLayerEffect(new BlurFilter(16, 16, 3), false));
            _bmpEffect2.drawCommand.blendMode = "add"
            _bmpEffect2.drawCommand.colorTransform = new ColorTransform(0.2, 0.2, 0, 1, 0, 0, 0, 0)
            _viewport.containerSprite.addLayer(_bmpEffect2);
            _bmpEffect2.addDisplayObject3D(_asteroids);
            
            for (var i:int = 0; i < _materials.geometry.vertices.length; i++) {
                var gx:Number = _sphere.geometry.vertices[i].x;
                var gy:Number = _sphere.geometry.vertices[i].y;
                var gz:Number = _sphere.geometry.vertices[i].z;
                Tweener.addTween(_materials.geometry.vertices[i], { x:gx, y:gy, z:gz, delay:i*.0001,time:5, transition:"easeInOut" })
            }
            //
            _changeFLg = true
            _rootNode.addChild(_asteroids)
            _rootNode.addChild(_materials)

            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.CLICK, stageClick)
        }
        
        private function update(e:Event):void{
            _render.renderScene(_scene, _camera, _viewport);
            _rootNode.rotationY += 1;
            _rootNode.rotationX += 1;
            _rootNode.rotationZ += 1;
        }
        
        private function stageClick(e:MouseEvent):void{
            if(_changeFLg){
                for (var i:int = 0; i < _materials.geometry.vertices.length; i++) {
                    Tweener.addTween(_materials.geometry.vertices[i], { x:Math.random()*2000-1000, y:Math.random()*2000-1000, z:Math.random()*2000-1000, delay:i*.001,time:3, transition:"easeInOutExpo" } );
                    //
                    if(colorTransform.greenMultiplier < 1) colorTransform.greenMultiplier += 0.01
                    if(colorTransform.blueMultiplier < 1) colorTransform.blueMultiplier += 0.01
                }
                _bmpEffect.drawCommand.colorTransform = colorTransform;
                _changeFLg = false
            }else{
                for (i = 0; i < _materials.geometry.vertices.length; i++) {
                    var gx:Number = _sphere.geometry.vertices[i].x;
                    var gy:Number = _sphere.geometry.vertices[i].y;
                    var gz:Number = _sphere.geometry.vertices[i].z;
                    Tweener.addTween(_materials.geometry.vertices[i], { x:gx, y:gy, z:gz, delay:i*.001,time:10, transition:"easeInOut" })
                    if(colorTransform.greenMultiplier > 0.3) colorTransform.greenMultiplier -= 0.01
                    if(colorTransform.blueMultiplier > 0) colorTransform.blueMultiplier -= 0.01
                }
                _bmpEffect.drawCommand.colorTransform = colorTransform;
                _changeFLg = true
            }
        }
    }
}

//class Base
import flash.display.Sprite
class Base extends Sprite{
    public function Base(color:int,w:int,h:int):void{
        graphics.beginFill(color, 1)
        graphics.drawRect(0,0,w,h)
        graphics.endFill()
    }
}