/**
 * Copyright medadotter ( http://wonderfl.net/user/medadotter )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Ovv
 */

package  {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    public class Easing3D extends Sprite{
        private var ball:Ball3D;
        private var tx:Number;
        private var ty:Number;
        private var tz:Number;
        private var easing:Number = 0.5;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        
        public function Easing3D() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            ball = new Ball3D();
            addChild(ball);
            
            tx = Math.random() * 500 - 250;
            ty = Math.random() * 500 - 250;
            tz = Math.random() * 500 - 250;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void {
            var dx:Number = tx - ball.xpos;
            var dy:Number = ty - ball.ypos;
            var dz:Number = tz - ball.zpos;
            ball.xpos += dx * easing;
            ball.ypos += dy * easing;
            ball.zpos += dz * easing;
            
            var dist:Number = Math.sqrt(dx * dx + dy * dy + dz * dz);
            
            if (dist < 1) {
                tx = Math.random() * 500 - 250;
                ty = Math.random() * 500 - 250;
                tz = Math.random() * 500 - 250;
            }
            if (ball.zpos > -fl) {
                var scale:Number = fl / (fl + ball.zpos);
                ball.scaleX = ball.scaleY = scale;
                ball.x = vpX + ball.xpos * scale;
                ball.y = vpY + ball.ypos * scale;
                ball.visible = true;
            }else {
                ball.visible = false;
            }
        }
        
    }
}

import flash.display.Sprite;
    
class Ball3D extends Sprite 
    {
        public var radius:Number;
        public var color:uint;
        public var xpos:Number = 0;
        public var ypos:Number = 0;
        public var zpos:Number = 0;
        public var vx:Number = 0;
        public var vy:Number = 0;
        public var vz:Number = 0;
        public var mass:Number = 1;
        
        public function Ball3D(radius:Number = 40,color:uint = 0xff0000) 
        {
            this.radius = radius;
            this.color = color;
            init();
        }
        
        private function init():void 
        {
            //graphics.lineStyle(0)
            graphics.beginFill(color);
            graphics.drawCircle(0, 0, radius);
            graphics.endFill();
        }
        
    }