/**
 * Copyright xarple ( http://wonderfl.net/user/xarple )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2OpP
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.CapsStyle;
    import flash.display.GradientType;
    import flash.display.JointStyle;
    import flash.display.LineScaleMode;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.text.AntiAliasType;
    import flash.text.Font;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.ByteArray;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var w : Number = 180;
            var h : Number = 268;
            
            var canvas : Sprite = new Sprite();
            var background : Sprite = canvas.addChild(new Sprite()) as Sprite;
            {
                background.graphics.beginFill(0, 1);
                background.graphics.drawRoundRect(0, 0, w, h, 20, 20);
                background.graphics.endFill();
            }
            var titlelight : Sprite = canvas.addChild(new Sprite()) as Sprite;
            {
                var matrix : Matrix = new Matrix();
                matrix.createGradientBox(w, 25, Math.PI / 2);
                titlelight.graphics.beginGradientFill(GradientType.LINEAR, [0xffffff, 0xffffff], [1.0, 0.0], [0, 170], matrix);
                //titlelight.graphics.beginFill(0xff00ff);
                titlelight.graphics.drawRoundRectComplex(0, 0, w, 25, 10, 10, 0, 0);
                titlelight.graphics.endFill();
                titlelight.y = 1;
                //titlelight.x = 1;
                titlelight.alpha = 0.6;
                
                var mask : Sprite = canvas.addChild(new Sprite()) as Sprite;
                mask.graphics.beginFill(0xff00ff);
                mask.graphics.drawEllipse(-(w * 1.5) / 2 + w / 2, -75, w * 1.5, 100);
                mask.graphics.endFill();
                mask.graphics.lineStyle(10);
                mask.graphics.drawRoundRect(0, 0, w, h, 20, 20);
                titlelight.mask = mask;
            }
            var frameBack : Sprite = canvas.addChild(new Sprite()) as Sprite;
            {
                frameBack.graphics.lineStyle(3, 0, 0.9);
                frameBack.graphics.drawRoundRect(0, 0, w, h, 20, 20);
            }
            var frame : Sprite = canvas.addChild(new Sprite()) as Sprite;
            {
                frame.graphics.lineStyle(1, 0xffffff);
                frame.graphics.drawRoundRect(0, 0, w, h, 20, 20);
            }
            //addChild(canvas);
            canvas.x = 100;
            canvas.y = 100;
            
                        
            var bmp : BitmapData = new BitmapData(w + 10, h + 10, true, 0);
            var m : Matrix = new Matrix();
            m.translate(5.5, 5.5);
            canvas.alpha = 0.7;
            bmp.drawWithQuality(canvas, m, null, null, null, false, StageQuality.HIGH_16X16_LINEAR);
            addChild(new Bitmap(bmp));
        }
    }
}