/**
 * Copyright sugyan ( http://wonderfl.net/user/sugyan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Omb
 */

/*

Desuade Partigen 2.5 Introduction Examples
http://desuade.com/partigen

This .fla goes over the basics of how to use Emitters with Partigen and the Desuade Motion Package

IMPORTANT!
Understanding of the Motion Package's MotionControllers is necessary. Working knowledge of the tween, sequencing, and physics classes is also highly recommended.
While it is possible to jump right in without it and be fine, this .fla assumes you are familiar with these before getting started.

////Overview////

This is an introduction to the Desuade Partigen API. It's recommended to have access to 
the official API docs as you're working along.

Partigen uses concepts (as well as the library itself) from the Motion Package such as 
MotionControllers heavily, as the DMP was designed with Partigen in mind.

In Partigen 1, there was a defined set of properties that could be changed for particles, 
with only a beginning and end value, and only a few offered random ranges. While this made 
it straightforward for novices, expert developers were looking for more freedom.

Thus the concept of MotionControllers was born, even before Partigen 1 was finished. This 
core architecture design allows for unlimited amount of tweens on each property during a 
particle's life - for any of the particle's tweenable properties.

While this comes with a bit more required code, much of it is duplicatable 
across emitters and provides incredible value. Also, since everything is dynamic, file 
size has decreased considerably, from the original default standard size of 40k, to an 
average of 20k (for all the libraries) - that includes and entire tween and physics engine, as 
well as the entire Partigen engine. The minimum is around 5k (this excludes controllers, etc).

(Note sizes may increse with future releases)

If you're migrating from 1.x/AS2, there is very little in common with the old API besides 
some general concepts. Partigen 2 is a revolutionary new framework that's here to stay, 
with an architecture and syntax that is open to the future and community contributions.


////Usage////

Components of Partigen 2:

Renderers: these control how the particles are displayed
Pools: this manages the actual particle objects in memory
Events: particle events
Particles: these are dynamic objects that get created by emitters
Emitters: creates, manages, and configures particles


On average, the majority of your time with Partigen will be spent with emitters and their controllers.
Each emitter creates two "master controllers" by default:

emitter.controllers.emitter //this controls the properties of the emitter itself when start() is called
emitter.controllers.particle //this controls the properties of new particles


Any property under those will be the actual property being controlled.

For example:

emitter.controllers.particle.x //controls each particle's x value
emitter.controllers.particle.alpha //controls each particle's alpha value
emitter.controllers.emitter.x //controls the emitter's x value

-----

>To create emitter controllers, use one of the following methods on emitter.controllers.emitter:

addTween(property:String, duration:Number)
addPhysics(property:String, duration:Number, flip:Boolean = false)
addBeginValue(property:String, value:*, spread:* = 0, precision:* = 0, extras:* = null)

These methods will either create an EmitterTweenController or an EmitterePhysicsController
Each inherits a real MotionController or a PhysicsMultiController respectivly.


>To create particle controllers, use one of the following methods on emitter.controllers.particle:

addTween(property:String, duration:Number = 0)
addColorTween(property:String = "color", duration:Number = 0)
addPhysics(property:String, duration:Number = 0, flip:Boolean = false)
addBeginValue(property:String, value:*, spread:* = 0, precision:* = 0, extras:* = null)

These methods will either create a ParticleTweenController or a ParticlePhysicsController
Each resembles a MotionController or a PhysicsMultiController respectivly.


These controllers work the same way as MotionControllers from the Motion Package, so each 
one has a keyframes property than can be used to create more intricate effects:

emitter.controllers.particle.x.keyframes;

-----

The emitter has an angle and angleSpread property that is only used for ParticlePhysicsControllers
and will effect all Physics-based properties unless explicitly set not to via the 'useangle' property
on the given ParticlePhysicsController.


Emitters are controlled by start() and stop() methods, and do just what they say.
These methods also start and stop any controllers in my_emitter.controllers.emitter

-----

Assign your particle class to the emitter like so:
my_em.particle = CustomParticle;

v2.5 Migration:
    -any class can be used as a particle without having to extend the ParticleClass (it also shouldn't)
    -pools now need the baseparticle class passed in the constructor
    -BitmapRenderers now automatically start/stop based on need, so it is recommended to remove and stop/start calls on your renderers and use automagic mode (on be default)


Consult the official API docs for more details http://api.desuade.com/. The examples in this .fla should provide a majority of common approaches.

*/

package {

    import flash.display.*;
    import com.desuade.partigen.*;
    import com.desuade.partigen.emitters.*;
    import com.desuade.partigen.particles.*;
    import com.desuade.partigen.renderers.*;
    import com.desuade.motion.*;
    
    public class partigen_intro extends MovieClip {
    
        public function partigen_intro() {
            super();
            
            var t1:MovieClip = new MovieClip(); //make a container for particles for the renderer
            addChild(t1);

            var sr:Renderer = new StandardRenderer(t1, 'top'); //by default, emitters create nullpools and nullrenderes. let's make a StandardRenderer to share between all of them
            
            /////////////
            ////New Features in Partigen 2.5
            ////////
            
            ////
            //Predrawing with the pixel renderer
            //
            var mpr:BitmapRenderer = new PixelRenderer(stage.stageWidth, stage.stageHeight); //create new PixelRenderer
            mpr.fade = 0.95; //enable a 'trail' for the particles
            mpr.fadeBlur = 8; // add a nice blur to the trails to soften them
            mpr.predraw = true; //disable this to see the actual pixel-particles
            
            addChild(new BitmapCanvas(mpr)); //add a new BitmapCanvas to the stage, passing the PixelRenderer

            var em10:Emitter = new Emitter();
            em10.renderer = mpr;
            em10.particleBaseClass = PixelParticle; //we need to set the baseclass to PixelParticle
            em10.groupAmount = 1000; //with PixelParticles, we can have high group amounts
            em10.groupProximity = 465;
            em10.eps = 15;
            em10.life = 1;
            em10.lifeSpread = 1.5; //set absolute live range
            em10.controllers.particle.addColorTween();
            em10.controllers.particle.color.keyframes.begin.value = 'ff4444';
            em10.controllers.particle.color.keyframes.begin.spread = '0d0dff'; //different color each time it's started
            em10.controllers.particle.addTween('y').setSingleTween('0', '0', '200', '50');
            em10.start();
        }    
    }
}