/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Oe9
 */

// forked from termat's forked from: flash on 2010-4-8
// forked from termat's flash on 2010-4-8
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
     
    [SWF(width = "480", height = "480", backgroundColor = "0x000000",frameRate="60")] 
    public class Practice67 extends Sprite {
        private var tri:Vector.<Triangle>;
        private var bmp:BitmapData;
        private var blur:BlurFilter;
        private var num:int = 100;
        private var min2:int = 100;
    
        public function Practice67():void {
            bmp = new BitmapData(480, 480, true, 0x000000);
            addChild(new Bitmap(bmp));
            blur = new BlurFilter(16, 16, 1); 
            tri = new Vector.<Triangle>();
            for (var i:int = 0; i < num; i++) {
                var t:Triangle = new Triangle();
                t.x = Math.random() * 480, t.y = Math.random() * 480;
                t.vx = Math.random() * 20 - 10, t.vy = Math.random() * 20 - 10;
                t.size = 10;
                t.color = getColor((i * 2) % 360, 1.0);
                tri.push(t);
                addChild(t);
            }
            splat();
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
        }
        
        private function onDown(e:MouseEvent):void {
            splat();
        }
        
        private function splat():void {
            for (var i:int = 0; i < tri.length; i++) {
                tri[i].x = 200 * Math.cos((i * 2) / 180 * Math.PI) + 240;
                tri[i].y = 200 * Math.sin((i * 2) / 180 * Math.PI) + 240;
            }
        }
        
        private function update(e:Event):void {
            graphics.clear();
                                    this.blendMode = "add";   

            for each(var t:Triangle in tri) {
                t.update(mouseX, mouseY);
            }
            conflict();
            bmp.fillRect(bmp.rect,0x000000);
            bmp.lock();
            bmp.draw(this, null, null, BlendMode.MULTIPLY);
            bmp.unlock();
            bmp.applyFilter(bmp, bmp.rect, new Point(0, 0), blur);

        }
        
        private function getColor(i:int, saturation:Number):uint {
            var value:Number = 1.0;
            var h:Number = i / 60;
            var ii:Number = Math.floor(h);
            var ff:Number = h - ii;
            var p1:Number = value * (1.0 - saturation);
            var p2:Number = value * (1.0 - saturation * ff);
            var p3:Number = value * (1.0 - saturation * (1.0 - ff));
            var rv:Number;
            var gv:Number;
            var bv:Number;
            switch(ii) {
            case 0:
                rv = value, gv = p3, bv = p1;
                break;
            case 1:
                rv = p2, gv = value, bv = p1;
                break;
            case 2:
                rv = p1, gv = value, bv = p3;
                break;
            case 3:
                rv = p1, gv = p2, bv = value;
                break;
            case 4:
                rv = p3, gv = p1, bv = value;
                break;
            default:
                rv = value, gv = p1, bv = p2;
            }
            var rr:int = Math.max(0, Math.min(255, rv * 255));
            var gg:int = Math.max(0, Math.min(255, gv * 255));
            var bb:int = Math.max(0, Math.min(255, bv * 255));
            var color:uint = (rr << 16) + (gg << 8) + bb;
            return color;
        }
        
        private function conflict():void {
            for (var i:int = 0; i < tri.length; i++){
                for (var j:int = i + 1; j < tri.length; j++) {
                    if (min2 > tri[i].dist2(tri[j])){
                        var xx:Number = (tri[i].x - tri[j].x) / 10.0;
                        var yy:Number = (tri[i].y - tri[j].y) / 10.0;
                        tri[i].x += xx;    tri[j].x -= xx;
                        tri[i].y += yy;    tri[j].y -= yy;
                    }
                }
            }
        }
    }
}
import flash.display.Graphics;
import flash.display.MovieClip;
import flash.geom.Point;

class Triangle extends MovieClip {
    public var vx:Number=0.0;
    public var vy:Number=0.0;
    public var dir:Number = 0.0;
    public var size:Number = 10;
    public var color:uint = 0x000000;
    private static const splen:Number = 4;
    
    public function dist2(t:Triangle):Number {
        var xm:Number = x - t.x;
        var ym:Number = y - t.y;
        return xm * xm + ym * ym;
    }
    
    public function update(mx:Number, my:Number):void {
        graphics.clear();
        graphics.beginFill(color);
        var xx:Number = Math.cos(dir) - Math.sin(dir);
        var yy:Number = Math.sin(dir) + Math.cos(dir);
        var rr:Number = 4*Math.sqrt(vx * vx + vy * vy)*Math.sin(dir);
        graphics.drawCircle(xx,yy,rr);
        graphics.endFill();
        x += vx, y += vy;
        var dx:Number = mx - x;
        var dy:Number = my - y;
        dir = Math.atan2(dy, dx);
        vx += Math.cos(dir) / (size*0.5);
        vy += Math.sin(dir) / (size * 0.5);
        vx = Math.max( -splen, Math.min(splen, vx));
        vy = Math.max( -splen, Math.min(splen, vy));
    }
}
