/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2OZq
 */

/**
 * 暗号をやりとりするやつ (Tweet ボタン付き)
 * 使い方
 * [送り方]
 *  1. 相手 にパスワードを教える。
 *  2. 暗号化したいテキストを一番上の欄に。
 *  3. 暗号に使用するパスワードを二番目の欄に。
 *  4. 【encode】 ボタンをクリック。
 *  5. Tweet ボタンをクリック。
 *   (試用したこのツールの URL を付加するには add URL のチェックボックスにチェックをいれてね)
 * [読み方]
 *  1. 複合化したいテキストを一番上の欄に。
 *  2. 教えてもらったパスワードを二番目の欄に。
 *  3. 【decode】 ボタンをクリック。
 *  4. 一番下の大きな欄に出力された言葉を見てわいわいする。
 * @author jc at bk-zen.com
 */
package
{
    import com.adobe.crypto.MD5;
    import com.bit101.components.CheckBox;
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import com.bit101.components.TextArea;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import mx.utils.Base64Decoder;
    import mx.utils.Base64Encoder;
    
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Test33 extends Sprite
    {
        private var txt:InputText;
        private var encodeBtn:PushButton;
        private var key:InputText;
        private var decodeBtn:PushButton;
        private var resultTxt:TextArea;
        private var tweetBtn:PushButton;
        private var bytes:ByteArray;
        private var keyBytes:ByteArray;
        private var encoder:Base64Encoder;
        private var decoder:Base64Decoder;
        private var addURLCheck: CheckBox;
        private var url: String;
        
        public function Test33() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            url = "http://wonderfl.net/c/" + (loaderInfo.parameters.appId || "2OZq");
            Style.fontName   = "Verdana";
            Style.embedFonts = false;
            Style.fontSize   = 10;
            
            txt = new InputText(this, 10, 10, "暗号化/複合化したい文字列");
            key = new InputText(this, 10, 30, "パスワード");
            encodeBtn = new PushButton(this, 210, 30, "encode", onClickEncode);
            decodeBtn = new PushButton(this, 310, 30, "decode", onClickDecode);
            
            resultTxt   = new TextArea(this, 10, 50, "result");
            tweetBtn    = new PushButton(this, 210, 130, "tweet", onClickTweet);
            addURLCheck = new CheckBox(this, 215, 112, "add URL");
            
            txt.width = key.width = resultTxt.width = 200;
            addURLCheck.selected  = true;
            
            bytes    = new ByteArray();
            keyBytes = new ByteArray();
            encoder  = new Base64Encoder();
            decoder  = new Base64Decoder();
        }
        
        private function onClickEncode(e: Event):void 
        {
            bytes.length = 0;
            bytes.writeUTFBytes(txt.text);
            bytes.position = 0;
            enc();
            encoder.encodeBytes(bytes);
            resultTxt.text = encoder.toString();
        }
        
        private function onClickDecode(e: Event): void 
        {
            try 
            {
                decoder.decode(txt.text.replace(/ /g, "+"));
                bytes = decoder.toByteArray();
                enc();
                resultTxt.text = bytes.readUTFBytes(bytes.length);
            }
            catch (err: Error) { decoder.reset(); }// めんどくさいからスルー
        }
        
        private function enc():void 
        {
            keyBytes.length = 0;
            keyBytes.writeUTFBytes(MD5.hash(key.text));
            bytes.position = keyBytes.position = 0;
            var i: uint, n: uint = bytes.length, m: uint = keyBytes.length;
            for (i = 0; i < n; i++) 
            {
                bytes[i] = keyBytes[i % m] ^ bytes[i];
            }
        }
        
        private function onClickTweet(e: Event): void 
        {
            navigateToURL(
                new URLRequest(
                    "http://twitter.com/?status=" + resultTxt.text + 
                    (addURLCheck.selected ? " " + url : "")
                ), "_blank"
            );
        }
    }
}