/**
 * Copyright y_tti ( http://wonderfl.net/user/y_tti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Nad
 */

package
{
	//3D座標→2D座標の変換。
	//参考：http://www.nabble.com/3D-%3E%3E-2D-coordinates-td14730886.html
	
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.geom.Point;
	
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.core.math.Matrix3D;
	import org.papervision3d.core.proto.CameraObject3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x000000")]
	public class TestObj2DPoint extends BasicView
	{
		private var _cube:Cube;
		private var _ball:Ball;
		public function TestObj2DPoint()
		{
			stage.quality = StageQuality.BEST;
			super(465,465,false,false,CameraType.DEBUG);
			
			//FlatShadeを使用したcube作成 (3次元)
			var light:PointLight3D = new PointLight3D();
			var flatmate:FlatShadeMaterial = new FlatShadeMaterial(light,0xFF00FF,0xAA00AA);
			flatmate.doubleSided = true;
			var materials:MaterialsList = new MaterialsList({all:flatmate});
			_cube =new Cube(materials,500,500,500,4,4,4);
			scene.addChild(_cube);
			
			//ボール作成(2次元)
			_ball = new Ball();
			addChild(_ball);
			
			startRendering();
			addEventListener(Event.ENTER_FRAME , _loop );
		}
		
		private function _loop(e:Event):void {
			_cube.yaw(1);
			_cube.pitch(0.5);
			
			//3D座標のCubuの位置を2D座標に変換 →ボールのxyに代入。
			var p:Point = getObj2DCords(_cube,camera,stage.stageWidth/2 , stage.stageHeight/2 );
			_ball.x = p.x;
			_ball.y = p.y;
		}
		
		//参考：http://www.nabble.com/3D-%3E%3E-2D-coordinates-td14730886.html
		private function getObj2DCords ( o:DisplayObject3D, camera:CameraObject3D,  offsetX:Number = 0, offsetY:Number = 0 ):Point
		{
			var view:Matrix3D = o.view;
			var persp:Number = (camera.focus * camera.zoom) / (camera.focus + view.n34);
			return new Point ( (view.n14 * persp) + offsetX, (view.n24 * persp) + offsetY );
		}
	}
}
	import flash.display.Sprite;
	

class Ball extends Sprite {
	public function Ball():void {
		this.graphics.beginFill(0x0000FF , 1 );
		this.graphics.drawCircle(0,0,20);
		this.graphics.endFill();
	}
}