/**
 * Copyright okmt_masaaki ( http://wonderfl.net/user/okmt_masaaki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2MdE
 */

/*

いまさらながら。。。。。最近他の人のコードをみてて、思ったこと。

でかいビットマップを扱うときにFlashCS3,4上でオーサリングすると
スプライトやムービークリップに内包する形で動かすことが一般的だと
思っていました。ただ、画像が大きいと動かすときに必ず横方向にジャミる。
体感的に負荷も重そうに見えます。

なんで、スプライトのビットマップの塗りをmatrix使って位置の移動や
拡大縮小する方法を見つけたとき、その速さというかレスポンスにびびった。

*/

package {
    import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
    import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.geom.Matrix;
	
    public class FlashTest extends Sprite {
    		private var _sp:Sprite;
    		private var _bmpdata:BitmapData;
    		
        public function FlashTest() {
        		stage.scaleMode = StageScaleMode.NO_SCALE;
        		stage.align = StageAlign.TOP_LEFT;
        	
            var myLoader:Loader = new Loader();
			var myURLRequest:URLRequest = new URLRequest("http://farm3.static.flickr.com/2523/4059941992_91d11298cd_o.jpg");
			var myLoaderContext:LoaderContext = new LoaderContext(true);
			myLoader.load(myURLRequest , myLoaderContext);
			myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
			{
				_bmpdata = new BitmapData(e.target.content.bitmapData.width,e.target.content.bitmapData.height);
				_bmpdata.draw(e.target.content);
				
				_sp = new Sprite();
				addChild(_sp);
				onMouseMove();
				
				stage.addEventListener(Event.RESIZE,onResize);
				stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
			});	
        }
        private function onMouseMove(e:MouseEvent = null):void
        {

        		var moveX:Number = stage.mouseX/stage.stageWidth;
        		var moveY:Number = stage.mouseY/stage.stageHeight;
        		
        		var mtx:Matrix = new Matrix();
			mtx.translate((stage.stageWidth-_bmpdata.width)*moveX,(stage.stageHeight-_bmpdata.height)*moveY);
        		_sp.graphics.clear();
        		_sp.graphics.beginBitmapFill(_bmpdata,mtx,true,true);
        		_sp.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
        		
        };
        
        private function onResize(e:Event = null):void
        {
			_bmpdata.dispose();
			_bmpdata = new BitmapData(stage.stageWidth,stage.stageHeight);
			onMouseMove();
        }
     }
}