/**
 * Copyright USK ( http://wonderfl.net/user/USK )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2MEq
 */

/*
 * 泡っぽいものを。
 * 
 * 小さい泡が大きい泡の後ろにいってしまうことがあります。
 * また、Tweenerがnullオブジェクトを参照しているエラーが吐かれています。
 * 
 * 
 * 
 */

package {
	import flash.display.Sprite;
	import flash.events.*;
	import caurina.transitions.Tweener;
	import flash.utils.setTimeout;

	[SWF(width="465",height="465",backgroundColor="0xFFFFFF",frameRate="30")];
	public class Index extends Sprite {
		
		private var _count   :int;
		private var _cArr    :Array = new Array();
		
		public function Index() {
			createCirc();
		}
		
		private function createCirc():void 
		{
			var count:uint = Math.random() * 20;
			for (var i:uint = 0; i < count; i++) {
				var c:Circ = new Circ();
				c = new Circ();
				this.addChild(c);
			}
			setTimer();
		}
		
		private function setTimer():void
		{
			var d:Number = Math.random() * 5 + 1;
			setTimeout(createCirc, d * 1000);
		}
	}
}

import flash.display.Sprite;
import caurina.transitions.Tweener;
import caurina.transitions.Equations;

class Circ extends Sprite {
	
	private var _bubble  :Sprite;
	private var _holder  :Sprite;
	private var _x       :Number;
	private var _r       :Number;
	
	public function Circ() {
		var r:Number = Math.random() * 20 + 5;
		var y:Number = 465;
		var x:Number = Math.random() * 465;
		_r = r;
		_x = x;
		
		_holder = new Sprite();
		with (_holder) {
			graphics.lineStyle(4, 0x0);
			graphics.beginFill(0xFFFFFF);
			graphics.drawCircle(0, 0, r);
			graphics.endFill();
		}
		//
		_bubble = new Sprite();
		_bubble.addChild(_holder);
		this.addChild(_bubble);
		
		_bubble.x = _x;
		_bubble.y = y + _bubble.height;
		
		startWave();
		moveUp();
	}
	
	//-----------------------------------------
	private function moveUp():void
	{
		var s:Number = 70 / _r;
		var d:Number = Math.random() * 2;
		Tweener.addTween(_bubble, {
			y: -_bubble.height - 200,
			time:s,
			delay:d,
			transition:Equations.easeOutSine,
			onComplete:moveComp
		});
	}
	
	private function moveComp():void
	{
		this.parent.removeChild(this);
	}
	
	//-----------------------------------------
	private function startWave():void
	{
		var d:Number = Math.random() * 5 + 3;
		var s:Number = d * 0.05;
		Tweener.addTween(_holder, {
			x:d,
			time:s,
			transition:"linear",
			onComplete:replyWave
		});
	}
	
	private function replyWave():void
	{
		var d:Number = Math.random() * 5 + 3;
		var s:Number = d * 0.1;
		Tweener.addTween(_holder, {
			x:-d,
			time:s,
			transition:"linear",
			onComplete:startWave
		});
	}
	
}