/**
 * Copyright mikako ( http://wonderfl.net/user/mikako )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2M0H
 */

// forked from takenosin's 万有引力
// forked from takenosin's パーティクル
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class ClassName extends Sprite {
    	
    	private var Particles:Array;
    	private var numParticles:uint = 30;
    	
        public function ClassName() {
            // write as3 code here..          
            Particles = new Array();
            for(var i:uint = 0; i < numParticles; i++){
            	var Particle:Ball = new Ball(5);
            	Particle.x = Math.random() * stage.stageWidth;
            	Particle.y = Math.random() * stage.stageHeight;
            	Particle.mass = 1;
            	addChild(Particle);
            	Particles.push(Particle);
            }
            
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
            
        }
        
        private function onEnterFrame(event:Event):void{
        for(var i:uint = 0; i < numParticles; i++){
        var Particle:Ball = Particles[i];
        	Particle.x += Particle.vx;
        	Particle.y += Particle.vy;
        	}
        	
        	for(i = 0; i < numParticles - 1; i++){
        		var PartA:Ball = Particles[i];
        		for(var j:uint = i + 1; j < numParticles; j++){
        			var PartB:Ball = Particles[j];
        			gravitate(PartA,PartB);
        		}
        	}          
        }
        private function gravitate(PartA:Ball,PartB:Ball):void{
        	var dx:Number = PartB.x - PartA.x;
        	var dy:Number = PartB.y - PartA.y;
        	var distSQ:Number = dx * dx + dy * dy;
        	var dist:Number = Math.sqrt(distSQ);
        	var force:Number = PartA.mass * PartB.mass / distSQ;
        	var ax:Number = force * dx / dist;
        	var ay:Number = force * dy / dist;
        	PartA.vx += ax / PartA.mass;
        	PartA.vy += ay / PartA.mass;
        	PartB.vx += ax / PartB.mass;
        	PartB.vy += ay / PartB.mass;
        }
    }
}


import flash.display.Sprite;
class Ball extends Sprite{
	
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var mass:Number = 1;
	
	public function Ball(radius:Number=40,color:uint=0x66ffff){
		this.radius = radius;
		this.color = color;
		
		graphics.beginFill(color);
		graphics.drawCircle(0,0,radius);
		graphics.endFill();
	}
}