/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2LfC
 */

/**
Google Documentにフォームを作る機能がいつのまにかついてた。
なので、ちょっと試してみた。

アンケートフォーム↓の回答が、
https://spreadsheets.google.com/viewform?hl=ja&formkey=dGhXNERIX2g4dTRRLUZ0MDB4bHZLeUE6MA
スプレッドシートに自動的になる↓。
https://spreadsheets.google.com/ccc?key=0Akpu7nsnVtwIdGhXNERIX2g4dTRRLUZ0MDB4bHZLeUE&hl=ja
それを、共有／ウェブページとして公開すると、RSS↓を選択できる。
http://spreadsheets.google.com/feeds/cells/thW4DH_h8u4Q-Ft00xlvKyA/od6/public/basic?alt=rss
crossdomain.xmlがどこかわからなかったのでYahoo!Pipes↓を経由して取得。
http://pipes.yahoo.com/pipes/pipe.info?_id=f4f6c98189a88373b9bfd4fe6128c018

アンケートの内容は、、、超適当

 * */
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.text.TextField;
	import flash.text.TextFormat;
	/**
	 * ...
	 * @author umhr
	 */
	[SWF(backgroundColor="0xF5F5F5")]
	
	public class Main extends Sprite {
		
		public function Main():void {
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener (Event.COMPLETE, onCompleteXML);
			//YahooPipesの汎用feedProxy
			var xmlURL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=f4f6c98189a88373b9bfd4fe6128c018&_render=rss&url=";
			//encodeURIComponentでエスケープして、feedProxyにくっつける。
			xmlURL += encodeURIComponent("http://spreadsheets.google.com/feeds/cells/thW4DH_h8u4Q-Ft00xlvKyA/od6/public/basic?alt=rss&rand="+Math.random());
			myURLLoader.load(new URLRequest(xmlURL));
		}
           
		private function onCompleteXML(e:Event):void {
			var myXML:XML = new XML(e.currentTarget.data);
			//trace(myXML.channel);
			var canvas:Sprite = new Sprite();
			for (var i:int = 0; i < myXML.channel.item.length(); i++) {
				var lineNum:Number = Number(String(myXML.channel.item[i].title).substr(1))-1;
				var columnNum:Number = String(myXML.channel.item[i].title).substr(0,1).charCodeAt() - 65;
				var tf:TextField = new TextField();
				tf.text = myXML.channel.item[i].description;
				tf.border = true;
				tf.x = ((stage.stageWidth-12)/5)*columnNum+6;
				tf.y = 18*lineNum+6;
				tf.width = (stage.stageWidth-12)/5;
				tf.height = 18;
				canvas.addChild(tf);
			}
			canvas.y = Math.min(0,stage.stageHeight-canvas.height-12);
			this.addChild(canvas);
		}
	}
}