/**
 * Copyright nayu ( http://wonderfl.net/user/nayu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Kz7
 */

/*
　質問：クラスが２つ混在する場合の書き方。
　ボールを作成するためのクラスを作成するには
　この中でどのように記述したらいいんでしょうか？
　教えてください。
*/

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.MovieClip;

    public class particle44 extends Sprite 
    {
       private var particles:Array;
       private var numParticles:uint = 50;
       
        public function particle44() 
        {
            init();    
        }
        
        public function init():void
        {
            particles = new Array();
            for(var i:uint = 0; i < numParticles; i++)
            {
                //ボールの大きさ
                var shape1:MovieClip = new MovieClip();
                shape1.graphics.beginFill(0x0000FF);
                var size:uint = Math.random() * 10 + 5;
                shape1.graphics.drawCircle(0,0,size);
                shape1.graphics.endFill();
                
                var particle:MovieClip = shape1;
                //ボールの配置する位置
                particle.x = Math.random() * stage.stageWidth;
                particle.y = Math.random() * stage.stageHeight;
		particle.vx = 0;
		particle.vy = 0; 
		//質量
		particle.mass = Math.random() * 20 + 10;
                addChild(particle);
                particles.push(particle);    
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame(event:Event):void
        {
            for(var i:uint = 0; i < numParticles; i++)
	    {
		var particle:MovieClip = particles[i];
		particle.x += particle.vx;
		particle.y += particle.vy;
	    }
	    for(i = 0; i < numParticles - 1; i++)
	    {
	        var partA:MovieClip = particles[i];
	        for(var j:uint = i + 1; j < numParticles; j++)
	        {
	            var partB:MovieClip = particles[j];
	            gravitate(partA, partB);
                }
            }
        }
	
        //
        public function gravitate(partA:MovieClip, partB:MovieClip):void
	{
            //2点間のXの差とyの差を求める
	    var dx:Number = partB.x - partA.x;
	    var dy:Number = partB.y - partA.y;
            //2点間の距離を求める（ピタゴラスの定理）
	    var distSQ:Number = dx * dx + dy * dy;
	    var dist:Number = Math.sqrt(distSQ);
            //物体に及ぼす引力
	    var force:Number = partA.mass * partB.mass / distSQ;
            //加速度を求める
	    var ax:Number =  force * dx / dist;
	    var ay:Number =  force * dy / dist;
	    partA.vx += ax / partA.mass;
	    partA.vy += ay / partA.mass;
	    partB.vx -= ax / partB.mass;
	    partB.vy -= ay / partB.mass;
        }
    }
}
 
