/**
 * Copyright lespleen ( http://wonderfl.net/user/lespleen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Kya
 */

// forked from FLASHMAFIA's RGB Noize + Optimization
// forked from FLASHMAFIA's White Noize + Optimization
// forked from tai2's White Noize
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;

    [SWF(width = '465', height = '465')]
    public class WhiteNoize extends Sprite
    {
        private var bmd : BitmapData;
        private var buff : Vector.<uint> = new Vector.<uint>(465 * 465, true);
        private var seed : uint = 2222;
        private var fcnt : uint = 11;

        function WhiteNoize()
        {
            stage.stageFocusRect = tabChildren = tabEnabled = mouseChildren = mouseEnabled = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            stage.frameRate = 64;

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(465, 465, false));
            bm.opaqueBackground = opaqueBackground = 0x000000;
            addChild(bm);

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            fcnt++;
            
            seed++;

            var s : uint = seed;
            var n : int = (buff.length >> 1) - (fcnt & 1);

            while (n > 2)
            {
                n--; n--;

                // custom PRNG
                s = (((s & 1) - 1) & 0xF00FC7C8) ^ (s >> 1);

                // color noise
                buff[n << 1] = s;
            }

            seed = s;

            bmd.setVector(bmd.rect, buff);
        }
    }
}