/**
 * Copyright flashisobar ( http://wonderfl.net/user/flashisobar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2KKo
 */

// forked from a_24's New tween library Tween24 on wonderfl
package
{
    import a24.tween.EventTween24;
    import a24.tween.Tween24;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import net.hires.debug.Stats;
    import net.wonderfl.utils.FontLoader;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor="#000000")]
    public class HellowTween24 extends Sprite {
        
        public function HellowTween24()
        {
            // Background
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0);
            bg.graphics.drawRect(0, 0, 465, 465);
            addChild(bg);
            
            // stats
            //addChild(new Stats());
            
            // Load Font
            var loader:FontLoader = new FontLoader();
            loader.addEventListener(Event.COMPLETE, function():void {
                
                // MouseEvent Tween
                EventTween24.onRollOver(bg,
                    Tween24.tween(bg, 0.05).bright(1),
                    Tween24.tween(bg, 0.2).bright(0.4)
                );
    
                EventTween24.onRollOut(bg, 
                    Tween24.tween(bg, 0.4).bright(0)
                );
    
                EventTween24.onClick(bg, 
                    Tween24.getURL("http://code.google.com/p/tween24/", "_blank")
                );
                
                // TextField
                var text1:TextField = getTextField(40, "こんにちは");
                var text2:TextField = getTextField(40, "Hello World");
                var text3:TextField = getTextField(40, "中文測試");
                var text4:TextField = getTextField(32, "New tween library Tween24");
                var text5:TextField = getTextField(16, "onCmplete testing.");

                // Tween Animation
                Tween24.serial(
                    Tween24.func(EventTween24.enabled, false, bg),
                    Tween24.wait(0.5),
                    
                    // Text1 tween
                    Tween24.prop(text1).$x(-460).fadeIn().glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                    Tween24.addChild(stage, text1),
                    Tween24.tween(text1, 0.1).fadeIn(),
                    Tween24.tween(text1, 0.1).$x(0),
                    Tween24.prop(text1).glow(0xFFFFFF, 0.5, 12, 12, 2).blurX(0),
                    Tween24.wait(1.5),
                    Tween24.prop(text1).glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                    Tween24.tween(text1, 0.1).$x(200).andRemove(),
                    Tween24.wait(0.5),
                    
                    // Text2 tween
                    Tween24.prop(text2).$x(-460).fadeIn().glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                    Tween24.addChild(stage, text2),
                    Tween24.tween(text2, 0.1).fadeIn(),
                    Tween24.tween(text2, 0.1).$x(0),
                    Tween24.prop(text2).glow(0xFFFFFF, 0.5, 12, 12, 2).blurX(0),
                    Tween24.wait(1.5),
                    Tween24.prop(text2).glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                    Tween24.tween(text2, 0.1).$x(200).andRemove(),
                    Tween24.wait(0.5),
                    
                    // Text3 tween
                    Tween24.prop(text3).$x(-460).fadeIn().glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                    Tween24.addChild(stage, text3),
                    Tween24.tween(text3, 0.1).fadeIn(),
                    Tween24.tween(text3, 0.1).$x(0),
                    Tween24.prop(text3).glow(0xFFFFFF, 0.5, 12, 12, 2).blurX(0),
                    Tween24.wait(1.5),
                    Tween24.prop(text3).glow(0xFFFFFF, 1, 32, 32, 6, 2).blurX(128),
                    Tween24.tween(text3, 0.1).$x(200).andRemove(),
                    Tween24.wait(0.5),
                    
                    // Text4 tween
                    Tween24.prop(text4).$y(-20).fadeOut().glow(0xFFFFFF, 0.6, 12, 12, 2, 2),
                    Tween24.addChild(stage, text4),
                    Tween24.tween(text4, 0.6).fadeIn(),
                    Tween24.wait(0.4),
                    Tween24.tween(text4, 0.4).glow(0xFFFFFF, 1, 24, 24, 8),
                    Tween24.tween(text4, 0.6).glow(0xFFFFFF, 0.6, 12, 12, 2),
                    
                    // Text5 tween
                    Tween24.prop(text5).$y(20).alpha(0),
                    Tween24.addChild(stage, text5),
                    Tween24.tween(text5, 3).alpha(0.6).onComplete(onComplete, text5),
                    Tween24.func(EventTween24.enabled, true, bg)

                    
                ).play();
            });
            
            loader.load("Mona");
        }
        
        private function onComplete(__text:TextField):void
        {
            __text.visible = false;
        }

        private function getTextField(size:Number, text:String):TextField
        {
            var tf:TextField = new TextField();
            tf.width = 465;
            tf.autoSize = "center";
            tf.defaultTextFormat = new TextFormat("Mona", size, 0xFFFFFF);
            tf.embedFonts = true;
            tf.text = text;
            tf.y = 465 - tf.textHeight >> 1;
            return tf;
        }
    }
}