/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Jz6
 */

package {
    import flash.events.MouseEvent;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
           onClick(null);
        
           stage.addEventListener(MouseEvent.MOUSE_UP, onClick);
           stage.addEventListener(Event.ENTER_FRAME, onEnter);     
        }//ctor
        
       public function onClick(e:MouseEvent):void
        {
          var ax:Number; var ay:Number;      var i:int; var ang:Number;
          var num:int; var d:Number;
          num = 32;      
          vecVert = new Vector.<xPoint>(0, false);
          //prob: sometimes this makes invalid polys
          for (i = 0; i < num; i++)
          {
            ang = (6.28 / num) * i;
            d = Math.random() * 120 + 32;
            ax = 230 + Math.cos(ang) * d;
            ay = 230 + Math.sin(ang) * d;
            vecVert.push(new xPoint(ax,ay));
          }//nexti
        }//onclick        
        
         public var vecVert:Vector.<xPoint> = new Vector.<xPoint>(0, false);

        
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            drawPoly(graphics, vecVert, 0);

           var mx:Number; var my:Number;
            mx = stage.mouseX; my = stage.mouseY;
            graphics.drawCircle(mx, my, 6);
            
          if (isPointIn(mx, my, vecVert))
          {
           graphics.beginFill(0, 1); 
             graphics.drawCircle(mx, my, 3);
           graphics.endFill();
          }

            graphics.lineStyle(1,0xFF);
            earClip(vecVert);
            
        }//onenter
        
        
        
        public function earClip(invec:Vector.<xPoint>):void
        {
          var i:int; var num:int;  var vec:Vector.<xPoint>;
          var a:xPoint; var b:xPoint; var c:xPoint;
          var k:int; var m:int;
    
          num = invec.length;  vec = new Vector.<xPoint>(num, false);
          for (i = 0; i < num; i += 1) { vec[i] = invec[i]; }
          
          num = vec.length; i = 0; m = 0;
          while (num > 3)
          {
            i += 1; if (i >= num) { i = 0; }        
            m += 1; if (m >= 256) {  return; } //in case poly is not valid we otherwise get infinite loop
            
            a = vec[i];
            b = i == 0 ? vec[num - 1] : vec[i - 1];
            c = i == num - 1 ? vec[0] : vec[i + 1];
            
            if (isEar(b, c, vec) == false) { continue; }
            for (k = i; k < num-1; k++)
            {  vec[k] = vec[k + 1]; }
            vec.pop();
             num -= 1; i -= 1; 
             //i = 0;
    
            graphics.beginFill(0, 0.15);
             graphics.moveTo(b.cx, b.cy);
             graphics.lineTo(a.cx, a.cy);
             graphics.lineTo(c.cx, c.cy);
            graphics.endFill();
           
          }//nexti
    
          //final one
          a = vec[1];      b = vec[0];      c = vec[2];
       
          graphics.beginFill(0xff, 0.5);
           graphics.moveTo(b.cx, b.cy);
           graphics.lineTo(a.cx, a.cy);
           graphics.lineTo(c.cx, c.cy);
          graphics.endFill();
          
        }//earclip

        

        //check if line between two neighbours inside poly       
        public function isEar(a:xPoint, b:xPoint, vec:Vector.<xPoint>):Boolean
        { 
          if (isPointIn(a.cx + (b.cx - a.cx) * 0.5, a.cy + (b.cy - a.cy) * 0.5, vec) == false) { return false; }
          if (isPointIn(a.cx + (b.cx - a.cx) * 0.25, a.cy + (b.cy - a.cy) * 0.25, vec) == false) { return false; }
          if (isPointIn(a.cx + (b.cx - a.cx) * 0.75, a.cy + (b.cy - a.cy) * 0.75, vec) == false) { return false; }      
          return true;
        }//isear  
        
        public function isPointIn(px:Number, py:Number, vec:Vector.<xPoint>):Boolean
        {
          var w:int;    var wz:Number;   var num:int; var i:int;
          var a:xPoint; var b:xPoint;   
          num = vec.length;      w = 0;       
         
           for (i = 0; i < num; i+=1)
           {
             a = i == 0 ? vec[num-1] : vec[i-1]; 
             b = vec[i];   
             if (a.cy <= py && b.cy <= py) { continue; }
             if (a.cy > py && b.cy > py) { continue; }
             //which side of the line we are on? (using cross product)   
             wz = ((px - a.cx) * (b.cy - a.cy)) - ((py - a.cy) * (b.cx - a.cx));
             if (wz > 0) { w+= 1;}  else if (wz < 0) { w -= 1;}       
           }//nexti      
          return (w != 0);
        }//ispointin
            
                  
        public function drawPoly(g:Graphics, vec:Vector.<xPoint>, sx:Number = 0, sy:Number = 0):void
        {
          var i:int; var num:int; var a:xPoint;
          num = vec.length;
          for (i = 0; i < num; i++)
          {
            a = vec[i];
            if (i == 0) { g.moveTo(a.cx - sx, a.cy - sy); continue; }
            g.lineTo(a.cx - sx, a.cy - sy);
          }//nexti
          a = vec[0];  g.lineTo(a.cx - sx, a.cy - sy);
        }//drawpoint 
            
        
    }//classend
}

internal class xPoint
{
  public var cx:Number = 0;
  public var cy:Number = 0;
  public var cz:Number = 0;
  
  public function xPoint(ax:Number = 0, ay:Number = 0)
  { cx = ax; cy = ay; }
  
}//xvert