/**
 * Copyright KiKiKi ( http://wonderfl.net/user/KiKiKi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2JoC
 */

// forked from KiKiKi_KiKi's Papervision3d 練習2011-1-21
// forked from KiKiKi_KiKi's Papervision3d 練習2011-1-12
package {
    //Papervision3d 練習 26.01.2011
    //cameraを付けてみた。
    import flash.display.Sprite;
    import flash.events.Event;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    public class Main extends BasicView {
        
        private var sphere1:Sphere;
        private var sphere2:Sphere;
        
        public function Main() {
            //create material
            var material:WireframeMaterial = new WireframeMaterial(0x0000FF);
            
            //3d Object
            sphere1 = new Sphere(material, 300, 10, 10);
            sphere2 = new Sphere(material, 300, 10, 10);
            
            //座標を設定
            sphere1.x = 290;
            sphere2.x = -290;
            
            //addChild 3d scene
            scene.addChild(sphere1);
            scene.addChild(sphere2);
            
            //Rendering
            startRendering();
            
            this.addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(evt:Event):void {
            sphere1.rotationY += 1;
            sphere1.rotationZ += 1;
            sphere2.rotationY += -1;
            sphere2.rotationZ += -1;
            
            // カメラを移動
            var rateX:Number = mouseX / stage.stageWidth;
            var rateY:Number = mouseY / stage.stageHeight;
            
            var targetX:Number = -5000 * (rateX - 0.5);
            var targetY:Number = 5000 * (rateY - 0.5);
            
            camera.x += (targetX - camera.x) * 0.2;
            camera.y += (targetY - camera.y) * 0.2;
        }
        
    }
}