/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2JiO
 */

package {
	
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.GraphicsPathCommand;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import caurina.transitions.Tweener;
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#FFFFFF")]
	
	/**
	 * graphics.drawPath を使った作品もどき 1
	 * ステージクリックで変形
	 * @author Yoshida, Akio
	 */
	public class Main extends Sprite {
		
		private var canvasShape:Shape;			// キャンバス
		private var commandVector:Vector.<int>;		// drawPath の第1引数
		private var dataVector:Vector.<Number>;		// drawPath の第2引数
		private var coordinateVector:Vector.<Coordinate>;	// Tweener 用
		private const NUM_OF_ANCHOR:uint = 13;		// アンカー数
		
		
		public function Main() {
			mouseChildren = false;
			
			init();
			
			stage.addEventListener(MouseEvent.CLICK, clickHandler);
			clickHandler(null);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		// 初期化
		private function init():void {
			// キャンバス生成
			canvasShape = new Shape();
			addChild(canvasShape);
			
			// drawPath 第1引数
			// 線にとって閉じた図形にするため、線の数はアンカーの数と等しい
			var num:uint = NUM_OF_ANCHOR;
			commandVector = new Vector.<int>(num, true);
			// commandVector の要素を定義
			commandVector[0] = GraphicsPathCommand.MOVE_TO;
			for (var i:uint = 1; i < num; i++) {
				commandVector[i] = GraphicsPathCommand.LINE_TO;
			}
			
			// drawPath 第2引数
			// X,Y 座標なので、数はアンカー数の二倍
			num = NUM_OF_ANCHOR * 2;
			dataVector       = new Vector.<Number>(num, true);
			coordinateVector = new Vector.<Coordinate>(num, true);
			// coordinateVector の要素を初期化
			for (i = 0; i < num; i++) {
				coordinateVector[i] = new Coordinate();
				coordinateVector[i].value = stage.stageWidth / 2;
			}
		}
		
		// マウスクリックハンドラ
		private function clickHandler(event:MouseEvent):void {
			var w:uint = stage.stageWidth;
			var h:uint = stage.stageHeight;
			var margin:uint = 25;
			var num:uint = NUM_OF_ANCHOR;
			for (var i:uint = 0; i < num; i++) {
				var idxX:uint = i * 2;
				var idxY:uint = i * 2 + 1;
				var coordinateX:Coordinate = coordinateVector[idxX];
				var coordinateY:Coordinate = coordinateVector[idxY];
				var valueX:Number = Math.random() * (w - margin * 2) + margin;
				var valueY:Number = Math.random() * (h - margin * 2) + margin;
				Tweener.addTween(coordinateX, {
					value:valueX,
					time:2.5,
					delay:idxX * 0.02,
					transition:"easeOutElastic"
				});
				Tweener.addTween(coordinateY, {
					value:valueY,
					time:2.5,
					delay:idxY * 0.02,
					transition:"easeOutElastic"
				});
			}
		}
		
		// ENTE_FRAME ハンドラ
		private function enterFrameHandler(e:Event):void {
			draw();
		}
		
		// 描画
		private function draw():void {
			// dataVector 定義
			var num:uint = NUM_OF_ANCHOR * 2;
			for (var i:uint = 0; i < num; i++) {
				dataVector[i] = coordinateVector[i].value;
			}
			// 描画
			canvasShape.graphics.clear();
			canvasShape.graphics.beginFill(0xFF6699, 1);
			canvasShape.graphics.drawPath(commandVector, dataVector);
			canvasShape.graphics.endFill();
		}
		
	}
	
}

class Coordinate {
	public var value:Number = 0.0;
	public function Coordinate() {}
}

