/**
 * Copyright miniapp ( http://wonderfl.net/user/miniapp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2JWy
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.getTimer;

    [SWF(backgroundColor=0xFFFFFF, width=465, height=465, frameRate=60)]
    public class Performance extends Sprite
    {
        private static const NUM_STEPS:int = 10000000;
        private static const sampleArray:Array = (function():Array
        {
            var arr:Array = [];
            for(var i:int = 0; i < NUM_STEPS; ++i)
            {
                arr[i] = i;
            }
            return arr;
        })();
        
        private var _field:TextField;
        private var _time:uint;
        
        public function Performance():void
        {
            _setup();
            _init();
        }
        
        private function _init():void
        {
            _debug(    "for文で終了条件となる配列の長さを宣言する場所テスト\n");
            
            _measure("for文の外で宣言", for1);
            _measure("毎回array.lengthにアクセス", for2);
            _measure("for文の中?で宣言", for3);
            
            _field.appendText('\nインクリメントする位置を後ろに変えてテスト\n\n');
            
            _measure("for文の外で宣言 インクリメント後ろ", for_1);
            _measure("毎回array.lengthにアクセス インクリメント後ろ", for_2);
            _measure("for文の中?で宣言 インクリメント後ろ", for_3);
            
            _debug("\n結果については言及しませんので, 各自ご判断ください.");
        }
        
//---------------------------------------------------------------------------------------------        
        
        /**
         * for文の外で宣言
         */ 
        private function for1():void
        {
            var len:int = sampleArray.length;
            for (var i:int = 0; i < len; ++i) {
                
            }
        }
        
        /**
         * 毎回array.lengthにアクセス
         */ 
        private function for2():void
        {
            for (var i:int = 0; i < sampleArray.length; ++i) {
                
            }
        }    
        
        /**
         * for文の中?で宣言
         */ 
        private function for3():void
        {
            for (var i:int = 0, len:int = sampleArray.length; i < len; ++i) {
                
            }
        }
        
//---------------------------------------------------------------------------------------------        
        
        /**
         * for文の外で宣言
         */ 
        private function for_1():void
        {
            var len:int = sampleArray.length;
            for (var i:int = 0; i < len; i++) {
                
            }
        }
        
        /**
         * 毎回array.lengthにアクセス
         */ 
        private function for_2():void
        {
            for (var i:int = 0; i < sampleArray.length; i++) {
                
            }
        }    
        
        /**
         * for文の中?で宣言
         */ 
        private function for_3():void
        {
            for (var i:int = 0, len:int = sampleArray.length; i < len; i++) {
                
            }
        }
        
//---------------------------------------------------------------------------------------------                
        
        private function _measure(title:String, func:Function, ...params):void
        {
            _time = getTimer();
            func.apply(null, params);
            _time = getTimer() - _time;
            
            _debug("[ " + title + " ] --> " + _time + " ms");
        }
        
        private function _debug(log:String):void
        {
            _field.appendText(log + "\n");
        }
        
        private function _setup():void
        {
            _field = new TextField();
            _field.width = stage.stageWidth - 40;
            _field.height = stage.stageHeight - 60;
            _field.x = 20;
            _field.y = 60;
            
            var format:TextFormat = _field.defaultTextFormat;
            format.font = "_typewriter";
            _field.defaultTextFormat = format;
            
            addChild(_field);
            
            var button:Sprite = new Sprite();
            button.graphics.lineStyle(1, 0xBBBBBB);
            button.graphics.beginFill(0xEEEEEE);
            button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
            button.graphics.endFill();
            
            addChild(button);
            
            button.x = 20;
            button.y = 20;
            button.mouseChildren = false;
            button.buttonMode = true;
            
            var field:TextField = new TextField();
            field.width = 100;
            field.height = 20;
            field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
            
            button.addChild(field);
            
            button.addEventListener(MouseEvent.CLICK, function ():void
            {
                _field.text = "";
                _init();
            });
        }
    }
    
}
