/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2I0d
 */

/**
 * @author : matacat
 * このコードを書くに当たり、以下のページからデータをお借りしています。
 * もし何か問題があれば、Talk欄に報告お願いします。
 * @see http://www.serebii.net/pokedex3d/pokemon.shtml
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    
    public class Pokedex3DMarker extends Sprite
    {
        private const BACK_COLOR:uint = 0xFFFFDD;
        private const FORE_COLOR:uint = 0x220000;
        private const SCALE:Number    = 40;
        
        private var bmd:BitmapData;
        private var sp:Sprite;
        private var tf:TextField;
        private var ar:Vector.<uint>;
        private var pk:Vector.<String>;
        private var id:int;
        private var len:int;
        
        public function Pokedex3DMarker()
        {
            bmd = new BitmapData(8, 8, false, 0xFFFFFF);
            sp  = new Sprite();
            tf  = new TextField();
            ar  = getARData();
            pk  = getNameData();
            id  = 1;
            len = ar.length << 1;
            
            var bmp:Bitmap = new Bitmap(bmd, "always", false);
            bmp.scaleX = SCALE;
            bmp.scaleY = SCALE;
            bmp.x      = -bmp.width >> 1;
            bmp.y      = -bmp.height >> 1;
            sp.addChild(bmp);
            
            sp.x         = stage.stageWidth >> 1;
            sp.y         = stage.stageHeight >> 1;
            sp.rotationX = 0;
            sp.rotationZ = 0;
            addChild(sp);
            
            tf.defaultTextFormat = new TextFormat(null, 32);
            tf.autoSize = "left";
            tf.text     = "No.000 ダミー・テキスト"
            tf.x        = stage.stageWidth - tf.width >> 1;
            tf.y        = stage.stageHeight - 35;
            addChild(tf);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            onKeyDown();
        }
        
        private function onKeyDown(e:KeyboardEvent = null):void
        {
            if (e) {
                switch (e.keyCode) {
                    case Keyboard.LEFT:  id--; if (id <  0)   id = 0;       break;
                    case Keyboard.RIGHT: id++; if (id >= len) id = len - 1; break;
                    case Keyboard.S:     sp.rotationX++; return;
                    case Keyboard.W:     sp.rotationX--; return;
                    case Keyboard.D:     sp.rotationZ++; return;
                    case Keyboard.A:     sp.rotationZ--; return;
                    case Keyboard.SPACE: sp.rotationX = 0; sp.rotationZ = 0; return;
                }
            }
            
            var bin:uint = ar[id >> 1];
            if (id & 1) bin >>= 16;
            drawARData(bmd, bin, FORE_COLOR, BACK_COLOR);
            tf.text = (id + 2 < len ? "No." : "") + pk[id];
        }
        
        public function drawARData(
            dest:BitmapData,
            data:uint       = 0x0000,
            foreColor:uint  = 0x000000,
            backColor:uint  = 0xFFFFFF
        ):void
        {
            if (dest.width != 8 || dest.height != 8) {
                throw new Error("Destination bitmapdata's size must be 8x8.");
            }
            
            for (var i:int = 0; i < 8; i++) {
                for (var j:int = 0; j < 8; j++) {
                    
                    var f:Boolean = false;
                    if (i > 0 && i < 7) {
                        if (i > 1 && i < 6) {
                            if (j > 1 && j < 6) {
                                f = Boolean(data & 1);
                                data >>= 1;
                            } else {
                                f = (j > 0 && j < 7);
                            }
                        } else {
                            f = (j > 0 && j < 7);
                        }
                    }
                    
                    if (f) dest.setPixel(j, i, foreColor);
                    else   dest.setPixel(j, i, backColor);
                }
            }
        }
        
        public function getARData():Vector.<uint>
        {
            return new <uint>[
0x1D608D60, 0xB5680D61, 0x3569A569, 0xB5612568, 0x3560A560, 0x95782561, 0x15798579,
0x95710578, 0x15708570, 0xF8CE0571, 0x78CFE8CF, 0xF8C768CE, 0x78C6E8C6, 0xD8DE68C7,
0xC8DFA056, 0x48DE58DF, 0xC8D6D8D7, 0x48D758D6, 0xE0DFF0DE, 0x60DE70DF, 0xE0D6F0D7,
0x60D770D6, 0xC0CFD0CE, 0x40CE50CF, 0xC0C6D0C7, 0x40C750C6, 0xE8DBF8DA, 0x68DA78DB,
0xE8D2F8D3, 0x78D2985E, 0xD8CA68D3, 0x58CBC8CB, 0x48CA885F, 0xC8C2D8C3, 0x48C358C2,
0xE0CBF0CA, 0x60CA70CB, 0xE0C2F0C3, 0x60C370C2, 0xC0DBD0DA, 0x40DA50DB, 0xC0D2D0D3,
0x40D350D2, 0xA9CFB9CE, 0x29CE39CF, 0xA9C6B9C7, 0x29C739C6, 0x185F99DE, 0x9857085E,
0x885689DF, 0x08571856, 0x09DE19DF, 0x89D699D7, 0x09D719D6, 0xB1DE3056, 0xA1DF2057,
0x21DE31DF, 0xA1D6B1D7, 0x21D731D6, 0x81CF91CE, 0x01CE11CF, 0x81C691C7, 0x01C711C6,
0xA9DBB9DA, 0x29DA39DB, 0xA9D2B9D3, 0x29D339D2, 0x89CB99CA, 0x09CA19CB, 0x89C299C3,
0x09C319C2, 0xA1CBB1CA, 0x21CA31CB, 0xA1C2B1C3, 0x21C331C2, 0x81DB91DA, 0x01DA11DB,
0x81D291D3, 0x01D311D2, 0xE94FF94E, 0x694E794F, 0xE946F947, 0x00001949
            ];
        }
        
        public function getNameData():Vector.<String>
        {
            return new <String>[
"000 ビクティニ", "001 ツタージャ", "002 ジャノビー", "003 ジャローダ", "004 ポカブ", "005 チャオブー", "006 エンブオー",
"007 ミジュマル", "008 フタチマル", "009 ダイケンキ", "010 ミネズミ", "011 ミルホッグ", "012 ヨーテリー", "013 ハーデリア",
"014 ムーランド", "015 チョロネコ", "016 レパルダス", "017 ヤナップ", "018 ヤナッキー", "019 バオップ", "020 バオッキー",
"021 ヒヤップ", "022 ヒヤッキー", "023 ムンナ", "024 ムシャーナ", "025 マメパト", "026 ハトーボー", "027 ケンホロウ♂",
"027 ケンホロウ♀", "028 シママ", "029 ゼブライカ", "030 ダンゴロ", "031 ガントル", "032 ギガイアス", "033 コロモリ",
"034 ココロモリ", "035 モグリュー", "036 ドリュウズ", "037 タブンネ", "038 ドッコラー", "039 ドテッコツ", "040 ローブシン",
"041 オタマロ", "042 ガマガル", "043 ガマゲロゲ", "044 ナゲキ", "045 ダゲキ", "046 クルミル", "047 クルマユ",
"048 ハハコモリ", "049 フシデ", "050 ホイーガ", "051 ペンドラー", "052 モンメン", "053 エルフーン", "054 チュリネ",
"055 ドレディア", "056 バスラオ・赤", "056 バスラオ・青", "057 メグロコ", "058 ワルビル", "059 ワルビアル", "060 ダルマッカ",
"061 ヒヒダルマ・通常", "061 ヒヒダルマ・達磨", "062 マラカッチ", "063 イシズマイ", "064 イワパレス", "065 ズルッグ", "066 ズルズキン",
"067 シンボラー", "068 デスマス", "069 デスカーン", "070 プロトーガ", "071 アバゴーラ", "072 アーケン", "073 アーケオス",
"074 ヤブクロン", "075 ダストダス", "076 ゾロア", "077 ゾロアーク", "078 チラーミィ", "079 チラチーノ", "080 ゴチム",
"081 ゴチミル", "082 ゴチルゼル", "083 ユニラン", "084 ダブラン", "085 ランクルス", "086 コアルヒー", "087 スワンナ",
"088 バニプッチ", "089 バニリッチ", "090 バイバニラ", "091 シキジカ・春", "091 シキジカ・夏", "091 シキジカ・秋", "091 シキジカ・冬",
"092 メブキジカ・春", "092 メブキジカ・夏", "092 メブキジカ・秋", "092 メブキジカ・冬", "093 エモンガ", "094 カブルモ", "095 シュバルゴ",
"096 タマゲタケ", "097 モロバレル", "098 プルリル♂", "098 プルリル♀", "099 ブルンゲル♂", "099 ブルンゲル♀", "100 ママンボウ",
"101 バチュル", "102 デンチュラ", "103 テッシード", "104 ナットレイ", "105 ギアル", "106 ギギアル", "107 ギギギアル",
"108 シビシラス", "109 シビビール", "110 シビルドン", "111 リグレー", "112 オーベム", "113 ヒトモシ", "114 ランプラー",
"115 シャンデラ", "116 キバゴ", "117 オノンド", "118 オノノクス", "119 クマシュン", "120 ツンベアー", "121 フリージオ",
"122 チョボマキ", "123 アギルダー", "124 マッギョ", "125 コジョフー", "126 コジョンド", "127 クリムガン", "128 ゴビット",
"129 ゴルーグ", "130 コマタナ", "131 キリキザン", "132 バッフロン", "133 ワシボン", "134 ウォーグル", "135 バルチャイ",
"136 バルジーナ", "137 クイタラン", "138 アイアント", "139 モノズ", "140 ジヘッド", "141 サザンドラ", "142 メラルバ",
"143 ウルガモス", "144 コバルオン", "145 テラキオン", "146 ビリジオン", "147 トルネロス", "148 ボルトロス", "149 レシラム",
"150 ゼクロム", "151 ランドロス", "152 キュレム", "ランダム", "空白"
            ];
        }
    }
}