/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2HWK
 */

package
{
    import net.hires.debug.*;
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(frameRate = 60, width = 1024, height = 768)]
    public class Main extends Sprite
    {
        private var horizontalBackdrop :Sprite;
        private var verticalBackdrop :Sprite;
        
        public function Main()
        {
            stage.scaleMode = StageScaleMode.SHOW_ALL;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            horizontalBackdrop = new Sprite();
            horizontalBackdrop.mouseEnabled = false;
            verticalBackdrop = new Sprite();
        }
        
        public function _init() :void
        {
            var cT :Number = Buffer.canvasLine;
            var cW :Number = Buffer.canvasWidth;
            var cH :Number = Buffer.canvasHeight;

            graphics.lineStyle (cT, 0, 1);
            graphics.beginFill (0, 0.5);
            graphics.drawRect  (0, 0, (cW - 1), (cH - 1));
            graphics.endFill   ();
        }
    
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.buildGrid(this);    
            addChild(Buffer.gridOutput = new Output(""));
            addChild(new Output("Red", 100, 60));
            addChild(new Output("Orange", 142, 60));
            addChild(new Output("Yellow", 193, 60));
            addChild(new Output("Lime", 248, 60));
            addChild(new Output("Green", 297, 60));
            addChild(new Output("Aqua", 349, 60));
            addChild(new Output("Cyan", 398, 60));
            addChild(new Output("Azure", 446, 60));
            addChild(new Output("Blue", 500, 60));
            addChild(new Output("Purple", 545, 60));
            addChild(new Output("Violet", 597, 60));
            
            horizontalBackdrop.graphics.beginFill(0xFFFFFF, 0.35);
            horizontalBackdrop.graphics.drawRect (90, 60, 550, 18);
            horizontalBackdrop.graphics.endFill  ();
            
            addChild(horizontalBackdrop);

            _init();
        }
    }    
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var canvasLine :Number = 1;
    public static var canvasWidth :Number = 1024;
    public static var canvasHeight :Number = 764;    
    
    public static var gridContext :Object;
    public static var gridScore :Number = 0;
    public static var gridOutput :Output;
    public static var gridNodes :Array = [];
    public static var gridScale :Point = new Point(12, 14);
    public static var gridTargetX :Number = 0;
    public static var gridTargetY :Number = 0;
    public static var gridMarginX :Number = 0.80;
    public static var gridMarginY :Number = 2;
    public static var gridNodeSize :Number = 50;
    public static var gridScatter :Boolean = false;
    public static var gridProgress :int = 0;
    public static var gridColor :Array = [0xCCCCCC, 0xBFBFBF, 0xB3B3B3, 0xA6A6A6, 0x999999, 0x8C8C8C, 0x808080, 0x737373, 0x666666, 0x595959, 0x4D4D4D, 0x404040,
                                          0xFF9999, 0xFF8080, 0xFF6666, 0xFF4D4D, 0xFF3333, 0xFF1A1A, 0xFF0000, 0xE60000, 0xCC0000, 0xB30000, 0x990000, 0x800000, //red
                                          0xFFCE99, 0xFFC180, 0xFFB566, 0xFFA94D, 0xFF9C33, 0xFF901A, 0xFF8400, 0xE67700, 0xCC6900, 0xB35C00, 0x994F00, 0x804200,
                                          0xFFFF99, 0xFFFF80, 0xFFFF66, 0xFFFF4D, 0xFFFF33, 0xFFFF1A, 0xFFFF00, 0xE6E600, 0xCCCC00, 0xB3B300, 0x999900, 0x808000, //yellow
                                          0xCFFF99, 0xC3FF80, 0xB8FF66, 0xACFF4D, 0xA0FF33, 0x94FF1A, 0x88FF00, 0x7AE600, 0x6DCC00, 0x5FB300, 0x529900, 0x448000,
                                          0x99FF99, 0x80FF80, 0x66FF66, 0x4DFF4D, 0x33FF33, 0x1AFF1A, 0x00FF00, 0x00E600, 0x00CC00, 0x00B300, 0x009900, 0x008000, //green
                                          0x99FFCF, 0x80FFC3, 0x66FFB8, 0x4DFFAC, 0x33FFA0, 0x1AFF94, 0x00FF88, 0x00E67A, 0x00CC6D, 0x00B35F, 0x009952, 0x008044,
                                          0x99FFFF, 0x80FFFF, 0x66FFFF, 0x4DFFFF, 0x33FFFF, 0x1AFFFF, 0x00FFFF, 0x00E6E6, 0x00CCCC, 0x00B3B3, 0x009999, 0x008080, //cyan
                                          0x99CFFF, 0x80C3FF, 0x66B8FF, 0x4DACFF, 0x33A0FF, 0x1A94FF, 0x0088FF, 0x007AE6, 0x006DCC, 0x005FB3, 0x005299, 0x004480,
                                          0x9999FF, 0x8080FF, 0x6666FF, 0x4D4DFF, 0x3333FF, 0x1A1AFF, 0x0000FF, 0x0000E6, 0x0000CC, 0x0000B3, 0x000099, 0x000080, //blue
                                          0xCF99FF, 0xC380FF, 0xB866FF, 0xAC4DFF, 0xA033FF, 0x941AFF, 0x8800FF, 0x7A00E6, 0x6D00CC, 0x5F00B3, 0x520099, 0x440080,
                                          0xFF99FF, 0xFF80FF, 0xFF66FF, 0xFF4DFF, 0xFF33FF, 0xFF1AFF, 0xFF00FF, 0xE600E6, 0xCC00CC, 0xB300B3, 0x990099, 0x800080, //purple
                                          ];

    private static var gridCount :Number = 0;
    
    public static function buildGrid($context:Object) :void
    {
        gridContext = $context;
             
        for (var $x:Number = gridMarginX; $x < gridScale.x; $x++)
        {  
            gridNodes[$x] = [];
            
            for (var $y:Number = gridMarginY; $y < gridScale.y; $y++)
            {
                gridNodes[$x][$y] = new GridNode($x, $y, gridNodeSize, gridColor[gridCount]);
                $context.addChild(gridNodes[$x][$y]);
                gridCount += 1;
            }
        }
    }
    
    public static function parseProgress() :void
    {
        for (var $c:Number = 0; $c < gridColor.length; $c++) 
            { for (var $x:Number = gridMarginX; $x < gridScale.x; $x++)
                 { for (var $y:Number = gridMarginY; $y < gridScale.y; $y++)
                       { if ($c >= gridTargetX && $c < gridTargetY)
                            { if (gridNodes[$x][$y].fill == gridColor[$c])
                                 { if (gridNodes[$x][$y].normalized && !gridNodes[$x][$y].completed) 
                                      {gridProgress++; gridOutput.content = ("$S: " + gridProgress); gridNodes[$x][$y].completed = true }}}}}}
                                      
                                      gridOutput.content = "select: " + $tempA[$final];
    }
    
    public static var $tempA :Array = [];
    public static var $final :int = -1;
    
    public static function judgeNormals($:Object) :Point
    {
        var $a :Array = [];
        //var $tA :Array = [];
        var $temp :Number = 0;
        //var $final :Number = -1;
        
        for (var $c:Number = 0; $c < gridColor.length; $c++) 
            { for (var $x:Number = gridMarginX; $x < gridScale.x; $x++)
                  { for (var $y:Number = gridMarginY; $y < gridScale.y; $y++)
                        { if ($c >= gridTargetX && $c < gridTargetY)
                             { if (gridNodes[$x][$y].fill == gridColor[$c])
                                  { 
                                  var $dist:Number = ($.y - gridNodes[$x][$y].regY);  
                  
                                  $a.push($dist);
                                  $tempA.push(new Point((gridNodes[$x][$y].regX), (gridNodes[$x][$y].regY)));
                  }}}}}
                  
        $temp = $a[0];
                  
        for (var $i:Number = 0; $i < $a.length; $i++)
            {
                if ($a[$i] < $temp)
                {
                    $temp = $a[$i];
                    $final = $i;
                }
                
                gridOutput.content = "0: " + $tempA[0] + "\n" +
                                     "1: " + $tempA[1] + "\n" +
                                     "2: " + $tempA[2] + "\n" +
                                     "3: " + $tempA[3] + "\n" +
                                     "4: " + $tempA[4] + "\n" +
                                     "5: " + $tempA[5] + "\n" +
                                     "6: " + $tempA[6] + "\n" +
                                     "7: " + $tempA[7] + "\n" +
                                     "8: " + $tempA[8] + "\n" +
                                     "9: " + $tempA[9] + "\n" +
                                     "10: " + $tempA[10] + "\n" +
                                     "11: " + $tempA[11] + "\n";
            }
            
        return $tempA[$final];
    }
    
    public static function checkColors($:Object) :void
    { 
        identifyFragment($);
    
        for (var $c:Number = 0; $c < gridColor.length; $c++) 
            { for (var $x:Number = gridMarginX; $x < gridScale.x; $x++)
                 { for (var $y:Number = gridMarginY; $y < gridScale.y; $y++)
                       { if ($x > 1) {gridNodes[$x][$y].scatterInit()} if (!($c >= gridTargetX && $c < gridTargetY)) 
                            { if (gridNodes[$x][$y].fill == gridColor[$c])
                                 {gridNodes[$x][$y].mouseEnabled = false; if ($x > 1) { gridNodes[$x][$y].alpha = 0.05 }}}}}}
    }

    private static function identifyFragment($:Object) :void
    {
        var $var1 :Number = 0;
        var $var2 :Number = 0;
        
        for (var $c:Number = 0; $c < gridColor.length; $c++)
        {
            if ($ != null || $ != Stage)
            {
                if ($.fill == gridColor[$c])
                {
                    if ($c >= 12 && $c < 24)
                    {
                        $var1 = 12;
                        $var2 = 24
                    }
                    else if ($c > 24 && $c <= 36)
                    {
                        $var1 = 24;
                        $var2 = 36;
                    }
                    else if ($c > 36 && $c <= 48)
                    {
                        $var1 = 36;
                        $var2 = 48;
                    }
                    else if ($c > 48 && $c <= 60)
                    {
                        $var1 = 48;
                        $var2 = 60;
                    }
                    else if ($c > 60 && $c <= 72)
                    {
                        $var1 = 60;
                        $var2 = 72;
                    }
                    else if ($c > 72 && $c <= 84)
                    {
                        $var1 = 72;
                        $var2 = 84;
                    }
                    else if ($c > 84 && $c <= 96)
                    {
                        $var1 = 84;
                        $var2 = 96;
                    }
                    else if ($c > 96 && $c <= 108)
                    {
                        $var1 = 96;
                        $var2 = 108;
                    }
                    else if ($c > 108 && $c <= 120)
                    {
                        $var1 = 108;
                        $var2 = 120;
                    }
                    else if ($c > 120 && $c <= 132)
                    {
                        $var1 = 120;
                        $var2 = 132;
                    }
                    else if ($c > 132 && $c <= 144)
                    {
                        $var1 = 132;
                        $var2 = 144;
                    }
                }
            }
        }
        
        gridTargetX = $var1;
        gridTargetY = $var2;
    }
}

class GridNode extends Sprite
{    
    protected var _x :Number;
    protected var _y :Number;
    protected var _width :Number;
    protected var _height :Number;
    protected var _color :Number;
    protected var _alpha :Number;
    protected var _line :Number;
    protected var _rX :Number;
    protected var _rY :Number;
    
    private var gridX :int = -1;
    private var gridY :int = -1;
    private var gridScale :int;
    
    private var isScattered :Boolean = false;
    private var isNormalized :Boolean = false;
    private var isCompleted :Boolean = false;
    
    private var globalBegin :Point = new Point();
    private var globalCurrent :Point = new Point();
    private var localCalc :Point = new Point();
    
    private var op:Output
    
    public function GridNode($x:Number, $y:Number, $scale:Number, $color:Number)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _rX = Math.round(Math.random() * (Buffer.canvasWidth - 40));
        _rY = Math.round(Math.random() * (Buffer.canvasHeight - 40));
        _x = gridX = ($x * $scale);
        _y = gridY = ($y * $scale);
        _width = _height = gridScale = $scale;
        _color = $color;
        _alpha = 1;
        _line = 0;
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.lineStyle (1, 0xFFFFFF, _line);
        
        graphics.beginFill (_color, _alpha);
        graphics.drawRect  (_x, _y, _width, _height);
        graphics.endFill();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {      
        _line = 0.9; _init();
        parent.setChildIndex(this, (parent.numChildren - 14));
        globalBegin = new Point($e.stageX, $e.stageY);
        
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        globalCurrent = new Point($e.stageX, $e.stageY);
        localCalc = Point(globalCurrent.subtract(globalBegin));
        
        x = (x + localCalc.x);
        y = (y + localCalc.y);
        
        globalBegin = globalCurrent;
        
        if (Buffer.gridScatter)
        {
            if (isScattered)
            {
                Buffer.judgeNormals(this);
                
                //var $temp :Point = new Point();
                var $temp :Point = Buffer.$tempA[Buffer.$final];               
                
                gridX = $temp.x;
                gridY = $temp.y;
            }
        }
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        _line = 0; _init();
        globalBegin = null;
        
        if (!Buffer.gridScatter)
        {
            isNormalized = !(isScattered = true);
            Buffer.checkColors(this);
            
            scatterInit()
        }else{
            if (isScattered)
            {
                isScattered = !(isNormalized = true); 
                
                normalizeInit()
            }
        }
    }
    
    public function scatterInit() :void
    {    
        Buffer.gridScatter = true;
    
        addEventListener(Event.ENTER_FRAME, scatterOnFrame)
    }
    
    public function scatterOnFrame($e:Event) :void
    {
        if  (((x < randX-1) || (x > randX+1)) && ((y < randY-1) || (y > randY+1))) {x -= ((x - randX)/6); y -= ((y - randY)/6);}
        else {removeEventListener(Event.ENTER_FRAME, scatterOnFrame); isScattered = true}
    }
    
    public function normalizeInit() :void
    {
        addEventListener(Event.ENTER_FRAME, normalizeOnFrame);
    }
    
    public function normalizeOnFrame($e:Event) :void
    {
        if  (((x < regX-0.00001) || (x > regX+0.00001)) && ((y < regY-0.00001) || (y > regY+0.00001))) {x -= ((x - regX)/3); y -= ((y - regY)/3);}
        else {removeEventListener(Event.ENTER_FRAME, normalizeOnFrame); x = regX; y = regY; isNormalized = true; mouseEnabled = false; Buffer.parseProgress()}    
    }
    
    public function get fill() :Number
    { return _color }
    public function get regX() :Number
    { return gridX }
    public function get regY() :Number
    { return gridY }
    public function get randX() :Number
    { return _rX }
    public function get randY() :Number
    { return _rY }
    public function get normalized() :Boolean
    { return isNormalized }
    public function get scattered() :Boolean
    { return isScattered }
    public function get completed() :Boolean
    { return isCompleted }
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public function set completed($:Boolean) :void
    { isCompleted = $ }
    public override function set alpha($:Number) :void
    { _alpha = $; _init(); }
    public override function set x($:Number) :void
    { _x = $; _init(); }
    public override function set y($:Number) :void
    { _y = $; _init(); }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init(); }
    public function set content($:String) :void
    { _content = $; _init(); }
}