/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2HC3
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Graphics;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
            setProjMat(projMat, 90, 1, 1, 1000); 
    
            camz = 400;

         stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
         stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
         stage.addEventListener(Event.ENTER_FRAME, onEnter);            
       }//ctor
       
       
       public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true;  }
       public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false;  }
       public function isKeyDown(k:int):Boolean { return vecKey[k]; }
       
       public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
       
        public var ident:Vector.<Number> = Vector.<Number>([1, 0, 0, 0, 0, 1, 0, 0,  0, 0, 1, 0, 0, 0, 0, 1]); 
        public var tpmat:Vector.<Number> = Vector.<Number>([1, 0, 0, 0, 0, 1, 0, 0,  0, 0, 1, 0, 0, 0, 0, 1]); 
        public var viewMat:Vector.<Number> = Vector.<Number>([1, 0, 0, 0, 0, 1, 0, 0,  0, 0, 1, 0, 0, 0, 0, 1]); 

        public var camx:Number = 0;
        public var camy:Number = 0;
        public var camz:Number = 0;
        public var cori:xQuat = new xQuat();

    
        public function onEnter(e:Event):void
        {
            
            var ta:Number;
            ta = 0.1;
           if (isKeyDown(Keyboard.UP)) { cori.rotPitch(ta); }
           if (isKeyDown(Keyboard.DOWN)) { cori.rotPitch(-ta); }
           if (isKeyDown(Keyboard.LEFT)) { cori.rotYaw(ta); }
           if (isKeyDown(Keyboard.RIGHT)) { cori.rotYaw(-ta); }
           
            var ms:Number; ms =3;
           camx += -cori.getFrontVx()*ms;
           camy += -cori.getFrontVy()*ms;
           camz += -cori.getFrontVz()*ms;

            
           setProjMat(tpmat, 90, 465/465, 1, 16000);
           setViewMat(viewMat, camx, camy, camz,  cori.x, cori.y, cori.z, cori.w);
           multMatrix(tpmat, viewMat, projMat);

           graphics.clear();
           graphics.lineStyle(2, 0);           
            drawBox3(graphics, 0,0,0, 256,256,256);
            drawBox3(graphics, 0,0,0, 2560,2560,2560);
           
           
       
        }//onenter


        
        public var projMat:Vector.<Number> = Vector.<Number>([1, 0, 0, 0, 0, 1, 0, 0,  0, 0, 1, 0, 0, 0, 0, 1]); 
        public var scrw:Number = 465;
        public var scrh:Number = 465;
        public var rendw:Number = 465 * 0.5;
        public var rendh:Number = 465 * 0.5;  
               
       public function drawBox3(g:Graphics, ax:Number, ay:Number, az:Number,
        rx:Number, ry:Number, rz:Number):void
        { drawBox(g, ax-rx, ay-ry, az-rz,   ax + rx, ay + ry, az + rz); }
      
       public function drawBox2(g:Graphics, ax:Number, ay:Number, az:Number,
        aw:Number, ah:Number, ad:Number):void
        { drawBox(g, ax, ay, az,   ax + aw, ay + ah, az + ad); }
      
       public function drawBox(g:Graphics, minx:Number, miny:Number, minz:Number,
      maxx:Number, maxy:Number, maxz:Number):void
        {
          //bottom
          drawLine2(g, minx, miny, minz,   maxx, miny, minz);
          drawLine2(g, minx, miny, maxz,   maxx, miny, maxz);
          drawLine2(g, minx, miny, minz,   minx, miny, maxz);
          drawLine2(g, maxx, miny, minz,   maxx, miny, maxz);  
          
          //top
          drawLine2(g,minx, maxy, minz,   maxx, maxy, minz);
          drawLine2(g,minx, maxy, maxz,   maxx, maxy, maxz);
          drawLine2(g,minx, maxy, minz,   minx, maxy, maxz);
          drawLine2(g, maxx, maxy, minz,   maxx, maxy, maxz);
           
          //bot
          drawLine2(g,minx, miny, minz,   minx, maxy, minz);
          drawLine2(g,maxx, miny, minz,   maxx, maxy, minz);
          drawLine2(g,minx, miny, maxz,   minx, maxy, maxz);
          drawLine2(g,maxx, miny, maxz,   maxx, maxy, maxz);
  
        }//drawbox

      //cheat -- instead of screwing around with proper frustum clipping:
       //draw multiple little lines (and call it a day)
      public function drawLine2(g:Graphics, ax:Number, ay:Number, az:Number,
      bx:Number, by:Number, bz:Number):void
      {  
        var mat:Vector.<Number>;  var w0:Number, w1:Number;
        mat = projMat;
        w0 = ax * mat[3] + ay * mat[7] + az * mat[11] + mat[15];
        w1 = bx * mat[3] + by * mat[7] + bz * mat[11] + mat[15];
        if (w0 <= 0 && w1 <= 0) { return; }
        if (w0 > 0 && w1 > 0) { drawLine(g, ax, ay, az, bx, by, bz); return; }
        
        var u:Number; var t:Number;
        var kx:Number; var ky:Number; var kz:Number;
        kx = (bx - ax); ky = (by - ay); kz = (bz - az);
        t = 0.2;
        for (u = 0; u < 1; u += t)
        {  drawLine(g, ax + kx * u, ay + ky * u, az + kz * u,
           ax + kx * (u + t), ay + ky * (u + t), az + kz * (u + t));  }
      }//dline2
      
      public function drawLine(g:Graphics, ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
          {
            var mat:Vector.<Number>;
            var sx0:Number, sy0:Number, sz0:Number, w0:Number; 
            var sx1:Number, sy1:Number, sz1:Number, w1:Number; 
             mat = projMat;
            
        
            w0 = ax * mat[3] + ay * mat[7] + az * mat[11] + mat[15];
            w1 = bx * mat[3] + by * mat[7] + bz * mat[11] + mat[15];
            if (w0 <= 0 && w1 <= 0) { return; }
        
            sx0 = ax * mat[0] + ay * mat[4] + az * mat[8] + mat[12];
            sy0 = ax * mat[1] + ay * mat[5] + az * mat[9] + mat[13];
            //sz0 = ax * mat[2] + ay * mat[6] + az * mat[10] + mat[14];
        
            sx1 = bx * mat[0] + by * mat[4] + bz * mat[8] + mat[12];
            sy1 = bx * mat[1] + by * mat[5] + bz * mat[9] + mat[13];
            //sz1 = bx * mat[2] + by * mat[6] + bz * mat[10] + mat[14];
         
            sx0 /= w0; sy0 /= w0;
        
            //projection fix
            if (w0 < 0.0)
            { if (sx0 > 0) {  sx0 = -1.0 - sx0;  } else { sx0 = 1.0 - sx0; }
              if (sy0 > 0) {  sy0 = -1.0 - sy0; }  else { sy0 = 1.0 - sy0; }          
            }//endif  
            sx0 *= rendw;  sy0 *= -rendh;    sx0 += rendw;  sy0 += rendh;
            
            sx1 /= w1; sy1 /= w1;
            //projection fix
            if (w1 < 0.0)
            { if (sx1 > 0) {  sx1 = -1.0 - sx1;  } else { sx1 = 1.0 - sx1; }
              if (sy1 > 0) {  sy1 = -1.0 - sy1; }  else { sy1 = 1.0 - sy1; }          
            }//endif  
            sx1 *= rendw;  sy1 *= -rendh;    sx1 += rendw;  sy1 += rendh;    
            
            //my pathetic attempt at optimisation
            if (sx0 < 0 && sx1 < 0) { return; }    if (sy0 < 0 && sy1 < 0) { return; }
            if (sx0 > scrw && sx1 > scrw) { return; }  if (sy0 > scrh && sy1 > scrh) { return; }
        
            g.moveTo(sx0, sy0);    g.lineTo(sx1, sy1);        
          }//drawline  

      
     public static function setProjMat(vec:Vector.<Number>,
     fovdeg:Number = 60.0, aspect:Number=1.0, nearp:Number = 1.0, farp:Number=1000.0):void
    {   var f:Number;   var i:int;
        for (i = 0; i < 16; i++) { vec[i] = 0.0;  } 
        f = 1.0 / Math.tan( (fovdeg * (3.1415 / 180.0)) * 0.5 );
        if (nearp == 0) { nearp = 0.0001; }
        if (farp == 0) { farp = 0.0001; }
        vec[0] = f / aspect;          vec[5] = f;
        vec[10] = (farp + nearp) / (nearp - farp);
        vec[14] = (2.0 * farp * nearp) / (nearp - farp);
        vec[11] = -1.0;          vec[15] = 0.0;
    }//projmatrix
    
     public static function setViewMat(vec:Vector.<Number>, 
        cx:Number, cy:Number, cz:Number,  qx:Number, qy:Number, qz:Number, qw:Number):void
        { var forwx:Number; var forwy:Number; var forwz:Number;
          var sidex:Number; var sidey:Number; var sidez:Number;
          var upx:Number;   var upy:Number;   var upz:Number;     
          var i:int; for(i=0;i<16;i++){vec[i]=0.0;}vec[0]=vec[5]=vec[10]=vec[15]=1.0;
          forwx=2.0*(qx*qz+qy*qw);forwy=2.0*(qy*qz-qx*qw);forwz=1.0-2.0*(qx*qx+qy*qy);
          upx=2.0*(qx*qy-qz*qw);upy=1.0-2.0*(qx*qx+qz*qz);upz=2.0*(qy*qz+qx*qw);
          sidex=1.0-2.0*(qy*qy+qz*qz);sidey=2.0*(qx*qy+qz*qw);sidez=2.0*(qx*qz-qy*qw);
          vec[0]=sidex;vec[4]=sidey;vec[8]=sidez;
          vec[1]=upx;vec[5]=upy;vec[9]=upz;
          vec[2]=forwx;vec[6]=forwy;vec[10]=forwz;
          vec[12]=(sidex*-cx)+(sidey*-cy)+(sidez*-cz);
          vec[13]=(upx*-cx)+(upy*-cy)+(upz*-cz);
          vec[14]=(forwx*-cx)+(forwy*-cy)+(forwz*-cz);
        }//setlookat

        //only works of 4x4 matrices
        public static function multMatrix(a:Vector.<Number>, b:Vector.<Number>, r:Vector.<Number>):void
        {   var i:int;  for (i = 0; i < 16; i += 4)
            {
                r[i] =     a[0] * b[i] + a[4] * b[i + 1] + a[8] * b[i + 2] + a[12] * b[i + 3];
                r[i + 1] = a[1] * b[i] + a[5] * b[i + 1] + a[9] * b[i + 2] + a[13] * b[i + 3];
                r[i + 2] = a[2] * b[i] + a[6] * b[i + 1] + a[10] * b[i + 2] + a[14] * b[i + 3];
                r[i + 3] = a[3] * b[i] + a[7] * b[i + 1] + a[11] * b[i + 2] + a[15] * b[i + 3];
            }//nexti
        }//multmat  

    }//classend
}



internal class xQuat
{
 public var x:Number = 0;        public var y:Number = 0;    
 public var z:Number = 0;        public var w:Number = 1;
 
  public function reset():void {    x = 0;  y = 0;  z = 0;  w = 1;   }

  public function normalise():void
  { var mag:Number;  mag = (x * x) + (y * y) + (z * z) + (w * w);
    if (mag == 1.0) return; //already normal
    if (mag == 0) { x = 0;  y = 0;  z = 0;  w = 1; return; }
    mag = 1.0 / Math.sqrt(mag);  x *= mag; y *= mag; z *= mag; w *= mag;
  }//norm
  
  public function mul(a:xQuat):void
  {
    var tx:Number; var ty:Number; var tz:Number; var tw:Number;
    tx = (w * a.x + x * a.w + y * a.z - z * a.y);   ty = (w * a.y + y * a.w + z * a.x - x * a.z);
    tz = (w * a.z + z * a.w + x * a.y - y * a.x);   tw = (w * a.w - x * a.x - y * a.y - z * a.z);
    x = tx;   y = ty;  z = tz;    w = tw;
  }//mul

  public function rotAxis(ang:Number, xyz:int=0):void //0 x  1 y  2 z
  { var ax:Number; var ay:Number; var az:Number; var aw:Number;
    var tx:Number; var ty:Number; var tz:Number; var tw:Number;
    ang *= 0.5;
    ax = xyz == 0? Math.sin(ang):0;   ay  = xyz == 1? Math.sin(ang):0;  
    az = xyz == 2? Math.sin(ang):0; aw = Math.cos(ang);
    tx = (w * ax + x * aw + y * az - z * ay);   ty = (w * ay + y * aw + z * ax - x * az);
    tz = (w * az + z * aw + x * ay - y * ax);   tw = (w * aw - x * ax - y * ay - z * az);
    x = tx;  y = ty;     z = tz;   w = tw;     
    normalise();        
  }//rotaxis
  
  public function rotPitch(ang:Number):void { rotAxis(ang, 0); }
  public function rotYaw(ang:Number):void { rotAxis(ang, 1); }
  public function rotRoll(ang:Number):void { rotAxis(ang, 2); }
  public function rotAxisX(ang:Number):void { rotAxis(ang, 0); }
  public function rotAxisY(ang:Number):void { rotAxis(ang, 1); }
  public function rotAxisZ(ang:Number):void { rotAxis(ang, 2); }
        
 public function setVec(vec:Vector.<Number>):void
  { var xx:Number= x * x;  var xy:Number= x * y; var xz:Number = x * z;  var xw:Number = x * w;
    var yy:Number= y * y;  var yz:Number= y * z; var yw:Number = y * w;
    var zz:Number= z * z;  var zw:Number= z * w;
    vec[3]  = vec[7] = vec[11] = vec[12] = vec[13] = vec[14] = 0.0; vec[15] = 1.0;
    vec[0]  = 1.0 - 2.0 * ( yy + zz ); vec[4]  =     2.0 * ( xy - zw );   vec[8]  =     2.0 * ( xz + yw );
    vec[1]  =  2.0 * ( xy + zw ) ;     vec[5]  = 1.0 - 2.0 * ( xx + zz ); vec[9]  =  2.0 * ( yz - xw ) ;
    vec[2]  =     2.0 * ( xz - yw );   vec[6]  =     2.0 * ( yz + xw );   vec[10] = 1.0 - 2.0 * ( xx + yy );       
 }//setvec
   
  //same as extracting the matrix, but more convenient
  public function getSideVx():Number      { return 1.0 - 2.0 * ( y * y + z * z ); }        
  public function getSideVy():Number      { return 2.0 * ( x * y + z * w ); }    
  public function getSideVz():Number      { return  2.0 * ( x * z - y * w ); }
  public function getUpVx():Number        { return 2.0 * ( x*y - z*w ); }
  public function getUpVy():Number        { return 1.0 - 2.0 * ( x*x + z*z ); }    
  public function getUpVz():Number        { return 2.0 * ( y*z + x*w ); }
  public function getFrontVx():Number     { return  2.0 * ( x*z + y*w ); }        
  public function getFrontVy():Number     { return  2.0 * ( y*z - x*w );     }        
  public function getFrontVz():Number     { return  1.0 - 2.0 * ( x*x + y*y );  }

 
}//xquat

