/**
 * Copyright dacyou ( http://wonderfl.net/user/dacyou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2GrL
 */

//※型などをかなり省いているため、Warningが大量に出てきます。

package {
import flash.display.Sprite
import flash.events.MouseEvent

[SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]
public class Main extends Sprite {
	const WIDTH = stage.stageWidth
	const HEIGHT = stage.stageHeight
	static var main :Main
	static const NUM_BALLS = 5, NUM_BLOCKS = 60
	static const BLOCK_WIDTH = 60, BLOCK_HEIGHT = 10, BLOCK_STRENGTH = 5
	static var numBalls, numBlocks
	static var blockWidth, blockHeight, blockStrength
	
	//=====================================================
	function Main() {
		main = this
		init()
	}
	
	//=====================================================
	function start( e = null ) {
		if ( e )
			stage.removeEventListener( MouseEvent.CLICK, init )
		Ball.start()
	}
	
	//-----------------------------------------------------
	function init( initialize = true ) {
		if ( initialize ){
			numBalls = NUM_BALLS
			numBlocks = NUM_BLOCKS
			blockWidth = BLOCK_WIDTH
			blockHeight = BLOCK_HEIGHT
			blockStrength = BLOCK_STRENGTH
		}
		else
			numBlocks += 100000
		
		Item.init( HEIGHT, this )
		addChild( Score.init( 100, 427 ) )
		addChildAt( Paddle.init( (WIDTH-Paddle.DEFAULT_WIDTH)/2, HEIGHT-50, stage ), 0 )
		initBlocks( numBlocks )
		initBalls( numBalls )
		stage.addEventListener( MouseEvent.CLICK, start )
	}
	
	//-----------------------------------------------------
	function initBlocks( num ) {
		var strength = blockStrength
		var w = blockWidth, h = blockHeight, xx = 0, yy = h
		var cols = int(WIDTH / w) -2
		var xoffset = (WIDTH - w * (cols + 2) ) / cols
		var yoffset = h/2
		
		var b :Block
		for ( var i = 0; i < num; i++ ){
			if ( 0 == (i%cols) ){
				xx = w
				yy += h + yoffset
				
				if ( yy + h > HEIGHT - 50 )
					strength = 1
				
				if ( yy + h > HEIGHT ){
					blockHeight *= 0.5
					if( blockHeight < 5 ){
						blockHeight = 5
						blockWidth *= 0.5
						if( blockWidth < 10 ){
							blockWidth = 10
							blockStrength += 5
						}
					}
					return
				}
			}
			addChildAt( b = new Block( w, h, strength ), 0 )
			
			b.x = xx
			b.y = yy
			xx += w + xoffset
		}		
	}
	//-----------------------------------------------------
	function initBalls( num ) {
		Ball.init( WIDTH, HEIGHT )
		
		var ball :Ball
		for ( var i = 0; i < num; i++ ) {
			addChildAt( ball = new Ball, 0 )
			ball.x = ( WIDTH - ball.width ) - ball.width * (num - i)
			ball.y = HEIGHT - 17
		}
	}
	
	//=====================================================
	static function _reset( initialize=true ) {
		Ball.reset()
		Block.reset()
		Score.reset(initialize)
		Item.reset()
		Paddle.reset()
	}
	
	public static function gameover() {
		_reset()
		main.init()
	}
	
	public static function gameclear() {
		numBalls = Ball.numBalls()
		_reset(false)
		main.init(false)
	}
}

}//end package

import flash.display.Sprite
import flash.events.Event
import flash.events.MouseEvent
import flash.filters.DropShadowFilter
import flash.filters.BevelFilter
import flash.text.TextField
import flash.text.TextFieldAutoSize
import flash.text.TextFormat

var bevel = new BevelFilter( 2, 30, 0xffffff, 1, 0x333333, 1, 5, 5 )
var dropShadow = new DropShadowFilter( 2, 30, 0x888888, 0.5 )

///////////////////////////////////////////////////////////////////////////////
class Score extends TextField {
	static var _score :Score
	static var _highScoreValue = 0
	var _value
	var _rate
	
	//=====================================================
	public static function init( x, y ) :Score {
		return _score || ( _score = new Score( x, y ) )
	}
	
	public static function reset( initialize=true ) {
		resetRate()
		if( initialize ){
			_score.parent.removeChild( _score )
			_score = null
		}
	}
	
	//=====================================================
	public static function resetRate(){
		_score._rate = 1
	}
	
	public static function add( value ) {
		_score._add( value )
	}
	
	function _add( value ){
		_value += value * _score._rate
		if ( _value > _highScoreValue )
			_highScoreValue = _value
		_display()
		_rate += 0.5
	}
	
	//=====================================================
	function _display() {
		text = _value + "\n" + _highScoreValue
	}
	
	//=====================================================
	function Score( x, y ) {
		var fmt :TextFormat = new TextFormat( "_sans", 18, 0xffffff )
		fmt.leading = -4
		
		autoSize = TextFieldAutoSize.RIGHT
		defaultTextFormat = fmt
		selectable = false
		
		this.x = x
		this.y = y
		_value = 0
		_rate = 1
		_display()
	}
}

///////////////////////////////////////////////////////////////////////////////
class Item extends Sprite {
	public static var list :Array = []
	static var _stageHeight
	static var _parent
	
	static const TYPE = [_addBall, _widePaddle, _slimPaddle, _throughBall ]
	static const COLOR = [0xaa0000, 0x00aa00, 0x0000aa, 0xaaaa00]
	
	var _vy
	var _type
	
	//=====================================================
	public static function init( height, parent ) {
		reset()
		_stageHeight = height
		_parent = parent
	}
	
	public static function create( x, y ) {
		if( Math.random() < 0.5 )
			list.push( new Item( x, y ) )
	}
	
	public static function reset() {
		for each( var item :Item in list ) {
			item._reset()
			item = null
		}
		list = []
	}
	
	function _reset() {
		removeEventListener( Event.ENTER_FRAME, _move )
		if ( parent )
			parent.removeChild( this )
	}
	
	//=====================================================
	static function _widePaddle( item ) {
		Paddle.paddle.changeWidth( 20, COLOR[item._type] )
	}
	
	static function _slimPaddle( item ) {
		Paddle.paddle.changeWidth( -20, COLOR[item._type] )
	}
	
	static function _addBall( item ) {
		var ball = _parent.addChild( new Ball( item.x, Paddle.paddle.y ) )
		Ball.start( ball )
	}
	
	static function _throughBall( item ) {
		Ball.throughMode( COLOR[item._type] )
	}
	
	//=====================================================
	function _checkPaddle() {
		if ( hitTestObject( Paddle.paddle ) ) {
			TYPE[_type]( this )
			_reset()
		}
	}
	
	//=====================================================
	function _move( e ) {
		y += _vy
		if ( y > _stageHeight )
			_reset()
		_checkPaddle()
	}
	
	//=====================================================
	function _draw( thickness=2, radius=10 ) {
		graphics.clear()
		graphics.beginFill( COLOR[_type], 0.5 )
		graphics.drawCircle( 0, 0, radius )
		graphics.lineStyle( thickness, COLOR[_type] )
		graphics.drawCircle( 0, 0, radius / 2 )
		filters = [bevel, dropShadow]
	}
	
	//=====================================================
	function Item( x, y ) {
		this.x = x
		this.y = y
		_vy = int(5 + Math.random() * 10)
		_type = int(Math.random()*TYPE.length)
		_parent.addChildAt( this, 0 )
		_draw()
		addEventListener( Event.ENTER_FRAME, _move )
	}
}

///////////////////////////////////////////////////////////////////////////////
class Paddle extends Sprite {
	public static var paddle :Paddle
	static const MAX_WIDTH = 200
	static const MIN_WIDTH = 20
	static const DEFAULT_WIDTH = 100
	static const DEFAULT_COLOR = 0xcccccc
	static var _stage
	
	//=====================================================
	public function get centerX(){ return x + width/2 }
	
	//=====================================================
	public static function init( x, y, stageObject ) {
		return paddle || ( paddle = new Paddle( x, y, stageObject ) )
	}
	
	public static function reset() {
		paddle._reset()
		paddle = null
	}
	function _reset() {
		_stage.removeEventListener( MouseEvent.MOUSE_MOVE, _move )
		parent.removeChild( this )
	}
	
	//=====================================================
	public function changeWidth( value, color ) {
		var w = width + value
		if ( w >= MAX_WIDTH )
			w = MAX_WIDTH - value
		else if ( w <= MIN_WIDTH )
			w = MIN_WIDTH - value
		else
			x -= value / 2
		
		_draw( w )
	}
	
	//=====================================================
	function _move( e :MouseEvent ) {
		x = e.stageX - width/2
	}
	
	//=====================================================
	function _draw( w=DEFAULT_WIDTH, color=DEFAULT_COLOR, h=12, e=16 ) {
		graphics.clear()
		graphics.beginFill( color )
		graphics.drawRoundRect( 0, 0, w, h, e )
		filters = [bevel, dropShadow]
	}
	
	//=====================================================
	function Paddle( x, y, stageObject ) {
		this.x = x
		this.y = y
		_stage = stageObject
		_stage.addEventListener( MouseEvent.MOUSE_MOVE, _move )
		_draw()
	}
}

///////////////////////////////////////////////////////////////////////////////
class Block extends Sprite {
	public static var list :Array = []
	static var _count = 0
	
	var _score
	var _strength
	var _color :GradientCellColor
	
	//=====================================================
	public static function reset() {
		for each( var b :Block in list ){
			b._reset()
			b = null
		}
		_count = 0
		list = []
	}
	function _reset() {
		parent.removeChild( this )
	}
	
	//=====================================================
	public function get right() { return x + width }
	public function get bottom() { return y + height }
	public function get centerX(){ return x + width/2 }
	public function get centerY(){ return y + height/2 }
	//-----------------------------------------------------
	public function get score(){ return _score }
	
	//=====================================================
	public function damage( value = 1 ) {
		if ( value < 1 )
			value = 1
		_strength -= value
		if ( _strength <= 0 ){
			visible = false
			if ( --_count <= 0 )
				Main.gameclear()
		}
		else
			_draw( _color.toBlack, width, height )
	}
	
	//=====================================================
	function _draw( color, w, h, e=6 ) {
		graphics.clear()
		graphics.beginFill( color )
		graphics.drawRoundRect( 0, 0, w, h, e  )
		filters = [bevel, dropShadow]
	}
	
	//=====================================================
	function Block( width, height, strength=1, score=100, color=0xcccccc ) {
		list.push( this )
		_count++
		_strength = strength
		_score = score
		_color = new GradientCellColor( _strength, color )
		_draw( _color.toBlack, width, height )
	}
}

///////////////////////////////////////////////////////////////////////////////
class Ball extends Sprite {
	public static var list :Array
	static var _stageWidth, _stageHeight
	static var numDrop, numMove
	
	var _color
	var _radius
	var _vx, _vy
	var _collisions = {}
	var _through
	
	//=====================================================
	public static function init( w, h ) {
		_stageWidth = w
		_stageHeight = h
		reset()
	}
	
	public static function reset() {
		for each( var b :Ball in list ){
			b._reset()
			b = null
		}
		list = []
		numDrop = numMove = 0
	}
	
	function _reset() {
		numDrop++
		numMove--
		visible = false
		removeEventListener( Event.ENTER_FRAME, _move )
		if ( parent )
			parent.removeChild( this )
	}
	
	public static function start( ball = null ) {
		if ( ball ){
			ball._start()
			return
		}
		if ( numMove > 0 )
			return
		
		for ( var i = 0; i < list.length; i++ ) {
			if ( list[i].visible ) {
				list[i]._start()
				return
			}
		}
		
		Main.gameover()
	}
	
	function _start() {
		_vx = 0
		_vy = 10
		if ( 0 == numMove ) {
			if ( Paddle.paddle.centerX < _stageWidth / 2 )
				x = 0
			else
				x = _stageWidth
			y = 0
		}
		addEventListener( Event.ENTER_FRAME, _move )
		numMove++
	}
	
	static function numBalls() {
		return list.length - numMove - numDrop + 1
	}
	
	static function throughMode( color ) {
		for each( var ball :Ball in list ) {
			if ( ball._vy ){
				ball._through = true
				ball._draw( color )
			}
		}
	}
	
	//=====================================================
	function _checkCollision( s :Sprite ) {
		if ( ! s.visible )
			return false
		
		if ( ! hitTestObject( s ) ) {
			if ( s == _collisions[s.name] )
				_collisions[s.name] = null
			return false
		}
		
		if ( s == _collisions[s.name] )
			return false
		
		_collisions[s.name] = s
		return true
	}
	
	//=====================================================
	function _checkPaddle() {
		var paddle :Paddle = Paddle.paddle
		if ( ! _checkCollision( paddle ) )
			return
		
		_vx = ( x - ( paddle.x + paddle.width/2 ) ) * 0.2
		_vy = -Math.abs(_vy)
		
		if ( _through ){
			_through = false
			_draw()
		}
		
		Score.resetRate()
	}
	
	//=====================================================
	function _checkBlock() {
		for each( var block :Block in Block.list ){
			if ( !_checkCollision( block ) )
				continue
			
			block.damage( Math.abs(_vx) )
			if( ! block.visible ){
				_collisions[block.name] = null
				Item.create( block.centerX, block.centerY )
				Score.add( block.score )
				if ( _through )
					continue
			}
			
			
			if ( y < block.centerY )
				_vy = -Math.abs(_vy)
			else
				_vy = Math.abs(_vy)
			
			if ( x < block.x )
				_vx = -Math.abs(_vx)
			else if( block.right < x )
				_vx = Math.abs(_vx)
		}
	}
	
	//=====================================================
	function _checkWall( left, top, right, bottom ) {
		if ( x - _radius < left ) {
			x = left + _radius
			_vx *= -1
		}
		else if ( right < x + _radius ){
			x = right - _radius
			_vx *= -1
		}
		
		if ( y - _radius < top ) {
			y = top + _radius
			_vy *= -1
		}
		else if ( bottom < y + _radius){
			_reset()
			start()
		}		
	}
	
	//=====================================================
	function _move( e=null ) {
		x += _vx
		y += _vy
		
		_checkWall( 0, 0, _stageWidth, _stageHeight )
		_checkBlock()
		_checkPaddle()
	}
	
	//=====================================================
	function _draw( color=0xff0000 ) {
		graphics.clear()
		graphics.beginFill( color )
		graphics.drawCircle( 0, 0, _radius )
		filters = [bevel, dropShadow]
	}
	
	//=====================================================
	function Ball( x=0, y=0, color=0xff0000, radius=6 ) {
		list.push( this )
		this.x = x
		this.y = y
		_radius = radius
		_through = false
		_draw( color )
	}
}

///////////////////////////////////////////////////////////////////////////////
class GradientCellColor {
	var r, g, b
	var len, p
	
	function GradientCellColor( length, color ) {
		r = color >> 16 & 0xff
		g = color >> 8 & 0xff
		b = color & 0xff
		len = length
		p = 0
	}
	
	public function get toBlack() {
		var c = r*(len-p)/len << 16 | g*(len-p)/len << 8 | b*(len-p)/len
		p++
		return c
	}
}
