/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2GgD
 */

// forked from Aksor.Al's Sound Visualizer
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.media.*;
    import flash.net.*;
    import flash.utils.*;
    import flash.geom.*;
    
    import caurina.transitions.Tweener;
    
    import org.papervision3d.core.proto.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.core.render.filter.*;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    
    [SWF(width = "720", height = "480", frameRate = "60", backgroundColor="0")]

    public class Main extends BasicView
    {    
        static private const W_SEGMENT    :uint = 6;
        static private const H_SEGMENT    :uint = 12;
        
        private var soundChannel        :SoundChannel;
        private var sphere              :DisplayObject3D;
        private var rotY                :Number = 0;
        private var rotZ                :Number = 0;
        private var circles             :Array = [];
        private var modeFlag            :Boolean = false;
        public var  bfx                 :BitmapEffectLayer;
        
        static private var _instance    :Main;
        static public function get instance():Main { return _instance; }
        
        public function Main()
        {
            _instance = this;
            super(0, 0, true, false, CameraType.TARGET);
            stage.quality = StageQuality.MEDIUM;
            
            // create the effect layer
            bfx = new BitmapEffectLayer(viewport, 720, 480, true, 0, BitmapClearMode.CLEAR_PRE);
            bfx.addEffect(new BitmapLayerEffect( new BlurFilter(8, 8, 1)));
            bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 1, 0.65), BlendMode.ADD);
            bfx.clippingPoint = new Point(0, -2);
            bfx.drawLayer.blendMode = BlendMode.OVERLAY;
            viewport.containerSprite.addLayer(bfx);
            
            // create main sphere
            sphere = scene.addChild(new DisplayObject3D());
            
            // create sphere particle
            for (var i:int = 0; i < W_SEGMENT * H_SEGMENT; i++)
            {
                var rX:Number = (i % H_SEGMENT);
                var rY:Number = (i / H_SEGMENT >> 0);
                
                var circle:DisplayObject3D = sphere.addChild(new Circle());
                circle.rotationY = rX * (360 / H_SEGMENT);
                circle.rotationZ = rY * (180 / W_SEGMENT);
                
                circles.push(circle);
            }
            
            // load music
            var sound:Sound = new Sound(new URLRequest("http://scfire-dtc-aa03.stream.aol.com:80/stream/1035"));
            soundChannel = sound.play();
            
            // set loop method
            var timer:Timer = new Timer(3000);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
            
            // render
            startRendering()
        }
        
        /**
         * loop
         */
        override protected function onRenderTick(e:Event = null):void
        {
            var volume:Number = (soundChannel.leftPeak + soundChannel.rightPeak) / 2;
            
            // size move
            sphere.z = Math.min(1500 - volume * 3000, sphere.z + 25);
            
            // rotation move
            rotZ += (soundChannel.leftPeak - 0.2) * 0.6;
            rotZ *= 0.98;
            rotY += (soundChannel.rightPeak - 0.1) * 0.4;
            rotY *= 0.96;
            
            sphere.rotationY += rotY;
            sphere.rotationX += (rotZ + rotY) * 0.3;
            
            // move width or height
            sphere.x += (soundChannel.leftPeak * 100 - 50 - sphere.x) * .1;
            sphere.y += (soundChannel.rightPeak * 100 - 50 - sphere.y) * .1;
            
            super.onRenderTick(e);
        }
        
        /**
         * loop method
         */
        private function loop(e:TimerEvent):void 
        {
            var i:int
            if (modeFlag)
            {
                for (i = 0; i < circles.length; i++ )
                {
                    Tweener.addTween(circles[i],
                    {
                        rotationY    : i / (W_SEGMENT * H_SEGMENT) * 720 - 360,
                        rotationZ    : i / (W_SEGMENT * H_SEGMENT) * 180,
                        time        : 2,
                        transition    : "easeInOutQuad"
                    });
                }
            }
            else
            {
                for (i = 0; i < circles.length; i++ )
                {
                    var rX:Number = (i % H_SEGMENT);
                    var rY:Number = (i / H_SEGMENT >> 0);
                    
                    Tweener.addTween(circles[i],
                    {
                        rotationY    : rX * (360 / H_SEGMENT),
                        rotationZ    : rY * (180 / W_SEGMENT),
                        time        : 2,
                        transition    : "easeInOutQuad"
                    })
                }
            }
            modeFlag = !modeFlag;
        }
    }
}


//------------------------------------------------------
// Circle Class
//------------------------------------------------------
import flash.display.*;
import org.papervision3d.objects.*;
import org.papervision3d.objects.primitives.*;
import org.papervision3d.materials.*;

class Circle extends DisplayObject3D
{    
    private var dot1    :DisplayObject3D;
    private var dot2    :DisplayObject3D;
    private var dotE    :DisplayObject3D;
    private var line1    :DisplayObject3D;
    
    public function Circle():void
    {
        // Main Dot
        var s1:Sprite = new Sprite();
        s1.graphics.beginFill(0x0099EE, 1);
        s1.graphics.drawCircle(0, 0, 50);
        s1.graphics.endFill();
        s1.graphics.beginFill(0x002244, 1);
        s1.graphics.drawCircle(0, 0, 30);
        
        var s1Mat:MovieMaterial = new MovieMaterial(s1, true);
        s1Mat.doubleSided = true;
        
        dot1 = addChild(new Plane(s1Mat, 20, 20));
        dot1.z = 200
        
        // Satellite Dot
        var s2:Sprite = new Sprite();
        s2.graphics.beginFill(0x0099EE, 1);
        s2.graphics.drawCircle(0, 0, 20);
        
        var s2Mat:MovieMaterial = new MovieMaterial(s2, true);
        s2Mat.doubleSided = true;
        
        dot2 = addChild(new Plane(s2Mat, 10, 10));
        dot2.z = 300
        
        dotE = addChild(new Plane(s2Mat, 10, 10));
        dotE.z = 300
        
        // Main line
        var l1Mat:ColorMaterial = new ColorMaterial(0x2299CC);
        l1Mat.doubleSided = true;
        line1 = addChild(new Plane(l1Mat, 100, 1));
        line1.z = 250
        line1.rotationX = line1.rotationY = 90;
        
        // add Effect
        Main.instance.bfx.addDisplayObject3D(dotE);
    }
}