/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2GDR
 */

//とりあえず一番簡単なやつ
package 
{
    
    /**
     * 
     * @author umhr
     */
     
    import flash.display.*
    import flash.events.*
    import flash.text.*
    import flash.utils.*
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
    
    public class Basic3D extends Sprite {
		
		private var originPoz:Array = new Array([60,70,0],[-30,40,0],[-100,-120,0],[100,20,0]);
		private var stage_sp:Sprite = new Sprite();
        private var _count:int;
		
        public function Basic3D() { 
			stage_sp.x = stage_sp.y = 465/2;
			this.addChild(stage_sp);
			setFpsCounter(stage);
			this.addEventListener(Event.ENTER_FRAME,main); 
        }
		private function main(e:Event):void{
			var _poz:Array = arrayClone(originPoz);
			_count ++;
			affine(_poz,[0,0,0,0,_count/20,0])
			perspective(_poz);
			drawFill(_poz);
		}
		
		
		//アフィン変換
		private function affine(__poz:Array,__view:Array):void {
			var n_cx:Number = Math.cos(__view[int(3)]);
			var n_sx:Number = Math.sin(__view[int(3)]);
			var n_cy:Number = Math.cos(__view[int(4)]);
			var n_sy:Number = Math.sin(__view[int(4)]);
			var n_cz:Number = Math.cos(__view[int(5)]);
			var n_sz:Number = Math.sin(__view[int(5)]);
			var d_x:Number = __view[int(0)];
			var d_y:Number = __view[int(1)];
			var d_z:Number = __view[int(2)];
			var af_xx:Number = n_cz*n_cy+n_sx*n_sy*n_sz;
			var af_xy:Number = n_sx*n_sy*n_cz-n_sz*n_cy;
			var af_xz:Number = n_sy*n_cx;
			var af_yx:Number = n_cx*n_sz;
			var af_yy:Number = n_cx*n_cz;
			var af_yz:Number = -n_sx;
			var af_zx:Number = n_cy*n_sx*n_sz-n_sy*n_cz;
			var af_zy:Number = n_sy*n_sz+n_cy*n_sx*n_cz;
			var af_zz:Number = n_cx*n_cy;
			
			var _len:uint = new uint(__poz.length);
			for (var i:uint = 0; i<_len; i++) {
				var af_x:Number = __poz[i][int(0)];
				var af_y:Number = __poz[i][int(1)];
				var af_z:Number = __poz[i][int(2)];
				__poz[i][uint(0)] = af_x*af_xx+af_y*af_xy+af_z*af_xz+d_x;
				__poz[i][uint(1)] = af_x*af_yx+af_y*af_yy+af_z*af_yz+d_y;
				__poz[i][uint(2)] = af_x*af_zx+af_y*af_zy+af_z*af_zz+d_z;
			}
		}
		
		
		//パースペクティブ
		private function perspective(__poz:Array):void{
			var _len:int = __poz.length;
			for (var i:int = 0; i<_len; i++) {
				var _per:Number = 300/(300+__poz[i][2]);
				__poz[i] = [__poz[i][0] * _per,__poz[i][1] * _per,_per];				
			}
		}
		//面を描く
		private function drawFill(__poz:Array):void{
			stage_sp.graphics.clear();
			var g:Graphics = stage_sp.graphics;
			g.lineStyle (1, 0x000000, 1.0);	// 線のスタイル指定
			g.beginFill (0xFF0000, 1.0);	// 面のスタイル設定
			var _len:int = __poz.length;
			g.moveTo (__poz[_len-1][0], __poz[_len-1][1]);
			for (var i:int = 0; i<_len; i++) {
				g.lineTo (__poz[i][0], __poz[i][1]);
			}
			g.endFill();			
		}
		//arrayの複製。再起処理を行っている。
		private function arrayClone(ar:Array):Array {
			var _array:Array = new Array();
			var _len:int = ar.length;
			for (var i:int = 0; i<_len; i++) {
				_array[i]=(ar[i] is Array)?arrayClone(ar[i]):ar[i];
			}
			return _array;
		}
		//FPSを表示
		private function setFpsCounter(_stage:Object):Sprite{
			var stageFPS:int = _stage.frameRate; 
			var _sp:Sprite = new Sprite();
			_stage.addChild(_sp);

			var _tf:TextField = new TextField();
			var count:int = 1;
			var oldTimer:uint = getTimer(); 
			_sp.addChild(_tf); 
			_sp.addEventListener(Event.ENTER_FRAME,fpsCounter); 
			function fpsCounter(e:Event):void{
				if (count < stageFPS) { 
					count ++; 
				} else { 
					_tf.text = "fps"+stageFPS*1000/(getTimer()-oldTimer); 
					oldTimer = getTimer(); 
					count = 1; 
				} 
			}
			return _sp;
		}
    }
}