/**
 * Copyright asou_jp ( http://wonderfl.net/user/asou_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2FxE
 */

// forked from asou_jp's forked from: 検証用
// forked from asou_jp's 検証用
// 検証ひな形
package {

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.events.Event;

    public class FlashTest extends Sprite
    {
        
        private const _WIDTH:uint = 465;
        
        public function FlashTest() {
            
            // ベースの表示オブジェクトを作成
            var bmd:BitmapData = new BitmapData(100,50,false, 0xFF0000);
            var bmp:Bitmap = new Bitmap(bmd);
            bmp.x = 0;
            bmp.y = 20;
            bmp.rotation = 80;
            addChild(bmp);
            
            // ミラーを作成
            var mirror:Bitmap = _createMirror(bmp);
            addChild(mirror);
            
            // 表示領域を矩形で表示
            graphics.lineStyle(1,0);    
            var rect:Rectangle = bmp.getRect(this);
            graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            rect = mirror.getRect(this);
            graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
            
            addEventListener(Event.ENTER_FRAME, function (event:Event):void {
                
                bmp.rotation++;
               
               bmp.x = mouseX;
               bmp.y = mouseY;
                
                _updateMirror(bmp, mirror);
                
                // 表示領域を矩形で表示
                graphics.clear();
                graphics.lineStyle(1,0);    
                var rect:Rectangle = bmp.getRect(this);
                graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
                rect = mirror.getRect(this);
                graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
                
            });
        }
        
        
       /**
        * 左右対称のミラーを作成
        */
       private function _createMirror(bmp:Bitmap):Bitmap
       {
            var mirror:Bitmap = new Bitmap(new BitmapData(bmp.bitmapData.width, bmp.bitmapData.height, false, 0x0000FF));
            _updateMirror(bmp, mirror);
            return mirror;
       }

        
       /**
        * 左右対称のミラーを作成
        */
       private function _updateMirror(a:Bitmap, b:Bitmap):void
       {
            var rect:Rectangle = a.getRect(a.parent);
            var mtx:Matrix = a.transform.matrix.clone();
            mtx.translate(-rect.x, 0);
            mtx.scale(-1, 1);
            mtx.translate(_WIDTH - rect.x, 0);
            b.transform.matrix = mtx;
       }
       
        
    }
}