/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Fuy
 */

package {
    //----------------------------------------------
    //MandelbrotTravelGuide
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    //import cls.*;

    public class MandelbrotTravelGuide extends Sprite {
        public var cWinMap:clsWin = null;
        public var iniWin:int;
        
        
        //それなりの画像が出来る位置（中心）と幅（d*2）
        public var arrItiData:Array = new Array(
            {x:0.155906549252234,y:1.02715992806419,d:1.0820761114139E-05, win:null, c0:0xff0000, c1:0xffffff, mes:"薔薇"},
            {x:-0.441272890834338,y:-0.374451146444973,d:7.98505343180356E-05, win:null, c0:0xff0000, c1:0xffffff, mes:"燃える木"},
            {x:-0.351189420961287,y:-0.58295837430011,d:0.000990314640291726,win:null, c0:0x008800, c1:0x88ff88, mes:"羊歯の森"},
            {x:1.193668671488,y:-0.289648963584,d:1.28E-06, win:null, c0:0x0000ff, c1:0xff0000, mes:"地獄の業火"},
            {x:1.259851907216, y: -0.0399094923520003, d:2.42999999999494E-05, win:null, c0:0xffffff, c1:0x804000, mes:"巻貝" },
            {x:0.249014916192047,y:-0.714960704886991,d:4.84113236924663E-08,win:null,c0:0x880000,c1:0xffffff,mes:"ロープの芸術"},
            {x:1.2929852,y:0.4395768,d:0.0012,win:null,c0:0x0000ff,c1:0xff0000,mes:"雷鳴"},
            {x:-0.39579681849326,y:0.31866501079837,d:6.07424686647389E-06,win:null,c0:0xff0000,c1:0xffffff,mes:"九尾の狐"},
            {x:1.52161025388102, y: 0.000166272866551647, d:0.25E-07 ,win:null,c0:0x0000ff,c1:0x00ff00,mes:"タツノオトシゴ"},
            {x:0.881134907383808,y:0.22324694654976,d:5.7344E-09,win:null,c0:0xffffff,c1:0x0000ff,mes:"バネで固定"},
            {x: -0.2963045325540046, y: -0.01716809438166771, d:0.00025785045609620774 ,win:null,c0:0x0000ff,c1:0xffffff,mes:"渦"},
            {x:1.749022688597665, y:0.00038058308629588617, d:0.000027640967391429732 ,win:null,c0:0x0000ff,c1:0x00ff00,mes:"青葉"}
        );

        
        
        public function MandelbrotTravelGuide() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //下の2行を加えるとHTMLで定義したサイズで表示
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            addChild(new clsText("<<MANDELBROT TRAVEL GUIDE>>", 5, 5, 210, 20, true));
            addChild(new clsButton("btnMAP","MAP" ,    220, 5, 40, 20 ,fncMap));
            cWinMap = new clsWin("WIN-map", "MANDELBROT TRAVEL GUIDE MAP", 10, 30, 310, 330);
            addChild(cWinMap);
            cWinMap.Add(5, 5, new clsMandelbrot("mMAP", 0, 0, 300, 300, 
                    0.5, 0.0, 1.4, 0x0000ff, 0xffffff ));
            for (var i:int = 0; i < arrItiData.length; i++) {
                var xm:int = 150+(arrItiData[i].x-0.5)*150/1.4;
                var ym:int = 150+arrItiData[i].y*150/1.4;
                cWinMap.Add(5, 5, new clsToolTipMark("MK-" + i,
                    xm,ym,4,arrItiData[i].mes,0xff0000,fncTip));
            }
            iniWin = 10;
        }
        private function fncMap(btn:clsButton):void {
            cWinMap.MoveTop();
        }
        private function fncTip(tip:clsToolTipMark):void {
            var nam:String = tip.name;
            var no:int = int(nam.substr(3));
            if (arrItiData[no].win == null) {
                iniWin += 20;
                if (iniWin + 310 > root.stage.stageWidth) { iniWin = 30;}
                if (iniWin + 20+ 330 > root.stage.stageHeight) { iniWin = 30;}
                
                var cWin:clsWin=new clsWin("WIN-"+no, arrItiData[no].mes, iniWin, iniWin+20, 310, 330,fncCloseWin);
                addChild(cWin);
                cWin.Add(5, 5, new clsMandelbrot("mMAP-"+no, 0, 0, 300, 300, 
                    arrItiData[no].x, arrItiData[no].y, arrItiData[no].d,
                    arrItiData[no].c0, arrItiData[no].c1 ));
                arrItiData[no].win = cWin;
            } else {
                arrItiData[no].win.MoveTop();
            }
        }
        private function fncCloseWin(win:clsWin):void {
            var i:int = int(win.name.substr(4));
            arrItiData[i].win = null;
        }
    }
}
//================================================
//package cls {
    //----------------------------------------------
    //ウインドクラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;

    //public class clsWin extends Sprite {
    class clsWin extends Sprite {
        private var spMain:Sprite;
        private var strTitl:String;
        private var intX0:int;
        private var intY0:int;
        private var intW:int;
        private var intH:int;
        private var blModalFlg:Boolean = false;
        private var fncCls:Function
        private var tfTitle:TextField;
        private var tfClose:TextField;
        private var spBody:Sprite;
        
        private var blMouseFlg:Boolean = false;
        private var intMouseX:int;
        private var intMouseY:int;
        //ウインドクラス
        //　nam:名称
        // titl:タイトル
        // x0,y0:表示位置
        // w,h:幅･高さ
        // cls:終了時、コールされる関数
        // mFlg:モーダルウインド(=true)/モードレスウインド(=false)
        public function clsWin(nam:String, titl:String, x0:int, y0:int, w:int, h:int, 
                    cls:Function = null,mFlg:Boolean=false) {
            strTitl=" "+titl;
            intX0=x0;
            intY0=y0;
            intW=w;
            intH=h;
            fncCls = cls;
            blModalFlg = mFlg;
            name = nam;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            if(blModalFlg==true) {    //モーダルウインド
                var spBack:Sprite=new Sprite();
                spBack.graphics.beginFill(0xffffff,0.5);
                spBack.graphics.lineStyle(1,0xffffff,0.5);
                spBack.graphics.drawRect(0, 0,  root.stage.stageWidth, root.stage.stageHeight);
                addChild(spBack);
            }
            spMain=new Sprite();
            addChild(spMain);
            if(fncCls!=null) {
                tfClose = fncText("X", intW-15, 0, 15);
                spMain.addChild(tfClose);
                tfClose.addEventListener(MouseEvent.CLICK,onClose);
                tfTitle = fncText(strTitl, 0, 0, intW-15,0xbbbbbb);
            } else {
                tfTitle = fncText(strTitl, 0, 0, intW,0xbbbbbb);
            }
            spMain.addChild(tfTitle);
            //MOUSE_DOWN以外はstageを付ける
            tfTitle.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            tfTitle.stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            tfTitle.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
            spBody = new Sprite();
            spBody.graphics.beginFill(0xffffff);
            spBody.graphics.lineStyle(1,0x00000);
            spBody.graphics.drawRect(0, 0, intW, intH - 20);
            spMain.addChild(spBody);
            spBody.y = 20;
            fncChkXY(intX0, intY0);
            spBody.addEventListener(MouseEvent.MOUSE_DOWN,onDownBody);
        }
        //固定文字文字列表示関数
        // sText:表示文字列
        // nSiz:文字サイズ
        // nx,ny:文字位置
        // uic:カラー
        // 戻り値:作成TextField    
        private function fncText(sText:String , nx:int,ny:int,w:int,ucol:uint=0xffffff):TextField {
            var tf:TextField = new TextField();
            tf.text = sText;
            tf.x = nx;
            tf.y = ny;
            tf.selectable = false;
            tf.border = true;
            tf.background = true;
            tf.backgroundColor = ucol;
            tf.width = w;
            tf.height = 20;
            return tf;
        }
        //重ねあわせを最前列にする
        public function MoveTop():void {
            parent.setChildIndex(this, parent.numChildren - 1);
        }
        //ウインドのドラッグ処理
        private function onClose(e:MouseEvent):void {
            parent.removeChild(this);
            if(fncCls!=null){fncCls(this);}
        }
        private function onDown(e:MouseEvent):void {
            MoveTop();
            blMouseFlg = true;
            intMouseX=parent.mouseX;
            intMouseY=parent.mouseY;
        }
        private function onDownBody(e:MouseEvent):void {
            MoveTop();
        }
        private function onMove(e:MouseEvent):void {
            if(e.buttonDown==false) {blMouseFlg = false;}
            if (blMouseFlg == true) {
                var x1:int = parent.mouseX;
                var y1:int = parent.mouseY;
                var x2:int=spMain.x + x1 - intMouseX ;
                var y2:int=spMain.y + y1 - intMouseY ;
                fncChkXY(x2,y2);
                intMouseX=x1;
                intMouseY = y1;
            }
        }
        private function onUp(e:MouseEvent):void {
            blMouseFlg = false;
        }
        //ウインドを領域の外に出さない
        private function fncChkXY(x1:int,y1:int):void {
            if (x1 > root.stage.stageWidth - intW-1) { x1 = root.stage.stageWidth - intW-1; }
            if (y1 > root.stage.stageHeight - intH-1) { y1 = root.stage.stageHeight - intH-1; }
            if (x1 < 0) { x1 = 0; }
            if (y1 < 0) { y1 = 0; }
            spMain.x=x1;
            spMain.y=y1;
        }
        //ウインド上にオブジェクトを配置する
        // x1,y1:位置
        // obj:オブジェクト
        public  function Add(x1:int, y1:int, obj:DisplayObject):void {
            spBody.addChild(obj);
            obj.x = x1;
            obj.y = y1;
        }
    }
//}
//===================================
//package cls {
    //----------------------------------------------
    //ツールチップつきマーク
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.geom.Point;

    //public class clsToolTipMark extends Sprite {
    class clsToolTipMark extends Sprite {
        public var strTip:String;
        public var intX0:int;
        public var intY0:int;
        public var intR:int;
        public var uinCol:uint;
        public var fncClick:Function;
        public var tfTip:TextField;
        
        //ツールチップつきマーククラス
        //　nam:名称
        // x0,y0:表示位置
        // r:マーク半径
        // sTip:ツールチップ文字列
        // uCol:マークのカラー
        // fClick:クリックしたときコールされる関数
        public function clsToolTipMark(nam:String,  x0:int, y0:int, r:int
                    ,sTip:String, uCol:uint=0xff0000,fClick:Function = null) {
            name = nam;
            strTip=sTip;
            intX0=x0;
            intY0=y0;
            intR=r;
            uinCol=uCol;
            fncClick=fClick;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // 円を描く (中を塗りつぶす)
            graphics.lineStyle(1, uinCol);
            graphics.beginFill(uinCol);
            graphics.drawCircle(intX0, intY0, intR);
            graphics.endFill();
            tfTip = fncText(strTip, intX0, intY0);
            addChild(tfTip);
            
            tfTip.visible = false;
            this.addEventListener(MouseEvent.CLICK, onClick);
            this.addEventListener(MouseEvent.MOUSE_OVER,onOver);
            this.addEventListener(MouseEvent.MOUSE_OUT,onOut);
        }
        // 固定文字文字列表示関数
        // sText:表示文字列
        //  nx,ny:文字位置
        //  戻り値:作成TextField
        private function fncText(sText:String , nx:int, ny:int):TextField {
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = sText;
            tf.x = nx+5;
            tf.y = ny+5;
            tf.selectable = false;
            tf.border = true;
            tf.borderColor = 0xbbbbbb;
            tf.background = true;
            tf.backgroundColor = 0xdddddd;
            return tf;
        }
        //クリック時
        private function onClick(e:MouseEvent):void {
            if(fncClick!=null){fncClick(this);}
        }
        // ツールチップの表示
        private function onOver(e:MouseEvent):void {
            var l_pos : Point = new Point(intX0,intY0);
            var g_pos : Point = this.localToGlobal(l_pos);
            var intX:int = g_pos.x;
            var intY:int = g_pos.y;
            
            //一番前に表示
            parent.setChildIndex(this, parent.numChildren - 1);
            //ツールチップを領域外にならないように表示
            if (intX + intR + 5 + tfTip.width > root.stage.stageWidth) {
                intX = intX - intR - 5 - tfTip.width;
            } else {
                intX = intX + intR + 5;
            }
            if (intY + intR + 5 + tfTip.height > root.stage.stageHeight) {
                intY = intY - intR - 5 - tfTip.height; 
            } else {
                intY = intY + intR + 5; 
            }
            g_pos.x = intX;
            g_pos.y = intY;
            l_pos = this.globalToLocal(g_pos);
            tfTip.x = l_pos.x;
            tfTip.y = l_pos.y;
            
            tfTip.visible = true;
            
        }
        private function onOut(e:MouseEvent):void {
            tfTip.visible = false;
        }
    }
//}
//==============================================================
//package cls {
    //----------------------------------------------
    //Mandelbrotクラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    //public class clsMandelbrot extends Sprite {
    class clsMandelbrot extends Sprite {
        public var ix0:int;
        public var iy0:int;
        public var iw:int;
        public var ih:int;
        public var nmx0:Number;
        public var nmy0:Number;
        public var nmd:Number;
        public var uc0:uint;
        public var uc1:uint;
        //最大繰り返し数
        private    var intKurikaesi:int;
        //カラー
        private var arrColor:Array;
        private var uintHassan:uint;//発散しないときのカラー

        public function clsMandelbrot(nam:String, x0:int, y0:int, w:int, h:int, 
                    mx0:Number, my0:Number, md:Number, c0:uint, c1:uint ) {
            name = nam;
            ix0 = x0;
            iy0 = y0;
            iw = w;
            ih = h;
            nmx0 = mx0;
            nmy0 = my0;
            nmd = md;
            uc0 = c0;
            uc1 = c1;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            this.x = ix0;
            this.y = iy0;
            fncDispHani();
        }
        public function reDisp(  w:int, h:int, 
                    mx0:Number, my0:Number, md:Number, c0:uint, c1:uint ):void {
            iw = w;
            ih = h;
            nmx0 = mx0;
            nmy0 = my0;
            nmd = md;
            uc0 = c0;
            uc1 = c1;
            fncDispHani();
        }
        private function fncDispHani():void {
            fncSerColor(uc0, uc1);
            while (this.numChildren) this.removeChildAt(0);
            var bdHani:BitmapData = new BitmapData(iw, ih, false, 0xffffff);
            var bm:Bitmap = new Bitmap(bdHani);
            this.addChild(bm);
            var id:int = iw/2;
            if (iw < ih) { id = ih/2; }
            var nStep:Number = nmd/id;
            var nXMin:Number = nmx0 - nStep*iw/2;
            var nYMin:Number = nmy0 - nStep*ih/2;

            for (var iy:int = 0; iy < ih;iy++) {
                var b:Number = nYMin + iy * nStep;
                for (var ix:int = 0; ix < iw; ix++) {
                    var a:Number = nXMin + ix * nStep;
                    bdHani.setPixel(ix, iy, fncGetColor(a, -b));
                }
            }
        }

        //グラデーションカラー取得
        private function fncSerColor(c0:uint, c1:uint):void {
            arrColor = new Array();
            //最大繰返数
            intKurikaesi=256;
            uintHassan = 0x000000;
            //カラーのセット
            var icol0:uint = c0;
            var ir0:uint = icol0 / (256 * 256);    //カラーをRGBに分解
            var ig0:uint = (icol0 / (256))-ir0*256;
            var ib0:uint = icol0 % 256;
            var icol1:uint = c1;
            var ir1:uint = icol1 / (256 * 256);    //カラーをRGBに分解
            var ig1:uint = (icol1 / (256))-ir1*256;
            var ib1:uint = icol1 % 256;
            var icoln:int = 32;    //intKurikaesi;
            var i:int;
            var ir:uint;
            var ig:uint;
            var ib:uint;
            for(i = 0; i < icoln; i++) {    //グラデーションカラー作成
                ir = ir0 + (ir1 - ir0) * i / icoln;
                ig = ig0 + (ig1 - ig0) * i / icoln;
                ib = ib0 + (ib1 - ib0) * i / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
            for(i = 1; i < icoln-1; i++) {    //グラデーションカラー作成
                ir = ir0 + (ir1 - ir0) * (icoln-i) / icoln;
                ig = ig0 + (ig1 - ig0) * (icoln-i) / icoln;
                ib = ib0 + (ib1 - ib0) * (icoln-i) / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
        }
        //マンデルブロ集合の1点でのカラー
        private function fncGetColor(a:Number, b:Number):uint {
            var uiCol:uint = uintHassan;    //発散しないときのカラー
            var x:Number=0;
            var y:Number=0;
            var i:int = 0;
            for(i=0;i<=intKurikaesi;i++){    //最大繰り返し数繰り返し
                var x2:Number=x*x;
                var y2:Number=y*y;
                var zx:Number=x2-y2-a;
                var zy:Number=2*x*y-b;
                x=zx;
                y=zy;
                if (x2 + y2 >= 4) {
                    var id:int = i % arrColor.length;
                    uiCol= arrColor[id];
                    break;
                }
            }
            return uiCol;
        }
    }
//}
//===================================
//package cls {
    //----------------------------------------------
    //ボタンクラス:TextFieldをボタンのように使う
    //   長押し(LongPress)の対応
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.MouseCursor;
    import flash.ui.Mouse;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.getTimer;
    
//    public class  clsButton extends TextField {
    class  clsButton extends TextField {
        private var tfFormat:TextFormat;
        private var fncChkFnc:Function;
        private var fncLongPress:Function;
        private var intTim:int;
        
        //ボタンクラス:TextFieldをボタンのように使う
        // nam:ボタンの名称（ボタンを区別するために使用）
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:ボタンのサイズ
        // fChk:クリックしたときの関数「fChk(b:clsButton):void」
        // fLongPress:ボタンの長押ししたときの関数「fLongPress(b:clsButton):void」
        // bItalic：ボタンの文字をItalicにするか？
        public function clsButton(nam:String,sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number , fChk:Function=null,
                fLongPress:Function = null, bItalic:Boolean = false) {
                    
            name = nam;
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = true;
            this.borderColor = 0x000000;
            this.background = true;
            this.backgroundColor = 0xcccccc;
            this.textColor = 0x000000;
            this.selectable = false;    //ボタンの表示文字は選択不可
            tfFormat = new TextFormat();
            tfFormat.align = TextFormatAlign.CENTER;
            tfFormat.italic = bItalic;
            this.setTextFormat(tfFormat);
            //マウスがのった時の色の変更
            this.addEventListener(MouseEvent.ROLL_OVER, onOver);
            this.addEventListener(MouseEvent.ROLL_OUT, onOut);
            //クリック時の処理
            fncChkFnc = fChk;
            if(fncChk!=null) {this.addEventListener(MouseEvent.CLICK, fncChk);}
            //長押し時の処理
            fncLongPress = fLongPress;
            if (fncLongPress != null) {
                this.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
                this.addEventListener(MouseEvent.MOUSE_UP, onUp);
            }
            this.enable(true);    //ボタンを有効に
        }
        //表示文字の変更
        // sText:表示する文字
        public function setText(sText:String):void {
            this.text = sText;
            this.setTextFormat(tfFormat);
        }
        //ボタンの有効(bflg=true)･無効(bflg=false)
        public function enable(bflg:Boolean):void {
            this.mouseEnabled = bflg;
            if (bflg == true) { this.alpha = 1.0; }
            else {this.alpha = 0.5;}
        }
        //マウスオーバー処理（ボタンらしく見せる）
        public function onOver(e:MouseEvent):void {
            e.target.backgroundColor = 0xaaaaaa;
            //Mouse.cursor=flash.ui.MouseCursor.HAND;
        }
        public function onOut(e:MouseEvent):void {
            e.target.backgroundColor = 0xcccccc;
            //Mouse.cursor=flash.ui.MouseCursor.ARROW;
        }
        //長押し(LongPress)の対応
        public function onDown(e:MouseEvent):void {
            intTim = getTimer();
            this.addEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onUp(e:MouseEvent):void {
            this.removeEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onLongPress(e:Event):void {
            //ボタンを押し続けて0.5秒以上たったら長押し
            if (intTim < getTimer() - 500) { fncLongPress(this); }
        }
        //クリック
        public function fncChk(e:Event):void {
            fncChkFnc(this);
        }
    }
//}
//package cls {
    //----------------------------------------------
    //テキストの表示クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.text.TextField;
    
    //public class  clsText extends TextField {
    class  clsText extends TextField {
        //テキストの表示クラス
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:表示するサイズ
        // bBorder：外枠の有無
        public function clsText(sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number ,
                bBorder:Boolean=false,bSel:Boolean=true) {
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = bBorder;
            this.background = bBorder;
            this.selectable = bSel;
        }
    }
//}