/**
 * Copyright roll.sagawa ( http://wonderfl.net/user/roll.sagawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Fr5
 */

// forked from enok's ぼよよ～ん forked from: Saqoosha challenge for professionals
// http://linkalink.jp/enok/

package {
    import flash.display.Sprite; 
    import flash.display.StageQuality;
    import com.flashdynamix.utils.SWFProfiler;
    
    [SWF(backgroundColor="0xffffff", frameRate="30")] 

    public class PointTransformControllerWonderfl extends Sprite { 
        public function PointTransformControllerWonderfl():void {
            //SWFProfiler.init(stage);
            stage.quality = StageQuality.HIGH;
            
            //Wonderfl.capture(stage,10);
            
            //背景をしく
            graphics.beginFill(0xffffff);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            //配置
            var trick:PointTransform = new PointTransform(this);
            addChild(trick);
        } 
    } 
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObjectContainer;
import flash.display.Sprite; 
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.tweens.ITweenGroup;
class PointTransform extends Sprite {
    protected var _s:DisplayObjectContainer;
    protected var _centerX:Number; //中心X
    protected var _centerY:Number; //中心Y
    protected var _targetW:Number = 430;
    protected var _targetH:Number = 150;
    protected var _split_x:uint = 8; 
    protected var _split_y:uint = 4; 
    
    protected var _gravity:Number = 0.000;
    protected var _spring:Number = 0.0;
    protected var _friction:Number = 0.95;
    protected var _bounce:Number = -0.7;
    protected var _springXLength:Number = 0;
    protected var _springYLength:Number = 0;
    protected var _springXYLength:Number = 0;
    
    protected var _imgBmpData:BitmapData;
    protected var _lineSp:Sprite = new Sprite();
    protected var _imageSp:Sprite = new Sprite();
    protected var _pointList:Vector.<ekPoint> = new Vector.<ekPoint>();
    protected var _jointList:Vector.<Array> = new Vector.<Array>();
    protected var _vecList:Vector.<Array> = new Vector.<Array>();
    
    public function PointTransform(s:DisplayObjectContainer):void {
        _s = s;
        //中点
        _centerX = s.stage.stageWidth / 2;
        _centerY = s.stage.stageHeight / 2;
        
        _springXLength = _targetW / _split_x;
        _springYLength = _targetH / _split_y;
        _springXYLength = Math.sqrt(Math.pow(_springXLength, 2)+Math.pow(_springYLength, 2)) * 1.10;
        
        init();
    }
    
    protected function init():void {
        addChild(_imageSp);
        setText();
        setPoint();
        setJoint();
        setTween();
        
        _s.stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
    }
    
    protected function setText():void {
        var txt:TextField = new TextField();
        var tf:TextFormat = new TextFormat('Verdana', 40, 0x000000, true);
        txt.defaultTextFormat = tf;
        txt.autoSize = TextFieldAutoSize.LEFT;
        txt.text = "ROLL CREATIVE";
        
        _imgBmpData = new BitmapData(_targetW, _targetH, true, 0x0);
        _imgBmpData.draw(txt);
        var imgBmp:Bitmap = new Bitmap(_imgBmpData);
        //addChild(imgBmp);
    }
    
    protected function setPoint():void {
        var base_x:Number = _centerX - _targetW / 2;
        var base_y:Number = _centerY - _targetH / 2;
        
        var point:ekPoint;
        for (var j:int = 0; j <= _split_y; j++) {
            for (var i:int = 0; i <= _split_x; i++) {
                point = new ekPoint(
                    i, j, 
                    i * _targetW / _split_x + base_x, 
                    j * _targetH / _split_y + base_y
                );
                point.drawPoint(0xcc1111);
                point.addEventListener(MouseEvent.MOUSE_DOWN, onPointMouseDown);
                    
                _pointList.push(point);
                addChild(point);
            }
        }
    }
    
    protected function setJoint():void {
        for (var i:uint = 0; i < _pointList.length; i++ ) {
            var point:ekPoint = _pointList[i];
            _jointList.push(new Array(null, null, null, null, null, null, null, null));
            
            if (point._view) {
                var targetPoint:ekPoint;
                
                if (i % (_split_x + 1) != 0) { //左
                    targetPoint = _pointList[i - 1];
                    if(targetPoint._view){
                        _jointList[i][0] = targetPoint;
                    }
                }
                if (i % (_split_x + 1) != 0 && i > _split_x ) { //左上
                    targetPoint = _pointList[i - _split_x - 2];
                    if(targetPoint._view){
                        _jointList[i][1] = targetPoint;
                    }
                }
                if (i > _split_x ) { //上
                    targetPoint = _pointList[i - _split_x - 1];
                    if(targetPoint._view){
                        _jointList[i][2] = targetPoint;
                    }
                }
                if (i % (_split_x + 1) != _split_x && i > _split_x ) { //右上
                    targetPoint = _pointList[i - _split_x];
                    if(targetPoint._view){
                        _jointList[i][3] = targetPoint;
                    }
                }
                if (i % (_split_x + 1) != _split_x) { //右
                    targetPoint = _pointList[i + 1];
                    if(targetPoint._view){
                        _jointList[i][4] = targetPoint;
                    }
                }
                if (i % (_split_x + 1) != _split_x && i < _pointList.length - _split_x - 1 ) { //右下
                    targetPoint = _pointList[i + _split_x + 2];
                    if(targetPoint._view){
                        _jointList[i][5] = targetPoint;
                    }
                }
                if (i < _pointList.length - _split_x - 1 ) { //下
                    targetPoint = _pointList[i + _split_x + 1];
                    if(targetPoint._view){
                        _jointList[i][6] = targetPoint;
                    }
                }
                if (i % (_split_x + 1) != 0 && i < _pointList.length - _split_x - 1 ) { //左下
                    targetPoint = _pointList[i + _split_x];
                    if(targetPoint._view){
                        _jointList[i][7] = targetPoint;
                    }
                }
            }
        }
        
        for (i = 0; i < _pointList.length; i++ ) {
            point = _pointList[i];
            var joint:Array = _jointList[i];
            
            _vecList[i] = new Array(4);
            if (joint[0] && joint[1]) { //左上
                _vecList[i][0] = checkPoint(joint[0], joint[1], point);
            }
            if (joint[2] && joint[3]) { //右上
                _vecList[i][1] = checkPoint(joint[2], joint[3], point);
            }
            if (joint[4] && joint[5]) { //右下
                _vecList[i][2] = checkPoint(joint[4], joint[5], point);
            }
            if (joint[6] && joint[7]) { //左下
                _vecList[i][3] = checkPoint(joint[6], joint[7], point);
            }
        }
    }
    
    protected function setTween():void {
        var tweenList:Array = new Array();
        var delay:Number = 0;
        for each(var point:ekPoint in _pointList) {
            tweenList.push(
                BetweenAS3.serial(
                    BetweenAS3.delay(
                        BetweenAS3.slice(
                            BetweenAS3.scale(
                                BetweenAS3.tween(point, { x : point._baseX, y : point._baseY}, null, 0.6, Bounce.easeOut)
                            ,2)
                        ,0.0, 0.95)
                    ,delay)
                )
            );
            delay += 0.004;
        }
        var tween:ITweenGroup = BetweenAS3.parallelTweens(tweenList)
        tween.play();
        tween.onComplete = function():void { _spring = 0.01; }

        addEventListener(Event.ENTER_FRAME, update);
    }
    
    protected function update(e:Event):void {
        move();
        drawImage();
    }
    
    protected function move():void {        
        for (var i:uint = 0; i < _pointList.length; i++ ) {
            var point:ekPoint = _pointList[i];
            var joint:Array = _jointList[i];
            
            if(point._move && !point._drag){    
                if (joint[0]) { //左
                    springTo(point, joint[0], _springXLength);
                }
                if (joint[1]) { //左上
                    springTo(point, joint[1], _springXYLength);
                }
                if (joint[2]) { //上
                    springTo(point, joint[2], _springYLength);
                }
                if (joint[3]) { //右上
                    springTo(point, joint[3], _springXYLength);
                }
                if (joint[4]) { //右
                    springTo(point, joint[4], _springXLength);
                }
                if (joint[5]) { //右下
                    springTo(point, joint[5], _springXYLength);
                }
                if (joint[6]) { //下
                    springTo(point, joint[6], _springYLength);
                }
                if (joint[7]) { //左下
                    springTo(point, joint[7], _springXYLength);
                }
            }

            point._vy += _gravity;
        }
    }
    
    protected function springTo(pointA:ekPoint, pointB:ekPoint, springLength:Number):void{
        var dx:Number = pointB.x - pointA.x;
        var dy:Number = pointB.y - pointA.y;
        var dist:Number = Math.sqrt(dx * dx + dy * dy);
        //var angle:Number = Math.atan2(dy, dx);
        //var targetX:Number = pointB.x - Math.cos(angle) * springLength;
        //var targetY:Number = pointB.y - Math.sin(angle) * springLength;
        var targetX:Number = pointB.x - dx / dist * springLength;
        var targetY:Number = pointB.y - dy / dist * springLength;
        pointA._vx += (targetX - pointA.x) * _spring;
        pointA._vy += (targetY - pointA.y) * _spring;
        pointA._vx *= _friction;
        pointA._vy *= _friction;
        pointA.x += pointA._vx;
        pointA.y += pointA._vy;
    }
    
    protected function checkPoint(pointA:ekPoint,pointB:ekPoint,pointC:ekPoint):Number {
        //return cross(new Point(pointB.x-pointA.x,pointB.y-pointA.y), new Point(pointC.x-pointA.x,pointC.y-pointA.y)) / Math.sqrt(Math.pow(pointB.x-pointA.x,2) + Math.pow(pointB.y-pointA.y,2));
        return cross(new Point(pointB.x - pointA.x, pointB.y - pointA.y), new Point(pointC.x - pointA.x, pointC.y - pointA.y)) >= 0 ? 1: -1;;
    }
    
    protected function cross(vector1:Point, vector2:Point):Number {
        return vector1.x * vector2.y - vector2.x * vector1.y;
    }
    
    protected function onPointMouseDown(e:MouseEvent):void {
        var target:ekPoint = e.target as ekPoint;
        target.startDrag();
        target._drag = true;
    }
    
    protected function onStageMouseUp(e:MouseEvent):void {
        for each(var point:ekPoint in _pointList) {
            point.stopDrag();
            point._drag = false;
        }
    }
    
    private function drawImage():void {
        var vertices:Vector.<Number> = new Vector.<Number>();
        var indices:Vector.<int> = new Vector.<int>();
        var uvtData:Vector.<Number> = new Vector.<Number>();
        
        var cnt:uint = 0;
        var segment_x:int = _split_x + 1;
        var segment_y:int = _split_y + 1;
        for (var i:uint = 0; i < _pointList.length; i++ ) {
            var point:ekPoint = _pointList[cnt];
            
            vertices.push(point.x);
            vertices.push(point.y);
            uvtData.push(point._posiX / segment_x);
            uvtData.push(point._posiY / segment_y);
            
            cnt++;
        }
        
        for (i = 0; i < segment_y - 1; i++) {
            for (var j:int = 0; j < segment_x - 1; j++) {
                indices.push(i * segment_x + j, i * segment_x + j + 1, (i + 1) * segment_x + j);
                indices.push(i * segment_x + j + 1, (i + 1) * segment_x + 1 + j, (i + 1) * segment_x + j);
            }
        }
        
        _imageSp.graphics.clear();
        _imageSp.graphics.beginBitmapFill(_imgBmpData);
        _imageSp.graphics.drawTriangles(vertices, indices, uvtData);
        _imageSp.graphics.endFill();
    }
}

class ekPoint extends Sprite {
    public var _baseX:Number = 0;
    public var _baseY:Number = 0;
    public var _posiX:Number = 0;
    public var _posiY:Number = 0;
    public var _radius:Number;
    public var _vx:Number = 0;
    public var _vy:Number = 0;
    public var _view:Boolean;
    public var _move:Boolean;
    public var _drag:Boolean = false;
    
    public function ekPoint(posiX:int,posiY:int,px:Number,py:Number,view:Boolean=true,move:Boolean=true,radius:Number=30.0):void {
        _posiX = posiX;
        _posiY = posiY;
        _baseX = px;
        _baseY = py;
        x = 240;
        y = 550;
        _radius = radius;
        _view = view;
        _move = move;
        
        var rand:Number = 5;
        _vx = -0.5 * rand + Math.random() * rand;
        _vy = -0.5 * rand + Math.random() * rand;
    }
    
    public function drawPoint(color:uint = 0x111111, alpha:Number=0.0):void {
        graphics.beginFill(color, alpha);
        graphics.drawCircle(0, 0, _radius);
        graphics.endFill();
    }
}
