/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2FaD
 */

// forked from Horiuchi_H's ペジェ曲線
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	[SWF(width = 465, height = 465, frameRate = 120, backgroundColor = "#0")]
	public class  Main extends Sprite {
		public function Main() {
			this.addEventListener(Event.ADDED, init);
		} 
		
		private function init(e:Event = null):void {
			this.addEventListener(Event.ADDED, init);
			stage.addEventListener(Event.ENTER_FRAME, update);
			var ca:CurveAnimation = new CurveAnimation();
			ca.init(stage);
			
			//うにょうにょの出現率
			const v:uint = 3;
			
			//うにょうにょが曲がる最大の数
			const w:uint = 5;
			
			function update(e:Event):void {
			    //出現させる方法が粗いので重くなるかもしれません
				if (Math.random() * 100 < v) {
					var p:Vector.<Point> = new Vector.<Point>();
					p.push(new Point(0, 465 * Math.random()));
					var c:uint = Math.floor(Math.random() * w);
					for (var k:uint = 0; k < c; k++) p.push(new Point(465 * Math.random(), 465 * Math.random()));
					p.push(new Point(465, 465 * Math.random()));
					
					/*
					 * うにょうにょを呼び出します
					 * CurveAnimation#draw(座標:Vector.<Point>, フレーム数:Number, 色:uint);
					 */
					ca.draw(p, 120, 0xffffff * Math.random());
				}
			}
		}
	}
}


import flash.display.Sprite;
import flash.display.Stage;
import flash.events.Event;
import flash.geom.Point;
class CurveAnimation {
	private var stage:Stage;
	public function CurveAnimation() {
		
	}
	public function init(_stage:Stage):void {
		stage = _stage;
	}

	public function draw(points:Vector.<Point>, frame:uint, color:uint):void {
		stage.addEventListener(Event.ENTER_FRAME, drawCurve);
		var bee:uint = new uint();
		var s:Sprite = stage.addChild(new Sprite()) as Sprite;
		
		function drawCurve(e:Event = null):void{
			if (bee > frame) {
				stage.removeChild(s);
				stage.removeEventListener(Event.ENTER_FRAME, drawCurve);
			}
			var start:Point = calcBezierCurvePoint(points, bee / frame);
			var end:Point = calcBezierCurvePoint(points, (bee + 1) / frame);
			
			s.graphics.lineStyle(1, color);
			s.graphics.moveTo(start.x, start.y);
			s.graphics.lineTo(end.x, end.y);
			bee++;
		}
	}

	private function calcBezierCurvePoint(points:Vector.<Point>, t:Number):Point {
		var ps:Vector.<Point> = points;
		while (ps.length > 1) {
			var k:Number = ps.length - 1;
			var next:Vector.<Point> = new Vector.<Point>();
			for (var i:int = 0; i < k; i++) next.push(new Point(ps[i].x * (1 - t) + ps[i + 1].x * t, ps[i].y * (1 - t) + ps[i + 1].y * t));
			ps = next;
		}
		return ps[0];
	}
}