/**
 * Copyright lenonsun ( http://wonderfl.net/user/lenonsun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2EMz
 */

// forked from yonatan's Liquid rocks
// Texture by Patrick Hoesly - http://www.flickr.com/photos/zooboing/4116009343/in/set-72157623170461711/

/* Shader source code - from http://zozuar.org/las3rfl/node/78

(def code '((parameter "_OutCoord"  f0.rg in)
            (parameter "amplitude"  f1.rg in ("defaultValue" 20 20))
            (parameter "waveLength" f1.ba in ("defaultValue" 40 40))
            (parameter "imgSize" f4.rg in ("defaultValue" 464 464)) ;; one less than the real size or we get artifacts
            (texture "src" 0 4)
            (parameter "dst" f2 out)
            
            (mov f3.rg f0.rg)
            (div f3.rg f1.ba) ;; f3.rg = outcoord / wavelength
            (sin f3.rg f3.rg) ;; f3.rg = sin(outcoord / wavelength)
            (mul f3.rg f1.rg) ;; f3.rg = sin(outcoord / wavelength) * amplitude

            ;; f3.rg (new coord)
            ;;  x = y + sin(x / wavelength) * amplitude
            ;;  y = x + sin(y / wavelength) * amplitude
            (add f3.rg f0.gr)
            (mod f3.rg f4.rg) ;; wraparound
            (set f5.rg 0.5)
            (add f3.rg f5.rg) ;; don't sample at 0 (white artifacts)
            
            ;; sample pixel at new coordinates
            (texb f2 f3.rg 0)))
*/

package {
    import flash.display.*;
    import flash.utils.ByteArray;
    import flash.text.TextField;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.filters.ShaderFilter;
    import flash.geom.Rectangle;
    import mx.utils.Base64Decoder;

    public class LiquidRocks extends Sprite {
        public function LiquidRocks() {
            var dec:Base64Decoder = new Base64Decoder;
            dec.decode("oQECAAAMX091dENvb3JkAKEBAgEADGFtcGxpdHVkZQCiAmRlZmF1bHRWYWx1ZQBBoAAAQaAAAKEBAgEAA3dhdmVMZW5ndGgAogJkZWZhdWx0VmFsdWUAQiAAAEIgAAChAQIEAAxpbWdTaXplAKICZGVmYXVsdFZhbHVlAEPoAABD6AAAowAEc3JjAKECBAIAD2RzdAAdAwDBAAAQAAUDAMEBALAADAMAwQMAEAADAwDBAQAQAAEDAMEAAEAACAMAwQQAEAAyBQDAPwAAAAEDAMEFABAAMQIA8QMAEAA=");
            var bytes:ByteArray = dec.toByteArray();
            var shader:Shader = new Shader(bytes);
            var filter:ShaderFilter = new ShaderFilter(shader);

            var bmd:BitmapData = new BitmapData(465, 465, true, 0);
            var bmp:Bitmap = new Bitmap(bmd);
            var ldr:Loader = new Loader;
            addChild(bmp);

            function init(e:*):void {
                var frameCnt:int = 0;

                function frameHandler(e:*):void {
                    ldr.width = ldr.height = 465;
                    bmd.draw(ldr, ldr.transform.matrix);
                    var amp:Number = 75 * Math.sin(frameCnt/15);
                    shader.data["amplitude"]["value"] = [amp, amp];
                    bmp.filters = [filter];
                    frameCnt++;
                }

                stage.addEventListener("enterFrame", frameHandler);
            }

            ldr.contentLoaderInfo.addEventListener("complete", init);
            ldr.load(new URLRequest("http://farm3.static.flickr.com/2525/4116009343_81559bbf20.jpg"), new LoaderContext(true));
        }
    }
}