/**
 * Copyright davinci_leonard ( http://wonderfl.net/user/davinci_leonard )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2EI4
 */

// Circle Spectrum with mp3
// By Davinci_Leonard
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.text.*;
    import flash.utils.*;
    import mx.core.*;
    import flash.system.LoaderContext;
    
    [SWF(width=200,height=200,backgroundColor=0x000000)]
    
    public class spectrum extends flash.display.Sprite
    {
        public function spectrum()
        {
            var loc1:*;
            loc1 = null;
            var context:SoundLoaderContext;
            shape = new flash.display.Shape();
            bmpData = new flash.display.BitmapData(200, 200, true, 0x000000); // size
            bmp = new flash.display.Bitmap(bmpData, "auto", true);
            blur = new flash.filters.BlurFilter(5, 5);
            offsetX = 100; // size/2
            offsetY = 100; // size/2
            sound = new flash.media.Sound();
            byteArray = new flash.utils.ByteArray();
            nRadius = 40; // rayon
            nRadiusOffset = 20; // hauteur rayon
            nColorOffset = 0;
            super();
            addChild(bmp);
            loc1 = new Array();
            loc1 = loc1.concat([1.3, 0, 0, 0, 0]);
            loc1 = loc1.concat([0, 1.3, 0, 0, 0]);
            loc1 = loc1.concat([0, 0, 1.3, 0, 0]);
            loc1 = loc1.concat([0, 0, 0, 0.9, 0]);
            light = new flash.filters.ColorMatrixFilter(loc1);
            
            context = new SoundLoaderContext(10,true);
            
            var req:URLRequest = new URLRequest("http://www.takasumi-nagai.com/soundfiles/01.mp3");
            sound.load(req,context);
            stage.addEventListener(flash.events.Event.ENTER_FRAME, redraw);
            launch(); // start !
            return;
        }

        private function soundComplete(arg1:flash.events.Event):void
        {
            var loc1:*;
            loc1 = null;
            return;
        }

        private function launch():void
        {
            var loc1:*;
            loc1 = null;
            channel = sound.play();
            channel.removeEventListener(flash.events.Event.SOUND_COMPLETE, soundComplete);
            channel.addEventListener(flash.events.Event.SOUND_COMPLETE, soundComplete);
            return;
        }

        private function rainbow(arg1:Number):Number
        {
            var loc1:*;
            loc1 = NaN;
            var loc2:*;
            loc2 = NaN;
            var loc3:*;
            loc3 = NaN;
            loc1 = Math.sin(nColorOffset + arg1++) * 127 + 128 << 16;
            loc2 = Math.sin(nColorOffset + arg1) * 127 + 128 << 8;
            loc3 = Math.cos(nColorOffset + arg1--) * 127 + 128;
            return loc1 | loc2 | loc3;
        }

        private function redraw(arg1:flash.events.Event):void
        {
            var loc1:*;
            loc1 = 0;
            var loc2:*;
            loc2 = NaN;
            var loc3:*;
            loc3 = NaN;
            var loc4:*;
            loc4 = NaN;
            flash.media.SoundMixer.computeSpectrum(byteArray, false);
            bmpData.applyFilter(bmpData, bmpData.rect, new flash.geom.Point(0, 0), blur);
            bmpData.applyFilter(bmpData, bmpData.rect, new flash.geom.Point(0, 0), light);
            shape.graphics.clear();
            loc1 = 0;
            while (loc1 < 256) 
            {
                shape.graphics.lineStyle(5, rainbow(loc1 * (-Math.PI) / 255));
                loc2 = nRadius + byteArray.readFloat() * nRadiusOffset;
                loc3 = offsetX + loc2 * Math.cos(loc1 * (-Math.PI) / 255);
                loc4 = offsetY + loc2 * Math.sin(loc1 * (-Math.PI) / 255);
                if (loc1 != 0)
                {
                    shape.graphics.curveTo(loc3, loc4, oldX, oldY);
                }
                else 
                {
                    shape.graphics.moveTo(loc3, loc4);
                }
                oldX = loc3;
                oldY = loc4;
                ++loc1;
            }
            loc1 = 0;
            while (loc1 < 256) 
            {
                shape.graphics.lineStyle(5, rainbow(loc1 * Math.PI / 255));
                loc2 = nRadius + byteArray.readFloat() * nRadiusOffset;
                loc3 = offsetX + loc2 * Math.cos(loc1 * Math.PI / 255);
                loc4 = offsetY + loc2 * Math.sin(loc1 * Math.PI / 255);
                if (loc1 != 0)
                {
                    shape.graphics.curveTo(loc3, loc4, oldX, oldY);
                }
                else 
                {
                    shape.graphics.moveTo(loc3, loc4);
                }
                oldX = loc3;
                oldY = loc4;
                ++loc1;
            }
            bmpData.draw(shape);
            nColorOffset = nColorOffset - Math.PI / 50;
            return;
        }

        private var channel:flash.media.SoundChannel;
        private var sound:flash.media.Sound;
        private var light:flash.filters.ColorMatrixFilter;
        private var blur:flash.filters.BlurFilter;
        private var bmp:flash.display.Bitmap;
        private var shape:flash.display.Shape;
        private var byteArray:flash.utils.ByteArray;
        private var bmpData:flash.display.BitmapData;
        private var oldX:Number;
        private var oldY:Number;
        private var offsetY:Number=200;
        private var offsetX:Number=200;
        private var nRadiusOffset:Number=20;
        private var nColorOffset:Number=0;
        private var nRadius:Number=120;
    }
}
