/**
 * Copyright utabi ( http://wonderfl.net/user/utabi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2E1w
 */

// forked from utabi's カメラの残像をつくってあそぶ
// カメラの残像をつくってあそぶ（たまたまできた）

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.ConvolutionFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.media.Camera;
    import flash.media.Video;
    
    [SWF(frameRate="30")]
    
    public class AfterImage extends Sprite {
        Wonderfl.capture_delay( 15 );
        private var camera:Camera;
        private var video:Video;
        private var videoWidth:int = 598;
        private var videoHeight:int = 598;
        private var bd:BitmapData;
        private var currentBD:BitmapData;
        private var oldBD:BitmapData;
        private var diffBD:BitmapData;
        private var overlay:BitmapData;
        private var rect:Rectangle;
        private var zeroPoint:Point = new Point(0,0);

        private var blurFilter:BlurFilter = new BlurFilter(3,3);
        private var grayConst:Array = [
            0.3, 0.59, 0.11, 0, 0,
            0.3, 0.59, 0.11, 0, 0,
            0.3, 0.59, 0.11, 0, 0,
            0, 0, 0, 0, 255
        ];
        private var grayFilter:ColorMatrixFilter = new ColorMatrixFilter(grayConst);
        
        private var threshold:uint=0xFF222222;
            
        public function AfterImage() {
            camera = Camera.getCamera();
            if (camera==null) {
            } else {
                start();
            }
        }
        private function start():void {
            camera.setMode(videoWidth, videoHeight,20);
            video = new Video(videoWidth, videoHeight);
            video.attachCamera(camera);
            bd = new BitmapData(videoWidth,videoHeight);
            currentBD = new BitmapData(videoWidth,videoHeight);
            oldBD = new BitmapData(videoWidth,videoHeight);
            diffBD = new BitmapData(videoWidth,videoHeight);
            overlay = new BitmapData(videoWidth,videoHeight,true,0);
            rect = currentBD.rect;
            
            this.addChild(video);
            this.addChild(new Bitmap(bd));

            //this.getChildAt(1).y=233;
            this.addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        private function onEnterFrame(e:Event):void {
            
            
            currentBD.lock();
            oldBD.lock();
            diffBD.lock();
            overlay.fillRect(rect,0);
            overlay.lock();
            
            currentBD.draw(video);
            currentBD.applyFilter(currentBD,rect,zeroPoint,grayFilter);
            
            diffBD.draw(currentBD);
            diffBD.draw(oldBD,null,null,BlendMode.DIFFERENCE);
            diffBD.applyFilter(diffBD, rect,zeroPoint,blurFilter);
            diffBD.threshold(diffBD, rect, zeroPoint, ">", 0xff222222, 0xffffffff);
            diffBD.threshold(diffBD, rect, zeroPoint, "<", 0xff111111, 0x00000000);
            
            oldBD.draw(currentBD);
            
            currentBD.unlock();
            oldBD.unlock();
            diffBD.unlock();
            overlay.unlock();
            bd.draw(diffBD);
        }
        
    }
}