/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Dyq
 */






package 
{
    import flash.filters.ColorMatrixFilter;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Graphics;
    import flash.display.Sprite;


    public class FlashTest extends Sprite 
    {
        private var diamondVectorCont:Vector.<Diamond> = new Vector.<Diamond>();
        private var diamondContainer:Sprite = new Sprite();
        private var diamondBitmap:Bitmap = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0))
     
        
        public function FlashTest() 
        {
            addChild(diamondBitmap);
            addChild(diamondContainer);
            addListener();
        }
     
        
        private function addListener():void
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, addDiamonds);
            stage.addEventListener(Event.ENTER_FRAME, moveDiamondsToBitmap);
        }
     
        
        private function moveDiamondsToBitmap(e:Event):void
        {
            for(var i:int = diamondVectorCont.length-1 ; i >= 0 ; i--)
            {
                var d:Diamond = diamondVectorCont[i];
                if(!d.alive)
                {
                    diamondContainer.removeChild(d);
                    diamondVectorCont.splice(i, 1);
                    var s:Sprite = new Sprite();
                    s.addChild(d);
                    diamondBitmap.bitmapData.draw(s);
                }
            }            
            diamondBitmap.bitmapData.applyFilter(diamondBitmap.bitmapData, diamondBitmap.bitmapData.rect, new Point(0, 0), new BlurFilter(2, 2));
        }


        private function addDiamonds(e:MouseEvent):void
        {
            for(var i:int = 0; i<1; i++)
            {
                var diamond:Diamond = new Diamond(e.stageX, e.stageY);
                diamond.setDirection(Math.random()*Math.PI*2);
                diamond.setPower(5 + Math.random() * 10);
                diamondVectorCont.push(diamond);
                diamondContainer.addChild(diamond);
            }
        }        
    }
}



import flash.events.Event;
import flash.display.Sprite;
import flash.display.Graphics;

class Diamond extends Sprite
{
    private var size:int = 0,
                direction:Number = 0,
                power:Number = 0;
                
    public var alive:Boolean = false;
    
    public function Diamond(x:int,y:int)
    {
        size = 5 + Math.random() * 10;

        var g:Graphics = this.graphics;
        g.beginFill(Math.random() * 0xffffff, 0.3 + Math.random() * 0.5);
        g.drawCircle( 0,0,size*0.6);///(size*1) );
      /*g.moveTo(size, 0);
        g.lineTo(0, size/2);
        g.lineTo(-size, 0);
        g.lineTo(0, -size/2);    */

        this.x = x;
        this.y = y;
    }

    
    private function addListener():void
    {
        addEventListener(Event.ENTER_FRAME, updateMyPosition);
    }

    
    private function removeListener():void
    {
        removeEventListener(Event.ENTER_FRAME, updateMyPosition);
    }

    
    private function updateMyPosition(e:Event):void
    {
        if(alive)
        {
            this.blendMode = 'add';
            this.x += Math.cos(direction) * power;
            this.y += Math.sin(direction) * power;
            this.scaleX += power/40;  // power/15;
            this.scaleY += power/40;  // power/100;
            power *= 0.85; // 0.618;  // 0.9;
            if(power < 1)
            {
                power = 0;
                alive = false;
                removeListener();
            }
        }
    }

  
    public function setDirection(direction:Number):void
    {
        this.direction = direction;
        this.rotation = direction * 180 / Math.PI;
    }

    public function setPower(power:Number):void
    {
        this.power = power;
        alive = true;
        addListener();
    }
}