/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2DtN
 */

// forked from narutohyper's Alternativa3D ファイアーボール　Sprite3Dのネストによる軌道表現
// forked from clockmaker's [Alternativa3D] Basic Template
package {

	import alternativ5.engine3d.materials.*;
	import alternativ5.engine3d.primitives.*;
	import alternativ5.engine3d.core.*;
	import alternativ5.types.Texture;
	import alternativ5.types.Point3D;
	import alternativ5.utils.*

	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.BlendMode

	
	[SWF(width = 465, height = 465, frameRate = 24, backgroundColor=0)]
	/**
	 * Alternativa3D ファイアーボール　Sprite3Dのネストによる軌道表現
	 * 
	 * Sprite3Dを使っての、Particle処理 明日の為の第3歩
	 * Sprite3Dの中で、Sprite3Dをネストしてます。
 	 * 
	 * Clickで火の玉発射
	 * 
	 * @narutohyper
	 */

	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	public class SimpleDemo extends Sprite {
		private var template:BasicTemplate

		public function SimpleDemo():void {

			// テンプレートを作成します
			template = new BasicTemplate();
			addChild(template);

			// FPS display launch 
			FPS.init(stage); 

			//Planeの作成
				var plane:Plane=new Plane(1000,1000,10,10)
				plane.cloneMaterialToAllSurfaces(new FillMaterial(0x333333,1,BlendMode.NORMAL,1,0x666666));
				template.scene.root.addChild(plane); 
				plane.rotationX=MathUtils.toRadian(90)
				plane.y=21

				var box:Object3D=new Object3D()
				template.scene.root.addChild(box); 


			var temp:Particle=new Particle(this,template.scene,box)

			//this.stage.addEventListener(MouseEvent.CLICK, onClick);


			var me:SimpleDemo=this;
			//function onClick(e:MouseEvent):void {
			//	var temp:Particle=new Particle(me,template.scene,box)
			//}
			

			var counter:uint=0
			template.onPreRender = function():void {
				
				//連発
				counter=(counter+1)%5
				if (!counter) {
					var temp:Particle=new Particle(me,template.scene,box)
				}


				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				var rateY:Number = mouseY / stage.stageHeight;
				template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				
				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());
			}
		}
	}
}


import alternativ5.engine3d.materials.*;
import alternativ5.engine3d.primitives.*;
import alternativ5.engine3d.core.Sprite3D;

import alternativ5.engine3d.physics.Collision
import alternativ5.engine3d.physics.EllipsoidCollider

import alternativ5.types.Texture;
import alternativ5.types.Point3D;
import alternativ5.types.Matrix3D;
import alternativ5.types.Set;

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Matrix
import flash.filters.BlurFilter;
import flash.filters.BitmapFilterQuality;
import flash.display.BlendMode

import flash.utils.Timer;
import flash.events.TimerEvent;


class Particle extends Sprite3D{

	private var parent3D:Object3D;
	private var parentMc:Sprite;

	private var myTimer:Timer
	private var lastEffect:Boolean=false;

	private var particleArray:Array
	private var orbit:uint



	//衝突感知用変数
	private var collider:EllipsoidCollider;
	private var collision:Collision;
	private var nowPoint:Point3D;				//現在の位置
	private var newPoint:Point3D;				//移動位置
	private var speed:Point3D;					//スピード
	private var deceleration:Number;		//跳ね
	private var acceleration:Point3D;		//加速
	private var tempPoint:Point3D;

	//軌道用変数
	private var orbitArray:Array=[];
	private var orbitPoint:Point3D;
	private var orbitCull:uint=1;					//間引き（frameRateで間引き）


	public function Particle(mc:Sprite,scene:Scene3D,mc3D:Object3D,size:Number=60,color:uint=0xFF8844,life:Number=1000,_orbit:uint=10) {
		//-----------------------------------------------
		// スプライト3Dの作成
		//-----------------------------------------------
			parentMc=mc
			parent3D=mc3D
			parent3D.addChild(this);
			orbit=_orbit					//軌道に使うスプライトの数
			particleArray=[]

			//軌道用Spriteの縮小係数
			var mini:Number=0.4

			// スプライト3Dを作成します
			//this.material=makeMaterial(size,color);
			for(var i:uint=0;i<orbit;i++) {
				particleArray.push(childParticle(size-(size/orbit*i*mini),color,i))
				this.addChild(particleArray[i])
				particleArray[i].material.alpha-=i/orbit
			}


			// 衝突用変数の登録
			tempPoint= new Point3D();
			nowPoint = new Point3D(0,0,0);
			newPoint = new Point3D();
			speed=new Point3D(0,-(35+(Math.random()*10)),0);					//スピード
			deceleration=0.65;																			//減速
			acceleration=new Point3D(Math.random()*1-0.5,1.65,Math.random()*1-0.5);	//加速

			//衝突判定に使う球の作成
			collider = new EllipsoidCollider(scene,size/2,size/2,size/2);
			collision = new Collision();
			collider.collisionSet=new Set()

			//衝突判定に使うFace(Mesh)の登録
			collider.collisionSet.add(particleArray[0]);

			parentMc.addEventListener(Event.ENTER_FRAME, onRenderTick);

			//寿命
			var timer:Timer = new Timer(life, 1);
			timer.start(); 
			timer.addEventListener(TimerEvent.TIMER_COMPLETE, completeHandler);

			//軌道用配列変数
			orbitPoint=new Point3D()

			for(i=0;i<orbit*orbitCull;i++) {
				orbitArray.push(new Point3D())
			}

	}

	private function del():void {
		parentMc.removeEventListener(Event.ENTER_FRAME, onRenderTick);
		parent3D.removeChild(this);
		delete this;
	}


	private function completeHandler(e:TimerEvent):void {
		lastEffect=true;
	}

	private function onRenderTick(e:Event):void {
		speed.add(acceleration);

		//何かに衝突したかどうかをcheckし、真なら衝突情報をcollisionに返す
		if (collider.getCollision (nowPoint, speed, collision)) {
			//衝突方向と進行方向の内積をとり、新たな方向を割り出す。
			tempPoint=collision.normal
			tempPoint.multiply(2 * Point3D.dot(tempPoint, speed));
			speed.subtract(tempPoint);
			speed.multiply(deceleration);
		} else {
			//現在地(nowPoint)から移動分(speed ベクトル)を移動させ、衝突を判定した上で、新しい移動座標をdestinationPointに返します
			collider.calculateDestination(nowPoint, speed ,newPoint);
		}

		
		orbitArray.push(new Point3D(nowPoint.x,nowPoint.y,nowPoint.z))	//軌道最後に前の位置を追加
		orbitArray.shift()																							//軌道最初の値を削除

		nowPoint.copy(newPoint);
		particleArray[0].coords = nowPoint;

		if (lastEffect) {
			for(var i:uint=0;i<orbit;i++) {
				particleArray[i].material.alpha-=0.02
				particleArray[i].scaleX-=0.02
				particleArray[i].scaleY-=0.02
			}
			if (particleArray[0].material.alpha<=0) {
				del()
			}
		}

		for(i=1;i<orbit;i++) {
			var temp:Point3D=orbitArray[orbitArray.length-i*orbitCull]
			particleArray[i].coords=temp
		}


	}



	private function childParticle(size:Number,color:uint,lv:uint):Sprite3D {
		// スプライト3Dを作成します
		var result:Sprite3D = new Sprite3D();
		result.material=makeMaterial(size,color,lv);
		return result;

	}

	private function makeMaterial(size:Number,color:uint,lv:uint):SpriteTextureMaterial {

		var tempSprite:Sprite = new Sprite()
		tempSprite.graphics.beginFill(color,1)
		tempSprite.graphics.drawCircle(0,0,size/2)


		var filter:BlurFilter = new BlurFilter(5+lv*2, 5+lv*2,3);
		var myFilters:Array = [filter]
		tempSprite.filters = myFilters;

		// スプライト3D用のマテリアルを作成します
		var bmd:BitmapData = new BitmapData(tempSprite.width*2,tempSprite.height*2,true, 0x00000000)

		var mtr:Matrix=new Matrix();
		mtr.translate(tempSprite.width, tempSprite.height)
		bmd.draw(tempSprite,mtr)

		//var material:SpriteTextureMaterial = new SpriteTextureMaterial(new Texture(bmd),1,true,BlendMode.ADD);
		var material:SpriteTextureMaterial = new SpriteTextureMaterial(new Texture(bmd),1,false,BlendMode.ADD);

		return material;
	}


}










/**
 * ソースが長くなるので、comment削除しちゃいました
 * コメントはフォーク元をご覧ください。

 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{
	public var scene:Scene3D;
	public var view:View;
	public var camera:Camera3D;
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	protected function atInit():void {}
	
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	protected function atPreRender():void {}
	
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	protected function atPostRender():void {
	}
	
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}

	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	public function singleRender():void {
		onRenderTick();
	}
	
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	private function onRenderTick(e:Event = null):void {
		atPreRender();
		_onPreRender();
		scene.calculate();
		atPostRender();
		_onPostRender();
	}
	
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}





