/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2DaM
 */

// 1. イケてる自分の顔をwebカメラに映す。
// 2. アレのメガネとか腕とかをドラッグで移動。Shift 押しながらで拡大縮小。
// 3. SAVEボタンではいチーズ！ 。
//　っていうかwebカメラ使っておいて「自動顔認識」とかじゃなくて手動で位置合わせとかないわー。
package {
	import flash.events.TimerEvent;
	import flash.utils.Timer;

	import com.bit101.components.PushButton;

	import mx.graphics.codec.PNGEncoder;

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.net.FileReference;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	import flash.utils.ByteArray;

	/**
	 * @author fumix
	 */
	[SWF(backgroundColor="#000000", frameRate="31", width="465", height="465")]

	public class AnohitoMaker extends Sprite {

		private var _camera : Camera;
		private var _w : int;
		private var _h : int;
		private var _video : Video;
		private var _startScale : Number;
		private var _startPoint : Point;
		private var _ude : Sprite;
		private var _megane : Sprite;
		private var _referenceObject : Sprite;
		private var _btn : PushButton;
		private var _timer : Timer;
		private var _count : int;
		private var _fl : FileReference

		
		/**
		 * コンストラクタ
		 */
		public function AnohitoMaker() {
			if (stage) initialize();
			else addEventListener(Event.ADDED_TO_STAGE, initialize);			
		}

		/**
		 * 初期化
		 * @param event 
		 */
		private function initialize(event : Event = null) : void {
			removeEventListener(Event.ADDED_TO_STAGE, initialize);
			//プロパティの初期化
			_startPoint = new Point();
			//背景
			_w = stage.stageWidth;
			_h = stage.stageHeight;
			var bmd : BitmapData = new BitmapData(_w, _h, null, 0x000000);
			addChild(new Bitmap(bmd));
			
			//webカメラ
			_camera = Camera.getCamera();

			//カメラあり
			if(_camera != null) {
				setupCamera();
            //カメラ無し
			} else {
				var txt : TextField = new TextField();
				txt.textColor = 0xFFFFFF;
				txt.text = 'カメラ無し';
				addChild(txt);
			}
			//あの画像読み込み
			var url : String = "http://assets.wonderfl.net/images/related_images/e/ec/ec7f/ec7fd9e7c7419800b86347d36243def006e5f365";
			var loader : Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
			loader.load(new URLRequest(url), new LoaderContext(true));
			
			//保存ボタン
			_btn = new PushButton(this, 0, 0, 'save', buttonClickHandler);
		}

		/**
		 * ボタンクリック
		 * @param event
		 */
		private function buttonClickHandler(event : MouseEvent) : void {
			//タイマーハンドラ(カウントダウン)
			/*
			_count = 3;
			_timer = new Timer(1000, 4);
			_timer.addEventListener(TimerEvent.TIMER, timerHandler);
			_timer.start();
			*/
				_btn.visible = false;
				var cap : BitmapData = new BitmapData(_w, _h);
				cap.draw(this);
				var enc : PNGEncoder = new PNGEncoder();
				var byteArray : ByteArray = enc.encode(cap);
				_fl = new FileReference;
				_fl.save(byteArray, "anohito.png");
				_btn.visible = true;
				_btn.label = 'save';
		}

		/**
		 * タイマーハンドラ(カウントダウン)
		 * @param event
		 */
		private function timerHandler(event : TimerEvent) : void {
			_btn.label = String(_count);
			_count--;
			if(_count == 0) {
				_btn.visible = false;
				var cap : BitmapData = new BitmapData(_w, _h);
				cap.draw(this);
				var enc : PNGEncoder = new PNGEncoder();
				var byteArray : ByteArray = enc.encode(cap);
				_fl = new FileReference;
				_fl.save(byteArray, "anohito.png");
				_btn.visible = true;
				_btn.label = 'save';
			}			
		}

		/**
		 * 画像読み込み完了
		 * @param event
		 */
		private function loadCompleteHandler(event : Event) : void {
			var content : Bitmap = LoaderInfo(event.target).content as Bitmap;
			var bmd : BitmapData = content.bitmapData;
			var bmd_ude : BitmapData = new BitmapData(474, 259, true, 0x00FFFFFF);
			var bmd_megane : BitmapData = new BitmapData(127, 45, true, 0x00FFFFFF);
			
			//メガネ設置
			bmd_megane.draw(bmd);
			var bm_megane : Bitmap = new Bitmap(bmd_megane);
			bm_megane.x = -bm_megane.width / 2;
			bm_megane.y = -bm_megane.height / 2;
			_megane = new Sprite();
			_megane.buttonMode = true;
			_megane.addChild(bm_megane);
			_megane.x = _w / 2;
			_megane.y = _h / 2 - 100;
			addChild(_megane);

			//うで設置
			var mtx : Matrix = new Matrix();
			mtx.translate(0, -45);
			bmd_ude.draw(bmd, mtx, null);
			var bm_ude : Bitmap = new Bitmap(bmd_ude);
			bm_ude.x = -bm_ude.width / 2;
			bm_ude.y = -bm_ude.height / 2;
			_ude = new Sprite();
			_ude.buttonMode = true;
			_ude.addChild(bm_ude);
			_ude.x = _w / 2;
			_ude.y = _h - _ude.height / 2;
			addChild(_ude);

			//マウスハンドラ（ドラッグ処理）登録
			_ude.addEventListener(MouseEvent.MOUSE_DOWN, dragStart);
			_megane.addEventListener(MouseEvent.MOUSE_DOWN, dragStart);
		}

		/**
		 * ドラッグ処理
		 * @param event
		 */
		private function dragStart(event : MouseEvent) : void {
			var sp : Sprite = event.target as Sprite;
			if (event.shiftKey) {
				_startScale = sp.scaleX;
				_startPoint.x = stage.mouseX;
				_startPoint.y = stage.mouseY;
				_referenceObject = sp;
				
				//拡大縮小
				stage.addEventListener(MouseEvent.MOUSE_MOVE, scaleObject);
				//拡大縮小終わり
				stage.addEventListener(MouseEvent.MOUSE_UP, scaleEnd);
			} else {
				//ドラッグオン
				sp.startDrag(false);
				//ドラッグオフ処理
				sp.addEventListener(MouseEvent.MOUSE_UP, dragEnd);
			}
		}

		/**
		 * ドラッグオフ処理
		 * @param event
		 */
		private function dragEnd(event : MouseEvent) : void {
			Sprite(event.target).stopDrag();
		}

		/**
		 * 拡大縮小処理
		 * @param event
		 */
		private function scaleObject(event : MouseEvent) : void {
			var newScale : Number = _startScale * (stage.mouseX - _referenceObject.x) / (_startPoint.x - _referenceObject.x);
			_referenceObject.scaleX = _referenceObject.scaleY = newScale;
		}

		/**
		 * 拡大縮小処理終わり
		 * @param event
		 */
		private function scaleEnd(event : MouseEvent) : void {
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, scaleObject);
		}

		/**
		 * webカメラセットのアップ
		 */
		private function setupCamera() : void {
			_camera.setMode(Math.floor(_w / 2), Math.floor(_h / 2), 15);
			_video = new Video(_w, _h);
			_video.attachCamera(_camera);
			addChild(_video);			
		}
	}
}
