/**
 * Copyright chiqui ( http://wonderfl.net/user/chiqui )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2DVS
 */

package {
    import flash.display.BlendMode;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        
        private var mesh:Array;
        private var meshlen:int;
        private var fl:int = 300;
        private var orig:Point = new Point(180, 180);
        private var centro:Object = {x:30,y:30,z:-50};
        private var radio:Number = 100;
        
        private var holder:Sprite;
        
        private var render:BitmapData;
        private var renderbmp:Bitmap;
        
        private var displaceMatrix:Matrix;
        
        private var mouseDown:Boolean = false;
        
        public function FlashTest() {
            // write as3 code here..
            holder = new Sprite();        
            render = new BitmapData(500, 500, true, 0);
            renderbmp = new Bitmap(render);
            this.addChild(renderbmp);
            //infinito
            displaceMatrix = new Matrix();
            displaceMatrix.translate(-665, -670);
            displaceMatrix.scale(-.5,-.5);
            //particulas
            createMesh();
            this.stage.addEventListener(Event.ENTER_FRAME, step);
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, onmdown);
            this.stage.addEventListener(MouseEvent.MOUSE_UP, onmup);
        }
        
        private function onmdown(evt:MouseEvent):void{
            for(var i:int = 0; i<meshlen;i++){
                mesh[i].vor = .5;
            }
            mouseDown = true;            
        }
        private function onmup(evt:MouseEvent):void{
            mouseDown = false;
            for(var i:int = 0; i<meshlen;i++){
                mesh[i].vor = 0;
            }      
        }

        private function step(evt:Event):void{
            //update graficos
             holder.graphics.clear();
             for(var i:int = 0; i<meshlen;i++){
                if(mouseDown){
                    mesh[i].or+=mesh[i].vor;
                }else{
                    var dorStep:Number = (mesh[i].origOr/mesh[i].or)/3;
                    if(mesh[i].or > mesh[i].origOr)mesh[i].or -= dorStep;
                }
   
                var r:Number = fl/(fl+mesh[i].z);
                var tarx:Number = orig.x + mesh[i].x * r;
                var tary:Number = orig.y + mesh[i].y * r;
                mesh[i].x = centro.x - (mesh[i].or) * Math.sin(mesh[i].p) * Math.cos(mesh[i].t);
                mesh[i].z = centro.z - (mesh[i].or) * Math.sin(mesh[i].p) * Math.sin(mesh[i].t);
                mesh[i].y = centro.y - (mesh[i].or) * Math.cos(mesh[i].p);
                mesh[i].p+=.01;
                mesh[i].t+=.01;
                mesh[i].t+=(stage.mouseX-300)/10000;
                mesh[i].p+=(stage.mouseY-300)/10000;
                holder.graphics.beginFill(mesh[i].color, r*.5);
                var  sz:Number = mesh[i].r*(r/2);
                holder.graphics.drawCircle(tarx, tary, sz);
                holder.graphics.endFill();
             }
             //render bitmap
             var over:BitmapData = render.clone();
             over.fillRect(render.rect, 0xFF332525);
             render.draw(over,null, new ColorTransform(1,1,1, .3));
             var main:BitmapData = render.clone();
             main.draw(holder);
             render.draw(main, null, new ColorTransform(1,1,1,1));
             render.draw(render, displaceMatrix, new ColorTransform(1,1,1,.4), BlendMode.LIGHTEN);
        }

        private function createMesh():void{
            mesh = new Array; var leni:int = 30; var lenj:int = 30;
            meshlen = leni*lenj;
            for(var i:int = 0; i<leni;i++){
                for(var j:int = 0; j<lenj; j++){
                    mesh.push(new Pt(i*15, i*15, i*15, Math.random()*2, Math.random()));
                } 
            }
        }

    }

}
class Pt{
        public var x:Number;
        public var y:Number;
        public var z:Number;
        public var p:Number;
        public var t:Number;
        public var color:uint;
        public var r:Number = 4;
        public var or:Number = 100;
        public var origOr:Number;
        public var vor:Number = 0;
        public function Pt(xx:Number, yy:Number, zz:Number, st:Number, sp:Number){
            x = xx; y=yy; z=zz;
            p = sp*Math.PI; t = st*Math.PI;
            r = 1+Math.random()*2;
            origOr = or = 100+(Math.random()*40)-20;
            color = uint("0xFF"+uint(Math.random()*0xEEEE).toString(16));
        }
    }