/**
 * Copyright nondelion ( http://wonderfl.net/user/nondelion )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2CB9
 */

package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.utils.Dictionary;
	import net.hires.debug.Stats;

        [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
	
	public class RainbowCircle extends Sprite
	{
		private var bmd:BitmapData;
		private var canvas:BitmapData;
		private var particles:Dictionary;
		protected static const PARTICLE_NUM:uint = 3000;
		
		public function RainbowCircle()
		{
			bmd = new BitmapData(465, 465, false, 0x0);
			var param1:Number = Math.floor(Math.random()*265)+200;
			var param3:Number = Math.floor(Math.random()*10);
			bmd.perlinNoise(param1,param1,6,param3,false,true);
			
			canvas = new BitmapData(465, 465, true, 0xff000000);
			addChild( new Bitmap(canvas));

			//this.addChild(new Stats());
			
			particles = new Dictionary();
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		
		private function setParticles():void
		{
			var o:Point = new Point(mouseX,mouseY);
			var p:Particle;
			for(var i:int=0; i<PARTICLE_NUM; i++){
				p = new Particle();
				p.color = 0xffffff;
				p.x = o.x;
				p.y = o.y;
				var r:Number = Math.random()*40 + 80;
				var angle:Number = i%360+Math.random();
				p.radian = angle2radian(angle);
				p.vx = angle2x(angle,r);
				p.vy = angle2y(angle,r);
				particles[p] = true;
			}
		}
		
		private function angle2x(a:Number, r:Number):Number {
			return r * Math.cos(angle2radian(a));
		}
		
		private function angle2y(a:Number, r:Number):Number {
			return r * Math.sin(angle2radian(a));
		}
		
		private function angle2radian(a:Number):Number {
			return a * Math.PI / 180;
		}
		
		private function mouseMoveHandler(e:MouseEvent):void
		{
			setParticles();
			addEventListener( Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void
		{
			canvas.lock();
			canvas.fillRect(canvas.rect, 0xff000000);
			for(var key:* in particles){
				var p:Particle = Particle(key);
				canvas.setPixel32(p.x, p.y, bmd.getPixel(p.x, p.y) + (0xff<<24));
				p.x += p.vx;
				p.y += p.vy;
				p.vx = (Math.random()*30)*Math.cos(p.radian);
				p.vy = (Math.random()*30)*Math.sin(p.radian);
				if( p.x > 465 || p.y > 465 || p.x < 0 || p.y < 0){
					delete particles[p];
				}
			}
			canvas.unlock();
		}
	}
}

class Particle
{
	public var color:uint;
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var radian:Number;
	
	public function Particle()
	{
		
	}
}