/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2C5B
 */

package {
    
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Point;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.utils.Timer;
    import net.hires.debug.Stats;

    
    [SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=30)]

    public class GradationTest1 extends Sprite {
        private var _video:Video;
        private var _bd:BitmapData;
        private var _grad:Gradation;
        private var _shp:Shape;
        private var _dmf:DisplacementMapFilter;
        
        public function GradationTest1() {
            var camera:Camera = Camera.getCamera();
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            _shp = new Shape();
            addChild(_shp);
            
            if (camera != null) {
                _video = new Video(465, 465);
                _video.attachCamera(camera);
                _video.alpha = 0.9;
                addChild(_video);
            }
            // Gradationクラスを作る。任意の数のカラー値を渡すことができる。
            _grad = new Gradation(0xff0000, 0x00ff00, 0x0000ff);
            _bd = new BitmapData(465, 465);
           timer.start();
            _dmf = new DisplacementMapFilter(_bd, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.RED, 50, 50, DisplacementMapFilterMode.IGNORE);
           
            if (_video) {
                //removeChild(_shp);
                _video.filters = [_dmf];
            }
            addChild(new Stats());
        }
        
        private function onTimer(e:TimerEvent):void 
        {
            _bd.lock();
            var n:int = Timer(e.target).currentCount % 49;
            n = (n > 25) ? 48 - n : n;
            n += 10;
            n = 12000 / n;
            trace("onTimer", n);
            _shp.graphics.clear();
            var vy:int = 300;
            var vx:int = 0;
            var v:Number;

            for (var y:int = 0; y < 465; y++) {
                // getColorでグラデーションを構成する中間色を取り出す。渡す値は0〜1。滑らかにこの値を変化させることでグラデーションを作り出す。
                vy -= vx * 0.02;
                vx += vy * 0.02;
                v = (y * 12 / n) % 2;
                v = (v > 1) ? 2 - v : v;
                _shp.graphics.beginFill(_grad.getColor(v));
                _shp.graphics.drawCircle(mouseX + vx, mouseY + vy, (465 - y) * 1.2);
                _shp.graphics.endFill();
            }
            _bd.draw(_shp);
            _bd.unlock();
            _dmf.mapBitmap = _bd;
        }
    }
}


import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}