/**
 * Copyright tonsmart5 ( http://wonderfl.net/user/tonsmart5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2BRv
 */

// forked from ProjectNya's SoundMixer.computeSpectrumとByteArray (7)
////////////////////////////////////////////////////////////////////////////////
// SoundMixer.computeSpectrumとByteArray (7)
//
// SoundMixer.computeSpectrum(byteArray, true, 1);
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var sound:Sound;
        private var channel:SoundChannel;
        private static var soundPath:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";
        private var byteArray:ByteArray;
        private static var channels:uint = 256;
        private var waves:Array;
        private var wave1:SoundWave;
        private var wave2:SoundWave;

        public function Main() {
            Wonderfl.capture_delay(10);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
            byteArray = new ByteArray();
            waves = new Array();
            wave1 = new SoundWave()
            wave1.x = 7;
            wave1.y = 132;
            wave1.init(450, 100);
            addChild(wave1);
            waves.push(wave1);
            wave2 = new SoundWave();
            wave2.x = 7;
            wave2.y = 332;
            wave2.init(450, 100);
            waves.push(wave2);
            addChild(wave2);
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }
        private function start():void {
            channel = sound.play(0, 1000);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            SoundMixer.computeSpectrum(byteArray, true, 1);
            for (var c:uint = 0; c < 2; c++) {
                var wave:SoundWave = waves[c];
                for (var n:uint = 0; n < channels; n++) {
                    var p:Number = byteArray.readFloat();
                    wave.update(p);
                }
            }
        }

    }

}


import flash.display.Shape;

class SoundWave extends Shape {
    private var _width:uint;
    private var _height:uint;
    private var unit:Number;
    private var position:uint = 0;
    private static var channels:uint = 256;

    public function SoundWave() {
    }
    public function init(w:uint, h:uint):void {
        _width = w;
        _height = h;
        unit = _width/channels;
    }
    public function update(p:Number):void {
        if (position == 0) {
            graphics.clear();
            graphics.lineStyle(0, 0xFFFFFF);
            graphics.moveTo(unit*position, - p*_height);
        }
        graphics.lineTo(unit*position, - p*_height);
        position ++;
        if (position == channels) {
            position = 0;
        }
    }

}