/**
 * Copyright CoremindJP ( http://wonderfl.net/user/CoremindJP )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2Ap9
 */

// forked from hamuhamu's cast speed
// プリミティブじゃないインスタンスを生成するようなループではArrayでもVectorでも速度変わらないのかなぁ？
// Vectorは型指定してる配列だからキャストしなくても速度落ちないと思ってたけどVectorでもキャストした方が良いんですね・・・
// arrayの初期化は[]が速いけどVectorはnewの方が速い
package
{
    import flash.events.Event;
    import flash.utils.getTimer;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    public class FlashTest extends Sprite
    {
        private static const LOOP:int = 10000;
        
        private var
            tf:TextField,
            time:int,
            array:Array,
            vector:Vector.<Cast>;
        
        public function FlashTest()
        {
            tf = new TextField();
            tf.addEventListener( "click", init );
            tf.selectable = false;
            tf.background = true;
            tf.backgroundColor = 0x0000FF;
            tf.textColor = 0xFFFFFF;
            tf.width = tf.height = 465;
            this.addChild( tf );
            
            this.addEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        public function init( event:Event ):void
        {
            var
                i:int = 0,
                _vector:Vector.<Cast> = vector,
                _array:Array = array,
                _length:int = LOOP,
                _instanceBuffer:Cast;
                
            tf.text = _length + "ループ\n";
    //初期化速度
            tf.appendText( "<INIT>\n" );
        //Array
            tf.appendText( "\t<ARRAY>\n" );
            //newで初期化
            tf.appendText( "\t\tnew = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
                _array = new Array();
            tf.appendText( String( getTimer() - time ) + "\n" );
            //[]で初期化
            tf.appendText( "\t\t[] = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
                _array = [];
            tf.appendText( String( getTimer() - time ) + "\n" );
        //Vector
            tf.appendText( "\t<VECTPR>\n" );
            //長さ指定無しnewで初期化
            tf.appendText( "\t\tnew = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
                _vector = new Vector.<Cast>();
            tf.appendText( String( getTimer() - time ) + "\n" );
            //長さ指定有りでnewで初期化
            tf.appendText( "\t\tnew & 100Length = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
                _vector = new Vector.<Cast>(100);
            tf.appendText( String( getTimer() - time ) + "\n" );
            //長さ指定無し[]で初期化
            tf.appendText( "\t\t[] = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
                _vector = Vector.<Cast>([]);
            tf.appendText( String( getTimer() - time ) + "\n" );
            //長さ指定有り[]で初期化
            tf.appendText( "\t\t[] & 100Length = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
            {
                _vector = Vector.<Cast>([]);
                _vector.length = 100;
            }
            tf.appendText( String( getTimer() - time ) + "\n" );
            
    //要素追加処理速度
            tf.appendText( "<SET>\n" );
        //Array
            tf.appendText( "\t<ARRAY>\n" );
            //pushで追加
            tf.appendText( "\t\tpush = " );
            array = [];
            time = getTimer();
            for( i = 0; i < _length; i++ )
               array.push( new Cast() );
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //lengthをインデックスにして追加
            tf.appendText( "\t\tlength = " );
            array = [];
            time = getTimer();
            for( i = 0; i < _length; i++ )
               array[array.length] = new Cast();
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //ループidをインデックスにして追加
            tf.appendText( "\t\tloopID = " );
            array = [];
            time = getTimer();
            for( i = 0; i < _length; i++ )
               array[i] = new Cast();
            tf.appendText( String( getTimer() - time ) + "\n" );
            
        //Vector
            tf.appendText( "\t<VECTOR>\n" );
            //pushで追加
            tf.appendText( "\t\tpush = " );
            vector = Vector.<Cast>([]);
            time = getTimer();
            for( i = 0; i < _length; i++ )
               vector.push( new Cast() );
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //lengthをインデックスにして追加
            tf.appendText( "\t\tlength = " );
            vector = Vector.<Cast>([]);
            time = getTimer();
            for( i = 0; i < _length; i++ )
               vector[vector.length] = new Cast();
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //ループidをインデックスにして追加
            tf.appendText( "\t\tloopID = " );
            vector = Vector.<Cast>([]);
            time = getTimer();
            for( i = 0; i < _length; i++ )
               vector[i] = new Cast();
            tf.appendText( String( getTimer() - time ) + "\n" );            
            
            //ループidをインデックスにして追加 fixedメソッドも入れてみる
            tf.appendText( "\t\tloopID & fixed = " );
            vector = Vector.<Cast>([]);
            vector.length = _length;
            vector.fixed = true;
            time = getTimer();
            for( i = 0; i < _length; i++ )
               vector[i] = new Cast();
            tf.appendText( String( getTimer() - time ) + "\n" ); 
            vector.fixed = false;
                       
    //要素取得処理
            tf.appendText( "<GET>\n" );
        //Array
            tf.appendText( "\t<ARRAY>\n" );
            //直で操作
            tf.appendText( "\t\t array = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
            {
                array[i].a;
                array[i].b;
                array[i].c;
                array[i].d;
                array[i].e;
            }
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //cast型の変数に代入してから操作
            tf.appendText( "\t\tvariableCast = " );
            _instanceBuffer = null;
            time = getTimer();
            for( i = 0; i < _length; i++ )
            {
                _instanceBuffer = array[i];
                _instanceBuffer.a;
                _instanceBuffer.b;
                _instanceBuffer.c;
                _instanceBuffer.d;
                _instanceBuffer.e;
            }
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //asでキャストした後操作
            tf.appendText( "\t\tas Cast = " );
            _instanceBuffer = null;
            time = getTimer();
            for( i = 0; i < _length; i++ )
            {
                _instanceBuffer = array[i] as Cast;
                _instanceBuffer.a;
                _instanceBuffer.b;
                _instanceBuffer.c;
                _instanceBuffer.d;
                _instanceBuffer.e;
            }
            tf.appendText( String( getTimer() - time ) + "\n" );
            
        //Vector
            tf.appendText( "\t<VECTOR>\n" );
            //直で操作
            tf.appendText( "\t\tvector = " );
            time = getTimer();
            for( i = 0; i < _length; i++ )
            {
                vector[i].a;
                vector[i].b;
                vector[i].c;
                vector[i].d;
                vector[i].e;
            }
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //cast型の変数に代入してから操作
            tf.appendText( "\t\tvariableCast = " );
            _instanceBuffer = null;
            time = getTimer();
            for( i = 0; i < _length; i++ )
            {
                _instanceBuffer = vector[i];
                _instanceBuffer.a;
                _instanceBuffer.b;
                _instanceBuffer.c;
                _instanceBuffer.d;
                _instanceBuffer.e;
            }
            tf.appendText( String( getTimer() - time ) + "\n" );
            
            //asでキャストした後操作
            tf.appendText( "\t\tas Cast = " );
            _instanceBuffer = null;
            time = getTimer();
            for( i = 0; i < _length; i++ )
            {
                _instanceBuffer = vector[i] as Cast;
                _instanceBuffer.a;
                _instanceBuffer.b;
                _instanceBuffer.c;
                _instanceBuffer.d;
                _instanceBuffer.e;
            }
            tf.appendText( String( getTimer() - time ) + "\n" );            
            tf.appendText( "クリックで再ループ\n" );
        }
    }
    
}

class Cast
{
    public var
        a:String,
        b:int,
        c:Boolean,
        d:uint,
        e:Number;
        
    public function Cast()
    {
    }
}    
