/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/2AZH
 */

// forked from maksim.vi's Z-fighting problem
// When the inner object is slightly bigger than outer, I see Z-Fighting. I tried to put objects on separate layers, but obviously it doesn't help.
// Thanks.

// You can use the quad-tree renderer (but performance may suffer...)

package {

    import flash.events.*;
    import flash.system.Security;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.objects.parsers.Max3DS;
    import org.papervision3d.view.stats.StatsView;
    import org.papervision3d.view.layer.util.ViewportLayerSortMode;
    import org.papervision3d.view.layer.ViewportLayer;
    import org.papervision3d.render.QuadrantRenderEngine;

    import gs.TweenLite;
    
    public class FlashTest extends BasicView {
        private var innerModel:Max3DS;
        private var outerModel:Max3DS;
        private var topLayer:ViewportLayer;
        private var bottomLayer:ViewportLayer;
        private var isOrbiting:Boolean = false;
        private var previousMouseX:Number;
        private var previousMouseY:Number;
        private var cameraPitch:Number = 90;
        private var cameraYaw:Number = 270;
        private var isScrolling:Boolean = false;
               
        [SWF(width="550",height="550",backgroundColor="#101010")]
        public function FlashTest() {
            super(550,550,true, false, CameraType.FREE);
            renderer = new QuadrantRenderEngine;

            topLayer = new ViewportLayer(viewport, null);
            bottomLayer = new ViewportLayer(viewport, null);   
            
            viewport.containerSprite.addLayer(topLayer);
            viewport.containerSprite.addLayer(bottomLayer);  
            
            viewport.containerSprite.sortMode = ViewportLayerSortMode.INDEX_SORT;
            topLayer.layerIndex = 1;
            bottomLayer.layerIndex = 2;           
                                   
            var s:StatsView = new StatsView(renderer);
            addChild(s);
            init();           
        }
        
        public function init():void
        {
            camera.orbit(60, 100);  
            
            outerModel = new Max3DS();
            outerModel.load("http://qawww.utherverse.com/wonderfl/outer.3ds", null, "http://qawww.utherverse.com/wonderfl/");
            outerModel.useClipping = false;
            outerModel.scale = 0.2;
            scene.addChild(outerModel);
            topLayer.addDisplayObject3D(outerModel, true);
            
            
            innerModel = new Max3DS();
            innerModel.load("http://qawww.utherverse.com/wonderfl/inner.3ds", null, "http://qawww.utherverse.com/wonderfl/");
            innerModel.useClipping = false;
            innerModel.scale = 0.2;
            scene.addChild(innerModel);
            bottomLayer.addDisplayObject3D(innerModel, true);
            
            viewport.buttonMode = true;
            viewport.addEventListener(MouseEvent.MOUSE_WHEEL, onMouseScroll);
            viewport.addEventListener(MouseEvent.MOUSE_DOWN, onMousePressed);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseReleased);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoved);
            
            addEventListener(Event.ENTER_FRAME, tick);
        }
        
        private function tick(e:Event):void
        {
            if(!isOrbiting)
            {
                innerModel.yaw(1*500*Math.PI/360);
                outerModel.yaw(-1*500*Math.PI/360);
            }
          
            singleRender();
        }
        
        
        protected function onMousePressed(event:MouseEvent):void {
            isOrbiting = true;
            
             previousMouseX = event.stageX;
             previousMouseY = event.stageY; 
        }

        protected function onMouseReleased(event:MouseEvent):void {
            isOrbiting = false;
        }


        protected function onMouseMoved(event:MouseEvent):void
         {           
             if(isOrbiting)
             {
                 var differenceX:Number = event.stageX - previousMouseX;
                 var differenceY:Number = event.stageY - previousMouseY;
             
                 cameraPitch -= differenceY;
                 cameraYaw -= differenceX;
  
                 cameraPitch %= 360;
                 cameraYaw %= 360;
                
                 if (cameraPitch > 0) {
                     cameraPitch = cameraPitch;
                 }
                 else {
                     cameraPitch = 0.0001;   
                 }
                
                 if (cameraPitch < 90) {
                     cameraPitch = cameraPitch;
                 }
                 else {
                     cameraPitch = 89.9999;
                 }
                
                 previousMouseX = stage.mouseX;
                 previousMouseY = stage.mouseY;
  
                 camera.orbit(cameraPitch, cameraYaw);  
             }
         }
         
         protected function onMouseScroll(evt:MouseEvent):void {
            if(!isScrolling)
            {
                var zoomOffset:Number = camera.zoom + ((evt.delta>0)?1:-1)*25;
                zoomOffset = (zoomOffset>125)?125:(zoomOffset < 25)?25:zoomOffset;
                isScrolling = true;
                TweenLite.to(camera, 0.5, { zoom:zoomOffset, onComplete: zoomOver });
            }
        }
                
        protected function zoomOver():void {
            isScrolling = false;
        }
    }
}