/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/29cP
 */

// forked from royi's Air Acrobatics
package {
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.filters.BitmapFilter;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.*;
    import flash.events.*;
    import com.bit101.components.*;
    
    [SWF(width=465, height=465, frameRate=40)]
    public class Funky extends Sprite {
        private var g:Graphics;
        private var t:Number = 0;
        private var count:int = 1;
        private var debug:Label;
        private var sprite:Sprite = new Sprite();
        private var bmd:BitmapData;
        private var oldX:Number = 0, oldY:Number = 0;
        private var filter:BitmapFilter;
        private var sw:int, sh:int;
        private var noise:BitmapData;
        private var octaves:int = 2;
        private var offsets:Array = [];
        private var velocities:Array = [];
        private var seed:int;
        //private var color:uint = 0xcc88ff;
        public function Funky() {
            sw = stage.stageWidth, sh = stage.stageHeight;
            debug = new Label(this);
            
            seed = Math.random() * int.MAX_VALUE;
            for (var i:int = 0; i < octaves; i++) {
                offsets[i] = new Point();
                velocities[i] = new Point(Math.random()*4-2, Math.random()*4-2);
            }

            noise = new BitmapData(sw, sh, false);
            //var noiseBmp:Bitmap = new Bitmap(noise);
            //addChild(noiseBmp);
            
            bmd = new BitmapData(sw, sh, false, 0x000000);
            var bmp:Bitmap = new Bitmap(bmd);
            addChild(bmp);
            
            //addChild(sprite);
            g = sprite.graphics;
            
            //filter = new BlurFilter(3,3,1);
            filter = new DisplacementMapFilter(noise, new Point(), 0, 1, 0, 1, DisplacementMapFilterMode.IGNORE, 0xff0000, 1);
            
            oldX = (Math.sin(t)+ Math.cos(t*.9))*100;
            oldY = (Math.cos(t)+ Math.sin(t*.6))*100;
            oldX += sw * .5;
            oldY += sh * .5;

            RGBWheel.s = 0.5;
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            t += .1;
            var x:Number = (Math.sin(t)+ Math.cos(t*.9))*100;
            var y:Number = (Math.cos(t)+ Math.sin(t*.6))*100;
            x += sw * .5;
            y += sh * .5;
            draw( x, y, (Math.sin(t)+2) * 20, RGBWheel.getRadianColor(t/10));
            oldX = x, oldY = y;
        }
        
        private function draw(x:Number, y:Number, size:Number, color:uint):void {
            for (var i:int = 0; i < octaves; i++) {
                offsets[i].x += velocities[i].x;
                offsets[i].y += velocities[i].y;
            }
            noise.perlinNoise(40, 40, octaves, seed, true, true, 15, false, offsets);
            g.clear();
            g.lineStyle(size, color);
            g.moveTo(oldX, oldY);
            g.lineTo(x, y);
            bmd.draw(sprite);
            bmd.applyFilter(bmd, bmd.rect, new Point(), filter);
            //bmd.scroll(0, 1);
            
            //debug.text = String(count);
        }
    }
}

//package aquioux.display.colorUtil {
    //import aquioux.math.MathConst;
    /**
     * コサインカーブで色相環的に RGB を計算
     * @author YOSHIDA, Akio
     */
    /*public*/ class RGBWheel {
        /**
         * 彩度（HSV の彩度 S と同じ扱い）
         */
        static public function get s():Number { return _s; }
        static public function set s(value:Number):void {
            if (value < 0.0) value = 0.0;
            if (value > 1.0) value = 1.0;
            _s = value;
        }
        static private var _s:Number = 1.0;
        /**
         * 明度（HSV の明度 V と同じ扱い）
         */
        static public function get v():Number { return _v; }
        static public function set v(value:Number):void {
            if (value < 0.0) value = 0.0;
            if (value > 1.0) value = 1.0;
            _v = value;
        }
        static private var _v:Number = 1.0;

        /**
         * 角度 angle に応じた RGB を得る（弧度法指定 radian）
         * @param    radian    角度（弧度法）
         * @return    色（0xRRGGBB）
         */
        static public function getRadianColor(radian:Number):uint {
            var r:uint = (Math.cos(radian)                      + 1) * 0xff >> 1;
            var g:uint = (Math.cos(radian + 2.0943951023931953) + 1) * 0xff >> 1;
            var b:uint = (Math.cos(radian - 2.0943951023931953) + 1) * 0xff >> 1;
            // 2.0943951023931953 = Math.PI * 2 / 3 radian（= 120 degree）
            if (_s != 1.0) {
                r += shiftS(r);
                g += shiftS(g);
                b += shiftS(b);
            }
            if (_v != 1.0) {
                r -= shiftV(r);
                g -= shiftV(g);
                b -= shiftV(b);
            }
            return r << 16 | g << 8 | b;
        }
        /**
         * 角度 angle に応じた RGB を得る（度数法指定 degree）
         * @param    degree    角度（度数法）
         * @return    色（0xRRGGBB）
         */
        static public function getDegreeColor(degree:Number):uint {
            return getRadianColor(degree * 0.017453292519943295);
        }

        /**
         * 彩度の反映
         * @param    gray    諧調（0～255）
         * @return    諧調のシフト値
         * @private
         */
        static private function shiftS(gray:uint):uint {
            return (0xff - gray) * (1 - _s) >> 0;
        }
        /**
         * 明度の反映
         * @param    gray    諧調（0～255）
         * @return    諧調のシフト値
         * @private
         */
        static private function shiftV(gray:uint):uint {
            return gray * (1 - _v) >> 0;
        }
    }
//}
