/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/29Jv
 */

package {
    import flash.text.TextField;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
       
           deb = new TextField();
           deb.width=320;deb.height=240;
           deb.mouseEnabled=false;
           addChild(deb);
       
           stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
           stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
           stage.addEventListener(Event.ENTER_FRAME, onEnter);     
        }//ctor
   
       public var deb:TextField;
        
           public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
            public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
            public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
            public function isKeyDown(k:int):Boolean { return vecKey[k]; }     

        
        public var cx:Number = 230;
        public var cy:Number = 230;
        public var ang:Number = 0;
        
        public  function angDiff(a:Number, b:Number):Number
        { a -= b;      if (a > 3.14) { a -= 6.28; }      if (a < -3.14) { a += 6.28;}      return a;  }

        public function onEnter(e:Event):void
        {
            var ms:Number; ms =8;
            var dx:Number; var dy:Number;
            dx=0;dy=0;
            if (isKeyDown(Keyboard.UP)) { cy -= ms; dy=-1;   }
            if (isKeyDown(Keyboard.DOWN)) { cy += ms; dy=1;  }
            if (isKeyDown(Keyboard.LEFT)) { cx -= ms; dx=-1; }
            if (isKeyDown(Keyboard.RIGHT)) { cx += ms; dx=1; }
            
            if (dx != 0 || dy != 0)
            { ang = Math.atan2(dy,dx); }
            
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            var mx:Number; var my:Number;
            mx = stage.mouseX;
            my = stage.mouseY;
            
            var ma:Number;
            
            ma = Math.atan2(my-cy, mx-cx);
            
            
            graphics.drawCircle(mx,my, 8);
            
            graphics.drawCircle(cx,cy, 16);
            
            graphics.moveTo(cx,cy);
            graphics.lineTo(cx+Math.cos(ang)*16, cy+Math.sin(ang)*16);
         
            graphics.moveTo(cx,cy);
            graphics.lineTo(mx, my);
            
            //graphics.lineTo(cx+Math.cos(ma)*16, cy+Math.sin(ma)*16);
            
            var mode:int;
            var d:Number;
            d = Math.abs(angDiff(ang, ma));
            mode = 1;
            if (d < 1) { mode = 0;}
            if (d > 2) { mode = 2;}
            
            deb.text = " " +angDiff(ang, ma).toFixed(4) + "\n " + mode;
            
            
        }//onenter
        
    }//classend
}